/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.netbeans.modules.javadoc.search.DocFileSystem;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.netbeans.modules.javadoc.search.JavaDocFSSettings;
import org.netbeans.modules.javadoc.search.JavadocSearchEngine;
import org.netbeans.modules.javadoc.search.NoJavadocException;
import org.netbeans.modules.javadoc.search.SearchThreadJdk12;
import org.openide.filesystems.FileStateInvalidException;

class JavadocSearchEngineImpl
extends JavadocSearchEngine {
    private ArrayList tasks;
    private DocFileSystem[] docSystems;
    private IndexSearchThread.DocIndexItemConsumer diiConsumer;

    JavadocSearchEngineImpl() {
    }

    public void search(String[] stringArray, final JavadocSearchEngine.SearchEngineCallback searchEngineCallback) throws NoJavadocException {
        this.docSystems = DocFileSystem.getFolders();
        this.tasks = new ArrayList(this.docSystems.length);
        this.diiConsumer = new IndexSearchThread.DocIndexItemConsumer(){

            public void addDocIndexItem(DocIndexItem docIndexItem) {
                searchEngineCallback.addItem(docIndexItem);
            }

            public void indexSearchThreadFinished(IndexSearchThread indexSearchThread) {
                ((AbstractCollection)JavadocSearchEngineImpl.this.tasks).remove(indexSearchThread);
                if (JavadocSearchEngineImpl.this.tasks.isEmpty()) {
                    searchEngineCallback.finished();
                }
            }
        };
        if (this.docSystems.length <= 0) {
            searchEngineCallback.finished();
            throw new NoJavadocException();
        }
        String string = stringArray[0];
        int n = 0;
        while (n < this.docSystems.length) {
            try {
                JavaDocFSSettings javaDocFSSettings = JavaDocFSSettings.getSettingForFS(this.docSystems[n].getIndexFile().getFileSystem());
                IndexSearchThread indexSearchThread = javaDocFSSettings.getSearchTypeEngine().getSearchThread(string, this.docSystems[n].getIndexFile(), this.diiConsumer);
                this.tasks.add(indexSearchThread);
                indexSearchThread.go();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                fileStateInvalidException.printStackTrace();
            }
            ++n;
        }
    }

    public void stop() {
        int n = 0;
        while (n < this.tasks.size()) {
            SearchThreadJdk12 searchThreadJdk12 = (SearchThreadJdk12)this.tasks.get(n);
            searchThreadJdk12.finish();
            ++n;
        }
    }
}

