/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.httpfs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.netbeans.modules.javadoc.httpfs.HTTPFileObject;
import org.netbeans.modules.javadoc.httpfs.ResourceUtils;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.actions.SystemAction;

public class HTTPFileSystem
extends FileSystem
implements VetoableChangeListener {
    public static final String PROP_URL = "URL";
    private static final long serialVersionUID = 200104L;
    private static final String DEFAULT_URL = "http://www.netbeans.org/download/apis/";
    transient URL baseURL;
    transient HTTPFileObject rootFileObject;

    public HTTPFileSystem() {
        FileSystemCapability.Bean bean = new FileSystemCapability.Bean();
        bean.setDoc(true);
        bean.setExecute(false);
        bean.setCompile(false);
        bean.setDebug(false);
        this.setCapability((FileSystemCapability)bean);
        this.setHidden(true);
        this.addVetoableChangeListener(this);
        try {
            this.setURL(DEFAULT_URL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.baseURL.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setURL((String)objectInputStream.readObject());
    }

    public String getURL() {
        return this.baseURL.toString();
    }

    public synchronized void setURL(String string) throws IOException {
        URL uRL = this.baseURL;
        HTTPFileObject hTTPFileObject = this.rootFileObject;
        try {
            try {
                this.baseURL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException(malformedURLException.toString());
            }
            this.rootFileObject = new HTTPFileObject("/", this);
            this.fireVetoableChange(PROP_URL, uRL != null ? uRL.toExternalForm() : null, string);
            this.setSystemName(this.getClass().getName() + "/" + this.baseURL.toExternalForm());
        }
        catch (PropertyVetoException propertyVetoException) {
            this.baseURL = uRL;
            this.rootFileObject = hTTPFileObject;
            throw new IOException(propertyVetoException.getMessage());
        }
        this.firePropertyChange(PROP_URL, uRL != null ? uRL.toExternalForm() : null, string);
        this.firePropertyChange("root", hTTPFileObject, this.rootFileObject);
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (propertyChangeEvent.getSource() == this && propertyChangeEvent.getPropertyName().equals(PROP_URL)) {
            URL uRL;
            try {
                uRL = new URL((String)propertyChangeEvent.getNewValue());
            }
            catch (MalformedURLException malformedURLException) {
                throw new PropertyVetoException(malformedURLException.toString(), propertyChangeEvent);
            }
            if (!uRL.getProtocol().equals("http") && !uRL.getProtocol().equals("https")) {
                throw new PropertyVetoException(ResourceUtils.getBundledString("MSG_NotHTTPProtocol"), propertyChangeEvent);
            }
            if (!uRL.toExternalForm().endsWith("/")) {
                throw new PropertyVetoException(ResourceUtils.getBundledString("MSG_NotDirectory"), propertyChangeEvent);
            }
        }
    }

    public FileObject getRoot() {
        return this.rootFileObject;
    }

    public String getDisplayName() {
        return this.baseURL.toExternalForm();
    }

    public FileObject findResource(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        HTTPFileObject hTTPFileObject = (HTTPFileObject)this.getRoot();
        while (hTTPFileObject != null && stringTokenizer.hasMoreElements()) {
            hTTPFileObject = hTTPFileObject.child((String)stringTokenizer.nextElement());
        }
        return hTTPFileObject;
    }

    public boolean isReadOnly() {
        return true;
    }

    public SystemAction[] getActions() {
        return new SystemAction[0];
    }

    public void prepareEnvironment(FileSystem.Environment environment) throws EnvironmentNotSupportedException {
        throw new EnvironmentNotSupportedException((FileSystem)this);
    }

    protected void finalize() throws Throwable {
        this.removeVetoableChangeListener(this);
        this.rootFileObject = null;
        this.baseURL = null;
    }
}

