/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.versioning;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.lib.cvsclient.command.PipedFileInformation;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.cvsclient.FsCommandFactory;
import org.netbeans.modules.cvsclient.JavaCvsSettings;
import org.netbeans.modules.cvsclient.NbJavaCvsFileSystem;
import org.netbeans.modules.cvsclient.NbJavaCvsStatusManager;
import org.netbeans.modules.cvsclient.caching.NbCvsFsCache;
import org.netbeans.modules.cvsclient.commands.ErrorLogPanel;
import org.netbeans.modules.cvsclient.commands.JavaCvsRuntimeCommand;
import org.netbeans.modules.cvsclient.versioning.JavaCvsVersioningAction;
import org.netbeans.modules.javacvs.caching.CvsFsCache;
import org.netbeans.modules.javacvs.commands.AbstractWaitForResultsDisplayer;
import org.netbeans.modules.javacvs.commands.CvsLog;
import org.netbeans.modules.javacvs.commands.CvsUpdate;
import org.netbeans.modules.vcscore.annotation.AnnotationProvider;
import org.netbeans.modules.vcscore.annotation.AnnotationSupport;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.runtime.RuntimeCommand;
import org.netbeans.modules.vcscore.runtime.RuntimeSupport;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusEvent;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.modules.vcscore.versioning.impl.NumDotRevisionItem;
import org.netbeans.modules.vcscore.versioning.impl.NumDotRevisionList;
import org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode;
import org.openide.TopManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class JavaCvsVersioningSystem
extends VersioningFileSystem
implements CacheHandlerListener {
    private NbJavaCvsFileSystem fileSystem;
    private CvsFsCache fsCache;
    private VersioningFileSystem.Versions versions;
    private FileStatusListener fileStatus;
    private PropertyChangeListener propChange;
    private Hashtable revisionListsByName;
    private boolean showMessages = true;
    private int messageLength = 20;
    private String ignoreFiles = "~$|^\\.#";
    public static final String PROP_SHOW_DEAD_FILES = "showDeadFiles";
    public static final String PROP_SHOW_MESSAGES = "showMessages";
    public static final String PROP_MESSAGE_LENGTH = "messageLength";
    public static final String PROP_SHOW_UNIMPORTANT_FILES = "showUnimporantFiles";
    public static final String PROP_IGNORE_FILES = "ignoredFiles";
    private static final int BADGE_ICON_SHIFT_X = 16;
    private static final int BADGE_ICON_SHIFT_Y = 8;
    private VersStatus status;
    private File rootFile;
    private transient RE ignoredRE = null;
    private static final long serialVersionUID = 0L;
    private static Object vsActionAccessLock = new Object();
    private boolean showUnimportantFiles;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$JavaCvsSettings;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$versioning$JavaCvsVersioningAction;

    public JavaCvsVersioningSystem(NbJavaCvsFileSystem nbJavaCvsFileSystem, CvsFsCache cvsFsCache) {
        super((AbstractFileSystem)nbJavaCvsFileSystem);
        this.fileSystem = nbJavaCvsFileSystem;
        this.fsCache = cvsFsCache;
        try {
            this.setSystemName(nbJavaCvsFileSystem.getSystemName());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        ((AbstractFileSystem)this).list = new VersioningList();
        ((AbstractFileSystem)this).info = nbJavaCvsFileSystem.getVcsInfo();
        ((AbstractFileSystem)this).change = new VersioningFileSystem.VersioningFSChange((VersioningFileSystem)this);
        ((AbstractFileSystem)this).attr = new JCvsVersAttributes();
        this.versions = new VersioningVersions();
        this.status = new VersStatus();
        this.revisionListsByName = new Hashtable();
        this.initListeners();
        this.setCapability(null);
        this.rootFile = nbJavaCvsFileSystem.getRootDirectory();
        try {
            this.ignoredRE = new RE(this.ignoreFiles);
        }
        catch (RESyntaxException rESyntaxException) {
            this.ignoredRE = null;
        }
    }

    private void initListeners() {
        this.fileStatus = new FileStatusListener(){

            public void annotationChanged(FileStatusEvent fileStatusEvent) {
                JavaCvsVersioningSystem.this.fireMyFileStatusChanged(fileStatusEvent);
            }
        };
        this.propChange = new FSPropertyChangeListener();
        this.fileSystem.addFileStatusListener(WeakListener.fileStatus((FileStatusListener)this.fileStatus, (Object)((Object)this.fileSystem)));
        this.fileSystem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propChange, (Object)((Object)this.fileSystem)));
        JavaCvsSettings javaCvsSettings = (JavaCvsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$cvsclient$JavaCvsSettings == null ? (class$org$netbeans$modules$cvsclient$JavaCvsSettings = JavaCvsVersioningSystem.class$("org.netbeans.modules.cvsclient.JavaCvsSettings")) : class$org$netbeans$modules$cvsclient$JavaCvsSettings), (boolean)true);
        javaCvsSettings.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propChange, (Object)((Object)javaCvsSettings)));
        this.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propChange, (Object)((Object)this)));
    }

    public void addNotify() {
        super.addNotify();
        this.propagatePropertyChange(new String[]{PROP_MESSAGE_LENGTH, PROP_SHOW_MESSAGES, PROP_IGNORE_FILES});
    }

    public void removeNotify() {
        super.removeNotify();
        this.fileSystem = null;
        this.fsCache = null;
    }

    private void fireMyFileStatusChanged(FileStatusEvent fileStatusEvent) {
        JavaCvsVersioningSystem javaCvsVersioningSystem = this;
        synchronized (javaCvsVersioningSystem) {
            Enumeration enumeration = this.revisionListsByName.keys();
            while (enumeration.hasMoreElements()) {
                FileObject fileObject;
                String string = (String)enumeration.nextElement();
                NbJavaCvsFileSystem nbJavaCvsFileSystem = this.fileSystem;
                if (nbJavaCvsFileSystem == null || (fileObject = nbJavaCvsFileSystem.findResource(string)) == null || !fileStatusEvent.hasChanged(fileObject)) continue;
                RevisionList revisionList = (RevisionList)this.revisionListsByName.get(string);
                AnnotationProvider annotationProvider = (AnnotationProvider)fileObject.getAttribute("AnnotationProviderObject");
                this.updateRevisionList(revisionList, annotationProvider, fileObject);
            }
        }
        this.fireFileStatusChanged(fileStatusEvent);
    }

    protected File getFile(String string) {
        if (string.length() > 0) {
            return new File(this.rootFile, string);
        }
        return new File(this.rootFile.getAbsolutePath());
    }

    private void updateRevisionList(RevisionList revisionList, AnnotationProvider annotationProvider, FileObject fileObject) {
        RevisionList revisionList2;
        Iterator iterator = revisionList.iterator();
        String string = annotationProvider.getAttributeValue(fileObject.getPackageNameExt('/', '.'), "revision");
        boolean bl = false;
        while (iterator.hasNext()) {
            revisionList2 = (RevisionItem)iterator.next();
            if (revisionList2.isCurrent()) {
                if (!revisionList2.getRevision().equals(string)) {
                    revisionList2.setCurrent(false);
                    continue;
                }
                bl = true;
                continue;
            }
            if (!revisionList2.getRevision().equals(string)) continue;
            revisionList2.setCurrent(true);
            bl = true;
        }
        if (!bl) {
            revisionList2 = revisionList;
            final String string2 = fileObject.getPackageNameExt('/', '.');
            VersioningDataNode.getVersioningRequestProcessor().post(new Runnable(){

                public void run() {
                    VersioningVersions versioningVersions = (VersioningVersions)JavaCvsVersioningSystem.this.getVersions();
                    RevisionList revisionList = versioningVersions.createRevisionList(string2);
                    if (revisionList2 != null) {
                        ArrayList arrayList = new ArrayList(revisionList);
                        RevisionList revisionList22 = revisionList2;
                        synchronized (revisionList22) {
                            ArrayList arrayList2 = new ArrayList(revisionList2);
                            ((AbstractCollection)arrayList).removeAll((Collection<?>)revisionList2);
                            revisionList2.addAll(arrayList);
                            ((AbstractCollection)arrayList2).removeAll((Collection<?>)revisionList);
                            revisionList2.removeAll(arrayList2);
                        }
                    }
                }
            });
        }
    }

    public FileSystem.Status getStatus() {
        return this.status;
    }

    public VersioningFileSystem.Versions getVersions() {
        return this.versions;
    }

    public FileStatusProvider getFileStatusProvider() {
        return new StatusProvider();
    }

    public boolean isShowDeadFiles() {
        return false;
    }

    public void setShowDeadFiles(boolean bl) {
        this.firePropertyChange(PROP_SHOW_DEAD_FILES, new Boolean(!bl), new Boolean(bl));
    }

    public String getIgnoredFiles() {
        return this.ignoreFiles;
    }

    public synchronized void setIgnoredFiles(String string) throws IllegalArgumentException {
        if (!string.equals(this.ignoreFiles)) {
            if (string.length() > 0) {
                try {
                    this.ignoredRE = new RE(string);
                }
                catch (RESyntaxException rESyntaxException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    TopManager.getDefault().getErrorManager().annotate((Throwable)illegalArgumentException, (Throwable)rESyntaxException);
                    throw illegalArgumentException;
                }
            } else {
                this.ignoredRE = null;
            }
            this.ignoreFiles = string;
            this.firePropertyChange(PROP_IGNORE_FILES, null, string);
            this.refreshExistingFolders();
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public SystemAction[] getRevisionActions(FileObject fileObject, Set set) {
        JavaCvsVersioningAction javaCvsVersioningAction = (JavaCvsVersioningAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$cvsclient$versioning$JavaCvsVersioningAction == null ? (class$org$netbeans$modules$cvsclient$versioning$JavaCvsVersioningAction = JavaCvsVersioningSystem.class$("org.netbeans.modules.cvsclient.versioning.JavaCvsVersioningAction")) : class$org$netbeans$modules$cvsclient$versioning$JavaCvsVersioningAction), (boolean)true);
        Object object = vsActionAccessLock;
        synchronized (object) {
            javaCvsVersioningAction.setFileSystem(this.fileSystem);
            javaCvsVersioningAction.setFileObject(this.fileSystem.findResource(fileObject.getPackageNameExt('/', '.')));
            javaCvsVersioningAction.setSelectedRevisionItems(set);
        }
        return new SystemAction[]{javaCvsVersioningAction};
    }

    private void vcsStatusChanged(String string, boolean bl) {
        FileObject fileObject = this.findExistingResource(string);
        if (fileObject == null) {
            return;
        }
        Enumeration enumeration = fileObject.getChildren(bl);
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        while (enumeration.hasMoreElements()) {
            fileObject = (FileObject)enumeration.nextElement();
            hashSet.add(fileObject);
        }
        Set set = Collections.synchronizedSet(hashSet);
        this.fireVcsFileStatusChanged(new VcsFileStatusEvent((VersioningFileSystem)this, set));
    }

    public void vcsStatusChanged(String string) {
        FileObject fileObject = this.findExistingResource(string);
        if (fileObject == null) {
            return;
        }
        this.fireVcsFileStatusChanged(new VcsFileStatusEvent((VersioningFileSystem)this, Collections.singleton(fileObject)));
    }

    public void statusChanged(CacheHandlerEvent cacheHandlerEvent) {
        NbJavaCvsFileSystem nbJavaCvsFileSystem = this.fileSystem;
        if (nbJavaCvsFileSystem == null) {
            return;
        }
        String string = nbJavaCvsFileSystem.getRootDirectory().getAbsolutePath();
        String string2 = cacheHandlerEvent.getCacheFile().getAbsolutePath();
        if (string2.startsWith(string)) {
            String string3 = string.length() == string2.length() ? "" : string2.substring(string.length() + 1, string2.length());
            string3 = string3.replace(File.separatorChar, '/');
            if (cacheHandlerEvent.getCacheFile() instanceof CacheDir) {
                this.vcsStatusChanged(string3, cacheHandlerEvent.isRecursive());
            } else {
                this.vcsStatusChanged(string3);
            }
        }
    }

    public void cacheRemoved(CacheHandlerEvent cacheHandlerEvent) {
    }

    public void cacheAdded(CacheHandlerEvent cacheHandlerEvent) {
    }

    public boolean isShowMessages() {
        return this.showMessages;
    }

    public void setShowMessages(boolean bl) {
        if (this.showMessages != bl) {
            this.showMessages = bl;
            this.firePropertyChange(PROP_SHOW_MESSAGES, new Boolean(!bl), new Boolean(bl));
            this.redisplayRevisions();
        }
    }

    private void redisplayRevisions() {
        Iterator iterator = this.revisionListsByName.values().iterator();
        while (iterator.hasNext()) {
            RevisionList revisionList = (RevisionList)iterator.next();
            Iterator iterator2 = revisionList.iterator();
            while (iterator2.hasNext()) {
                RevisionItem revisionItem = (RevisionItem)iterator2.next();
                if (this.isShowMessages()) {
                    if (revisionItem.getMessage() == null) continue;
                    revisionItem.setDisplayName(revisionItem.getRevision() + "  " + this.cutMessageString(revisionItem.getMessage()));
                    continue;
                }
                revisionItem.setDisplayName(revisionItem.getRevision());
            }
        }
    }

    private String cutMessageString(String string) {
        String string2 = string;
        if (string != null && string.length() > this.getMessageLength() + 3) {
            string2 = string.substring(0, this.getMessageLength()) + "...";
        }
        if (string2 != null) {
            string2 = string2.replace('\n', ' ');
        }
        return string2;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public void setMessageLength(int n) {
        int n2 = this.messageLength;
        this.messageLength = n;
        if (n < 0) {
            this.messageLength = 0;
        }
        this.firePropertyChange(PROP_MESSAGE_LENGTH, new Integer(n2), new Integer(n));
        this.redisplayRevisions();
    }

    public boolean isShowUnimportantFiles() {
        return this.showUnimportantFiles;
    }

    public void setShowUnimportantFiles(boolean bl) {
        if (this.showUnimportantFiles != bl) {
            this.showUnimportantFiles = bl;
            this.firePropertyChange(PROP_SHOW_UNIMPORTANT_FILES, new Boolean(!bl), new Boolean(bl));
            this.refreshExistingFolders();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class VersStatus
    implements FileSystem.Status {
        private VersStatus() {
        }

        public String annotateName(String string, Set set) {
            Iterator iterator = set.iterator();
            AnnotationProvider annotationProvider = null;
            FileObject fileObject = null;
            if (iterator.hasNext()) {
                fileObject = (FileObject)iterator.next();
                if (fileObject == null || fileObject.isRoot()) {
                    fileObject = null;
                } else {
                    annotationProvider = (AnnotationProvider)fileObject.getAttribute("AnnotationProviderObject");
                }
            }
            String string2 = string;
            if (annotationProvider != null && fileObject != null) {
                string2 = AnnotationSupport.getInstance().getStatusAnnotation(fileObject.getNameExt(), fileObject.getPackageNameExt('/', '.'), annotationProvider, "JavaCvs");
            }
            return string2;
        }

        public Image annotateIcon(Image image, int n, Set set) {
            Image image2;
            String string;
            Object object;
            int n2 = set.size();
            Vector<String> vector = new Vector<String>();
            Iterator iterator = set.iterator();
            if (iterator.hasNext() && (object = (FileObject)iterator.next()) != null) {
                vector.add(object.getPackageNameExt('/', '.'));
            }
            if (vector.size() == 0) {
                return image;
            }
            object = JavaCvsVersioningSystem.this.fsCache;
            if (object != null && (string = ((CvsFsCache)object).getFileStatusOnly(vector)) != null && (image2 = NbJavaCvsStatusManager.getInstance().getIcon(string)) != null) {
                image = Utilities.mergeImages((Image)image, (Image)image2, (int)16, (int)8);
            }
            return image;
        }
    }

    public class StatusProvider
    implements FileStatusProvider {
        public String getFileSticky(String string) {
            AnnotationProvider annotationProvider;
            FileObject fileObject = JavaCvsVersioningSystem.this.fileSystem.findResource(string);
            if (fileObject != null && (annotationProvider = (AnnotationProvider)fileObject.getAttribute("AnnotationProviderObject")) != null) {
                String string2 = annotationProvider.getAttributeValue(fileObject.getPackageNameExt('/', '.'), "sticky");
                return string2;
            }
            return "";
        }

        public String getFileTime(String string) {
            return "";
        }

        public String getLocalFileStatus() {
            return "";
        }

        public void refreshDir(String string) {
        }

        public String getNotInSynchStatus() {
            return "";
        }

        public String getFileRevision(String string) {
            AnnotationProvider annotationProvider;
            FileObject fileObject;
            if (JavaCvsVersioningSystem.this.fileSystem != null && (fileObject = JavaCvsVersioningSystem.this.fileSystem.findResource(string)) != null && (annotationProvider = (AnnotationProvider)fileObject.getAttribute("AnnotationProviderObject")) != null) {
                String string2 = annotationProvider.getAttributeValue(fileObject.getPackageNameExt('/', '.'), "revision");
                return string2;
            }
            return "";
        }

        public String getFileStatus(String string) {
            AnnotationProvider annotationProvider;
            FileObject fileObject;
            if (JavaCvsVersioningSystem.this.fileSystem != null && (fileObject = JavaCvsVersioningSystem.this.fileSystem.findResource(string)) != null && (annotationProvider = (AnnotationProvider)fileObject.getAttribute("AnnotationProviderObject")) != null) {
                String string2 = annotationProvider.getAttributeValue(fileObject.getPackageNameExt('/', '.'), "status");
                return string2;
            }
            return "";
        }

        public void setFileStatus(String string, String string2) {
        }

        public HashMap getStatusIconMap() {
            return null;
        }

        public String getFileDate(String string) {
            return "";
        }

        public HashMap getPossibleFileStatusesTable() {
            String[] stringArray;
            NbJavaCvsFileSystem nbJavaCvsFileSystem = JavaCvsVersioningSystem.this.fileSystem;
            if (nbJavaCvsFileSystem != null && (stringArray = nbJavaCvsFileSystem.getPossibleFileStatuses()) != null && stringArray.length > 0) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                int n = 0;
                while (n < stringArray.length) {
                    hashMap.put(stringArray[n], stringArray[n]);
                    ++n;
                }
                return hashMap;
            }
            return null;
        }

        public String getFileAttribute(String string) {
            return "";
        }

        public void setFileModified(String string) {
        }

        public void refreshDirRecursive(String string) {
        }

        public String getFileSize(String string) {
            return "";
        }

        public String getFileLocker(String string) {
            return "";
        }
    }

    private class JCvsVersAttributes
    extends VersioningFileSystem.VersioningAttrs {
        private JCvsVersAttributes() {
        }

        public Object readAttribute(String string, String string2) {
            FileObject fileObject;
            NbJavaCvsFileSystem nbJavaCvsFileSystem;
            if ("AnnotationProviderObject".equals(string2)) {
                CvsFsCache cvsFsCache = JavaCvsVersioningSystem.this.fsCache;
                if (cvsFsCache != null) {
                    return ((NbCvsFsCache)cvsFsCache).getAnnotationProvider(string);
                }
                return null;
            }
            Object object = super.readAttribute(string, string2);
            if (object == null && (nbJavaCvsFileSystem = JavaCvsVersioningSystem.this.fileSystem) != null && (fileObject = nbJavaCvsFileSystem.findResource(string)) != null) {
                object = fileObject.getAttribute(string2);
            }
            return object;
        }
    }

    private class FSPropertyChangeListener
    implements PropertyChangeListener {
        private FSPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if ("annotationPattern".equals(string)) {
                FileObject fileObject = JavaCvsVersioningSystem.this.findResource("");
                HashSet hashSet = new HashSet();
                Enumeration enumeration = JavaCvsVersioningSystem.super.existingFileObjects(fileObject);
                while (enumeration.hasMoreElements()) {
                    hashSet.add(enumeration.nextElement());
                }
                JavaCvsVersioningSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)JavaCvsVersioningSystem.this, hashSet, false, true));
                return;
            }
            if ("root".equals(string) && !propertyChangeEvent.getSource().equals((Object)JavaCvsVersioningSystem.this)) {
                String string2;
                JavaCvsVersioningSystem.this.rootFile = JavaCvsVersioningSystem.this.fileSystem.getRootDirectory();
                try {
                    string2 = JavaCvsVersioningSystem.this.getSystemName();
                    JavaCvsVersioningSystem.super.setSystemName(JavaCvsVersioningSystem.this.fileSystem.getSystemName());
                    JavaCvsVersioningSystem.super.firePropertyChange("systemName", string2, JavaCvsVersioningSystem.this.getSystemName());
                }
                catch (PropertyVetoException propertyVetoException) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)propertyVetoException);
                }
                string2 = JavaCvsVersioningSystem.super.refreshRoot();
                JavaCvsVersioningSystem.super.firePropertyChange("root", null, string2);
                return;
            }
            if ("systemName".equals(string) && !propertyChangeEvent.getSource().equals((Object)JavaCvsVersioningSystem.this)) {
                String string3 = JavaCvsVersioningSystem.this.getSystemName();
                try {
                    JavaCvsVersioningSystem.super.setSystemName(JavaCvsVersioningSystem.this.fileSystem.getSystemName());
                }
                catch (PropertyVetoException propertyVetoException) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)propertyVetoException);
                }
                FileObject fileObject = JavaCvsVersioningSystem.super.refreshRoot();
                JavaCvsVersioningSystem.super.firePropertyChange("systemName", string3, JavaCvsVersioningSystem.this.getSystemName());
                return;
            }
        }

        private void heyDoRefreshFolderRecursive(FileObject fileObject) {
            fileObject.refresh();
            Enumeration enumeration = fileObject.getFolders(true);
            while (enumeration.hasMoreElements()) {
                ((FileObject)enumeration.nextElement()).refresh();
            }
        }
    }

    private class VersioningVersions
    implements VersioningFileSystem.Versions {
        static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsLog;
        static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsUpdate;

        public RevisionList getRevisions(String string, boolean bl) {
            RevisionList revisionList = null;
            VersioningVersions versioningVersions = this;
            synchronized (versioningVersions) {
                revisionList = (RevisionList)JavaCvsVersioningSystem.this.revisionListsByName.get(string);
                if ((revisionList == null || bl) && (revisionList = this.createRevisionList(string)) != null) {
                    JavaCvsVersioningSystem.this.revisionListsByName.put(string, revisionList);
                }
            }
            return revisionList;
        }

        public RevisionList createRevisionList(String string) {
            FsCommandFactory fsCommandFactory = FsCommandFactory.getFsInstance();
            NbJavaCvsFileSystem nbJavaCvsFileSystem = JavaCvsVersioningSystem.this.fileSystem;
            if (nbJavaCvsFileSystem == null) {
                return null;
            }
            FileObject fileObject = nbJavaCvsFileSystem.findResource(string);
            if (fileObject != null) {
                AnnotationProvider annotationProvider;
                CvsLog cvsLog = (CvsLog)fsCommandFactory.createCommand(class$org$netbeans$modules$javacvs$commands$CvsLog == null ? (class$org$netbeans$modules$javacvs$commands$CvsLog = VersioningVersions.class$("org.netbeans.modules.javacvs.commands.CvsLog")) : class$org$netbeans$modules$javacvs$commands$CvsLog, false, new FileObject[]{fileObject}, nbJavaCvsFileSystem.createClientProvider());
                cvsLog.setRecursive(false);
                JavaCvsRuntimeCommand javaCvsRuntimeCommand = nbJavaCvsFileSystem.prepareCommand(cvsLog);
                javaCvsRuntimeCommand.setState(10);
                RuntimeSupport.getInstance().updateCommand(nbJavaCvsFileSystem.getSystemName(), (RuntimeCommand)javaCvsRuntimeCommand);
                cvsLog.addDisplayerListener(new ErrorLogPanel(cvsLog, true));
                AbstractWaitForResultsDisplayer abstractWaitForResultsDisplayer = new AbstractWaitForResultsDisplayer(cvsLog.getImpl());
                boolean bl = abstractWaitForResultsDisplayer.runAndWaitForFinish();
                if (bl) {
                    return null;
                }
                Object object = fileObject.getAttribute("AnnotationProviderObject");
                String string2 = "";
                if (object != null) {
                    annotationProvider = (AnnotationProvider)object;
                    string2 = annotationProvider.getAttributeValue(string, "revision");
                }
                annotationProvider = new NumDotRevisionList();
                Iterator iterator = abstractWaitForResultsDisplayer.getResultList().iterator();
                while (iterator.hasNext()) {
                    LogInformation logInformation = (LogInformation)iterator.next();
                    Iterator iterator2 = logInformation.getRevisionList().iterator();
                    while (iterator2.hasNext()) {
                        LogInformation.Revision revision = (LogInformation.Revision)iterator2.next();
                        NumDotRevisionItem numDotRevisionItem = new NumDotRevisionItem(revision.getNumber());
                        if (revision.getNumber().equals(string2)) {
                            numDotRevisionItem.setCurrent(true);
                        }
                        numDotRevisionItem.setAuthor(revision.getAuthor());
                        numDotRevisionItem.setDate(revision.getDateString());
                        numDotRevisionItem.setMessage(revision.getMessage());
                        if (JavaCvsVersioningSystem.this.isShowMessages()) {
                            numDotRevisionItem.setDisplayName(revision.getNumber() + "  " + JavaCvsVersioningSystem.this.cutMessageString(revision.getMessage()));
                        } else {
                            numDotRevisionItem.setDisplayName(revision.getNumber());
                        }
                        numDotRevisionItem.setTagNames(this.processTags(logInformation.getAllSymbolicNames(), revision.getNumber()));
                        annotationProvider.add((Object)numDotRevisionItem);
                        this.createBranchItems((RevisionList)annotationProvider, logInformation, revision);
                    }
                }
                return annotationProvider;
            }
            return null;
        }

        private void createBranchItems(RevisionList revisionList, LogInformation logInformation, LogInformation.Revision revision) {
            String string = revision.getNumber() + ".0.";
            Iterator iterator = logInformation.getAllSymbolicNames().iterator();
            while (iterator.hasNext()) {
                String[] stringArray;
                String string2;
                String string3;
                LogInformation.SymName symName = (LogInformation.SymName)iterator.next();
                if (symName.getRevision().startsWith(string)) {
                    string3 = symName.getRevision();
                    int n = string3.lastIndexOf(".0.");
                    string3 = string3.substring(0, n) + string3.substring(n + 2, string3.length());
                    string2 = new NumDotRevisionItem(string3);
                    string2.setDisplayName(string2.getRevision() + " (" + symName.getName() + ")");
                    stringArray = new String[]{symName.getName()};
                    string2.setTagNames(stringArray);
                    revisionList.add((Object)string2);
                    continue;
                }
                string3 = revision.getNumber();
                String string4 = symName.getRevision();
                if (!string4.startsWith(string3) || string3.length() >= string4.length() || (string2 = string4.substring(string3.length())).lastIndexOf(46) != 0) continue;
                stringArray = new NumDotRevisionItem(string4);
                stringArray.setDisplayName(stringArray.getRevision() + " (" + symName.getName() + ")");
                String[] stringArray2 = new String[]{symName.getName()};
                stringArray.setTagNames(stringArray2);
                revisionList.add((Object)stringArray);
            }
        }

        private String[] processTags(List list, String string) {
            Object object;
            LinkedList<String> linkedList = new LinkedList<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (LogInformation.SymName)iterator.next();
                if (!((LogInformation.SymName)object).getRevision().equals(string)) continue;
                linkedList.add(((LogInformation.SymName)object).getName());
            }
            object = new String[linkedList.size()];
            object = (String[])linkedList.toArray((T[])object);
            return object;
        }

        public InputStream inputStream(String string, String string2) throws FileNotFoundException {
            NbJavaCvsFileSystem nbJavaCvsFileSystem = JavaCvsVersioningSystem.this.fileSystem;
            if (nbJavaCvsFileSystem == null) {
                return null;
            }
            FsCommandFactory fsCommandFactory = FsCommandFactory.getFsInstance();
            FileObject fileObject = nbJavaCvsFileSystem.findResource(string);
            if (fileObject != null) {
                CvsUpdate cvsUpdate = (CvsUpdate)fsCommandFactory.createCommand(class$org$netbeans$modules$javacvs$commands$CvsUpdate == null ? (class$org$netbeans$modules$javacvs$commands$CvsUpdate = VersioningVersions.class$("org.netbeans.modules.javacvs.commands.CvsUpdate")) : class$org$netbeans$modules$javacvs$commands$CvsUpdate, false, new FileObject[]{fileObject}, nbJavaCvsFileSystem.createClientProvider());
                cvsUpdate.setRecursive(false);
                cvsUpdate.setPipeToOutput(true);
                cvsUpdate.setUpdateByRevision(string2);
                nbJavaCvsFileSystem.prepareCommand(cvsUpdate);
                cvsUpdate.addDisplayerListener(new ErrorLogPanel(cvsUpdate, false));
                AbstractWaitForResultsDisplayer abstractWaitForResultsDisplayer = new AbstractWaitForResultsDisplayer(cvsUpdate.getImpl());
                boolean bl = abstractWaitForResultsDisplayer.runAndWaitForFinish();
                if (bl) {
                    return null;
                }
                Iterator iterator = abstractWaitForResultsDisplayer.getResultList().iterator();
                if (iterator.hasNext()) {
                    PipedFileInformation pipedFileInformation = (PipedFileInformation)iterator.next();
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(pipedFileInformation.getTempFile()));
                        return bufferedInputStream;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return null;
                    }
                }
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class VersioningList
    implements AbstractFileSystem.List {
        private VersioningList() {
        }

        public String[] children(String string) {
            CvsFsCache cvsFsCache;
            File file = JavaCvsVersioningSystem.this.getFile(string);
            String[] stringArray = null;
            if (file != null && file.isDirectory() && (cvsFsCache = JavaCvsVersioningSystem.this.fsCache) != null) {
                stringArray = cvsFsCache.getDirContent(file);
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            int n = 0;
            while (n < stringArray.length) {
                if (JavaCvsVersioningSystem.this.ignoredRE != null && JavaCvsVersioningSystem.this.ignoredRE.match(stringArray[n]) || stringArray[n].equals(".nbattrs")) {
                    stringArray[n] = null;
                }
                ++n;
            }
            return stringArray;
        }
    }

    private class VersioningFolderListener
    extends FileChangeAdapter {
        private VersioningFolderListener() {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileObject fileObject = (FileObject)fileRenameEvent.getSource();
            fileObject.refresh();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject = (FileObject)fileEvent.getSource();
            fileObject.refresh();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            FileObject fileObject = (FileObject)fileEvent.getSource();
            fileObject.refresh();
        }

        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject = (FileObject)fileEvent.getSource();
            fileObject.refresh();
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = (FileObject)fileEvent.getSource();
            fileObject.refresh();
        }
    }
}

