/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.web.core.jsploader.CESLine;
import org.netbeans.modules.web.core.jsploader.ServletEditor;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;

public class ServletLine
extends Line
implements CESLine {
    private CloneableEditorSupport.Env editorEnv;
    private Line orig;

    public ServletLine(Line line, ServletEditor servletEditor) {
        super((DataObject)servletEditor.getServlet());
        this.orig = line;
        this.editorEnv = servletEditor.jspEnv();
    }

    public CloneableEditorSupport getCloneableEditorSupport() {
        return (ServletEditor)this.editorEnv.findCloneableOpenSupport();
    }

    public int hashCode() {
        return this.orig.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof CESLine && object instanceof Line) {
            Line line = (Line)object;
            CloneableEditorSupport cloneableEditorSupport = ((CESLine)object).getCloneableEditorSupport();
            if (this.getCloneableEditorSupport() == cloneableEditorSupport) {
                return this.getLineNumber() == line.getLineNumber();
            }
        }
        return false;
    }

    public int getLineNumber() {
        return this.orig.getLineNumber();
    }

    public void show(int n, int n2) {
        this.orig.show(n, n2);
    }

    public void show(int n) {
        this.orig.show(n);
    }

    public void setBreakpoint(boolean bl) {
        this.orig.setBreakpoint(bl);
    }

    public boolean isBreakpoint() {
        return this.orig.isBreakpoint();
    }

    public void markError() {
        this.orig.markError();
    }

    public void unmarkError() {
        this.orig.unmarkError();
    }

    public void markCurrentLine() {
        this.orig.markCurrentLine();
    }

    public void unmarkCurrentLine() {
        this.orig.unmarkCurrentLine();
    }

    public boolean canBeMarkedCurrent(int n, Line line) {
        return this.orig.canBeMarkedCurrent(n, line);
    }

    public static class Set
    extends Line.Set {
        private ServletEditor editor;
        private Line.Set delegate;
        private ArrayList linesCache;

        public Set(Line.Set set, ServletEditor servletEditor) {
            this.delegate = set;
            this.editor = servletEditor;
        }

        public List getLines() {
            if (this.linesCache == null) {
                List list = this.delegate.getLines();
                this.linesCache = new ArrayList();
                int n = 0;
                while (n < list.size()) {
                    this.linesCache.add(new ServletLine((Line)list.get(n), this.editor));
                    ++n;
                }
            }
            return this.linesCache;
        }

        public Line getOriginal(int n) throws IndexOutOfBoundsException {
            return new ServletLine(this.delegate.getOriginal(n), this.editor);
        }

        public Line getCurrent(int n) throws IndexOutOfBoundsException {
            return new ServletLine(this.delegate.getCurrent(n), this.editor);
        }
    }
}

