/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.web.core.jsploader.ContextDescriptor;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspInfo;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JspCompilationInfo {
    private FileObject jspFile;
    private ContextDescriptor cd;
    private boolean isErrorPage;
    private String encoding;
    private FileObject[] includedFileObjects;
    private DataObject[] includedFiles;
    private DataObject[] beans;
    private JspDataObject[] errorPage;
    private JspDataObject[] referencedPages;

    public JspCompilationInfo(JspInfo jspInfo, FileObject fileObject) throws FileStateInvalidException {
        this.jspFile = fileObject;
        this.cd = new ContextDescriptor(JspCompileUtil.getContextRoot(fileObject).getFileSystem());
        this.isErrorPage = jspInfo.isErrorPage();
        this.encoding = jspInfo.getEncoding();
        Set set = this.convertBeans(jspInfo.getBeans());
        this.beans = set.toArray(new DataObject[set.size()]);
        Set set2 = this.convertIncluded(jspInfo.getIncludedFiles());
        this.includedFileObjects = set2.toArray(new FileObject[set2.size()]);
        this.includedFiles = this.convertFilesToData(this.includedFileObjects);
        DataFilter dataFilter = new DataFilter(){

            public boolean acceptDataObject(DataObject dataObject) {
                return dataObject instanceof JspDataObject;
            }
        };
        set = this.convertPages(jspInfo.getErrorPage(), dataFilter);
        this.errorPage = set.toArray(new JspDataObject[set.size()]);
        set = this.convertPages(jspInfo.getReferencedPages(), dataFilter);
        this.referencedPages = set.toArray(new JspDataObject[set.size()]);
    }

    private DataObject resourceToDataObject(String string, DataFilter dataFilter) {
        FileObject fileObject = this.cd.getResourceAsObject(string);
        DataObject dataObject = null;
        if (fileObject != null) {
            try {
                dataObject = DataObject.find((FileObject)fileObject);
                if (dataFilter != null && !dataFilter.acceptDataObject(dataObject)) {
                    dataObject = null;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dataObject;
    }

    private DataObject clazzToDataObject(String string) {
        String string2 = string.replace('.', '/');
        FileObject fileObject = TopManager.getDefault().getRepository().findResource(string2 + ".java");
        if (fileObject == null) {
            fileObject = TopManager.getDefault().getRepository().findResource(string2 + ".class");
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    private Set convertPages(String[] stringArray, DataFilter dataFilter) {
        HashSet<DataObject> hashSet = new HashSet<DataObject>();
        int n = 0;
        while (n < stringArray.length) {
            DataObject dataObject = this.resourceToDataObject(stringArray[n], dataFilter);
            if (dataObject != null) {
                hashSet.add(dataObject);
            }
            ++n;
        }
        return hashSet;
    }

    private Set convertIncluded(String[] stringArray) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        int n = 0;
        while (n < stringArray.length) {
            FileObject fileObject = this.cd.getResourceAsObject(stringArray[n]);
            if (fileObject != null) {
                hashSet.add(fileObject);
            }
            ++n;
        }
        return hashSet;
    }

    private DataObject[] convertFilesToData(FileObject[] fileObjectArray) {
        DataObject[] dataObjectArray = new DataObject[fileObjectArray.length];
        int n = 0;
        while (n < fileObjectArray.length) {
            try {
                dataObjectArray[n] = DataObject.find((FileObject)fileObjectArray[n]);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                TopManager.getDefault().getErrorManager().notify(16, (Throwable)dataObjectNotFoundException);
                return new DataObject[0];
            }
            ++n;
        }
        return dataObjectArray;
    }

    private Set convertBeans(JspInfo.BeanData[] beanDataArray) {
        HashSet<DataObject> hashSet = new HashSet<DataObject>();
        int n = 0;
        while (n < beanDataArray.length) {
            DataObject dataObject = this.clazzToDataObject(beanDataArray[n].getClassName());
            if (dataObject != null) {
                hashSet.add(dataObject);
            }
            ++n;
        }
        return hashSet;
    }

    public DataObject[] getIncludedFiles() {
        return this.includedFiles;
    }

    public FileObject[] getIncludedFileObjects() {
        return this.includedFileObjects;
    }

    public DataObject[] getBeans() {
        return this.beans;
    }

    public JspDataObject[] getErrorPage() {
        return this.errorPage;
    }

    public JspDataObject[] getReferencedPages() {
        return this.referencedPages;
    }

    public boolean isErrorPage() {
        return this.isErrorPage;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

