/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.FfjJspCompileContext;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class CompileData {
    private JspDataObject jspPage;
    private ServerInstance serverInstance;
    private FileObject servletDirectory;
    private boolean outDated;
    private String servletEncoding;
    private Vector additionalClassPath;
    private String servletClassName;
    private String servletFileName;
    private String servletFileNameWithoutPackage;
    private static final boolean debug = false;

    public CompileData(JspDataObject jspDataObject) {
        this.jspPage = jspDataObject;
        FileObject fileObject = jspDataObject.getPrimaryFile();
        WebStandardData.WebResource webResource = JspCompileUtil.getResourceData(fileObject);
        WebStandardData.WebJsp webJsp = (WebStandardData.WebJsp)webResource;
        this.serverInstance = JspCompileUtil.getCurrentServerInstance((DataObject)jspDataObject);
        FfjJspCompileContext ffjJspCompileContext = JspCompileUtil.getCurrentCompileContext((DataObject)jspDataObject);
        if (ffjJspCompileContext != null) {
            FfjJspCompileContext.DevelopmentCompilation developmentCompilation = ffjJspCompileContext.getDevelopmentCompilation(webJsp);
            this.outDated = developmentCompilation.isOutDated();
            this.servletEncoding = developmentCompilation.getServletEncoding();
            this.servletClassName = ffjJspCompileContext.getServletClassName(webJsp);
            this.servletFileName = developmentCompilation.getServletFileName();
            this.additionalClassPath = this.computeAdditionalClassPath(developmentCompilation.getAdditionalClassPath());
            if (this.servletFileName != null) {
                try {
                    this.computeServletData();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public ServerInstance getServerInstance() {
        return this.serverInstance;
    }

    public FileObject getServletDirectory() {
        return this.servletDirectory;
    }

    public boolean isOutDated() {
        return this.outDated;
    }

    public Vector getAdditionalClassPath() {
        return this.additionalClassPath;
    }

    public String getCurrentServletFileName() {
        return this.servletFileNameWithoutPackage;
    }

    public String getCurrentServletClassName() {
        return this.servletClassName;
    }

    public String getServletEncoding() {
        return this.servletEncoding;
    }

    private Vector computeAdditionalClassPath(String string) {
        Vector<File> vector = new Vector<File>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "" + File.pathSeparatorChar);
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            vector.add(file);
        }
        return vector;
    }

    private void computeServletData() throws IOException {
        String string;
        File file = new File(this.servletFileName).getAbsoluteFile();
        String string2 = file.getAbsolutePath();
        int n = string2.lastIndexOf(File.separatorChar);
        this.servletFileNameWithoutPackage = n != -1 ? string2.substring(n + 1) : string2;
        int n2 = string2.lastIndexOf(46);
        if (n2 != -1) {
            string2 = string2.substring(0, n2);
        }
        if (string2.endsWith(string = this.servletClassName.replace('.', File.separatorChar))) {
            string2 = string2.substring(0, string2.length() - string.length());
            FileObject fileObject = JspCompileUtil.getAsRootOfFileSystem(new File(string2));
            n2 = this.servletClassName.lastIndexOf(46);
            if (n2 != -1) {
                String string3 = this.servletClassName.substring(0, n2).replace('.', '/');
                this.servletDirectory = FileUtil.createFolder((FileObject)fileObject, (String)string3);
            } else {
                this.servletDirectory = fileObject;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("--COMPILE DATA--");
        stringBuffer.append("\n");
        stringBuffer.append("server          : " + this.serverInstance);
        stringBuffer.append("\n");
        stringBuffer.append("JSP page        : " + this.jspPage.getPrimaryFile().getPackageNameExt('/', '.'));
        stringBuffer.append("\n");
        stringBuffer.append("servletFile     : " + this.servletFileName + ", exists= " + (this.servletFileName == null ? "false" : "" + new File(this.servletFileName).exists()));
        stringBuffer.append("\n");
        stringBuffer.append("servletClass    : " + this.servletClassName);
        stringBuffer.append("\n");
        stringBuffer.append("encoding        : " + this.servletEncoding);
        stringBuffer.append("\n");
        stringBuffer.append("servletDir (FO) : " + (this.servletDirectory == null ? "null" : this.servletDirectory.getPackageName('/')));
        stringBuffer.append("\n");
        stringBuffer.append("servlet W/O Pkg : " + this.servletFileNameWithoutPackage);
        stringBuffer.append("\n");
        stringBuffer.append("outdated        : " + this.outDated);
        stringBuffer.append("\n");
        stringBuffer.append("--end COMPILE DATA--");
        return stringBuffer.toString();
    }
}

