/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.context.NewWebModuleMountWizardPanel;
import org.netbeans.modules.web.context.WebAppObject;
import org.netbeans.modules.web.context.WebContextLoader;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public final class WebAppWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 4443289023351613861L;
    private static WebAppWizardIterator singletonInstance;
    private transient WebAppObject.WizardData wizardData;
    private transient TemplateWizard templateWizard = null;
    private transient String[] panelNames = null;
    private static ResourceBundle resBundle;
    private WizardDescriptor.ArrayIterator arrayIterator = null;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebAppLoader;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    private WebAppWizardIterator() {
    }

    public void initialize(TemplateWizard templateWizard) {
        this.templateWizard = templateWizard;
        if (this.arrayIterator == null) {
            this.initializePanelNames();
            Component component = this.templateWizard.targetChooser().getComponent();
            if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty("WizardPanel_contentData", this.panelNames);
            }
            WizardDescriptor.Panel[] panelArray = this.initializePanels(templateWizard);
            this.arrayIterator = new WizardDescriptor.ArrayIterator(panelArray);
        }
    }

    protected WizardDescriptor.Panel[] initializePanels(TemplateWizard templateWizard) {
        this.templateWizard = templateWizard;
        this.wizardData = new WebAppObject.WizardData();
        WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{new NewWebModuleMountWizardPanel(this.wizardData)};
        return panelArray;
    }

    public void initializePanelNames() {
        if (this.panelNames == null) {
            this.panelNames = new String[1];
            this.panelNames[0] = resBundle.getString("CTL_WebAppWizardPanel.ChooseTarget");
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.templateWizard = null;
        this.arrayIterator = null;
    }

    public WizardDescriptor.Panel current() {
        return this.arrayIterator.current();
    }

    public boolean hasNext() {
        return this.arrayIterator.hasNext();
    }

    public boolean hasPrevious() {
        return this.arrayIterator.hasNext();
    }

    public synchronized void nextPanel() {
        this.arrayIterator.nextPanel();
    }

    public synchronized void previousPanel() {
        this.arrayIterator.previousPanel();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.arrayIterator.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.arrayIterator.removeChangeListener(changeListener);
    }

    public String name() {
        return resBundle.getString("NewWebModuleMountWizardPanel.Title");
    }

    public boolean validateDocumentPath() {
        String string = this.wizardData.getDocumentBasePath();
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            Object[] objectArray = new Object[]{string};
            NewWebModuleMountWizardPanel.showErrorMessageI18N("MSG_NewWebModuleMountWizard.InvalidMountDirectory", objectArray);
            return false;
        }
        boolean bl = file.mkdirs();
        if (bl) {
            return true;
        }
        Object[] objectArray = new Object[]{string};
        NewWebModuleMountWizardPanel.showErrorMessageI18N("MSG_NewWebModuleMountWizard.InvalidMountDirectory", objectArray);
        return false;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        DataFolder dataFolder;
        TemplateWizard templateWizard2;
        Object object;
        String string = this.wizardData.getDocumentBasePath();
        if (string == null || string.length() <= 0 || !this.validateDocumentPath()) {
            return Collections.singleton(null);
        }
        LocalFileSystem localFileSystem = null;
        Object object2 = null;
        File file = new File(string);
        if (file != null && file.isDirectory()) {
            localFileSystem = new LocalFileSystem();
            try {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                localFileSystem.setRootDirectory(file);
                object = TopManager.getDefault().getRepository();
                templateWizard2 = this.findAlreadyMountedFileSystem((Repository)object, (FileSystem)localFileSystem);
                if (templateWizard2 == null) {
                    object.addFileSystem((FileSystem)localFileSystem);
                    object2 = localFileSystem;
                } else {
                    dataFolder = new NotifyDescriptor.Confirmation((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$WebAppLoader == null ? (class$org$netbeans$modules$web$context$WebAppLoader = WebAppWizardIterator.class$("org.netbeans.modules.web.context.WebAppLoader")) : class$org$netbeans$modules$web$context$WebAppLoader)).getString("PROP_ConvertIntoWar"), 2);
                    TopManager.getDefault().notify((NotifyDescriptor)dataFolder);
                    object2 = dataFolder.getValue() == NotifyDescriptor.CANCEL_OPTION ? null : templateWizard2;
                }
            }
            catch (IOException iOException) {
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        object = null;
        if (object2 != null) {
            this.wizardData.setDocumentBase((FileSystem)object2);
            templateWizard2 = templateWizard;
            dataFolder = (DataFolder)TopManager.getDefault().getPlaces().nodes().projectDesktop().getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = WebAppWizardIterator.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            if (dataFolder != null) {
                templateWizard2.setTargetFolder(dataFolder);
            }
            templateWizard2.setTargetName(this.wizardData.getDocumentBase().getSystemName());
            if (WebContextLoader.canBeWebApplication((FileSystem)object2)) {
                WebContextLoader.convert((FileSystem)object2);
                object = WebContextLoader.findContext((FileSystem)object2);
            }
        }
        return Collections.singleton(object);
    }

    public void debugPrintMountedFilesystems(Repository repository) {
        Enumeration enumeration = repository.fileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            System.out.println("    " + fileSystem.getSystemName());
        }
    }

    public FileSystem findAlreadyMountedFileSystem(Repository repository, FileSystem fileSystem) {
        FileObject fileObject = fileSystem.getRoot();
        String string = fileSystem.getDisplayName();
        String string2 = fileSystem.getSystemName();
        File file = NbClassPath.toFile((FileObject)fileObject);
        String string3 = file.getAbsolutePath();
        Enumeration enumeration = repository.fileSystems();
        while (enumeration.hasMoreElements()) {
            File file2;
            FileSystem fileSystem2 = (FileSystem)enumeration.nextElement();
            boolean bl = fileSystem2.isHidden();
            if (bl || (file2 = NbClassPath.toFile((FileObject)fileSystem2.getRoot())) == null) continue;
            String string4 = file2.getAbsolutePath();
            if (string3.equals(string4)) {
                return fileSystem2;
            }
            String string5 = fileSystem2.getSystemName();
            if (string2.equals(string5)) {
                return fileSystem2;
            }
            String string6 = fileSystem2.getDisplayName();
            if (string.equals(string6)) {
                return fileSystem2;
            }
            if (!string2.equals(string6)) continue;
            return fileSystem2;
        }
        return null;
    }

    public static WebAppWizardIterator singleton() {
        if (singletonInstance == null) {
            singletonInstance = new WebAppWizardIterator();
        }
        return singletonInstance;
    }

    public Object readResolve() throws ObjectStreamException {
        return WebAppWizardIterator.singleton();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        resBundle = ResourceBundle.getBundle("org/netbeans/modules/web/context/Bundle");
    }
}

