/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search.environment;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.modules.javadoc.search.environment.JavadocArchive;
import org.netbeans.modules.javadoc.search.environment.JavadocDirectory;
import org.netbeans.modules.javadoc.search.environment.JavadocHttp;
import org.netbeans.modules.javadoc.search.environment.Utilities;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class JavadocProcessor
implements XMLDataObject.Processor,
InstanceCookie {
    static final String JAVADOC_DTD_PUBLIC_ID = "-//NetBeans IDE//DTD JavadocLibrary//EN";
    static final String TAG_JAVADOC = "Javadoc";
    static final String TAG_ARCHIVE = "Archive";
    static final String TAG_FOLDER = "Folder";
    static final String TAG_HTTP = "Http";
    static final String ATTR_NAME = "name";
    private static final char FILE_SEPARATOR = File.separatorChar;
    private static XMLDataObject.Info xmlinfo;
    protected XMLDataObject xmlDataObject;
    FileSystem libraryFileSystem;
    static /* synthetic */ Class class$org$openide$filesystems$FileSystem;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    public void attachTo(XMLDataObject xMLDataObject) {
        this.xmlDataObject = xMLDataObject;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.libraryFileSystem != null) {
            return this.libraryFileSystem;
        }
        File file = null;
        String string = System.getProperty("file.separator");
        try {
            file = new File(System.getProperty("netbeans.user") + string + "javadoc").getCanonicalFile();
        }
        catch (IOException iOException) {
            file = new File(System.getProperty("netbeans.user") + string + "javadoc").getAbsoluteFile();
        }
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        this.loadLibrary(this.xmlDataObject);
        return this.libraryFileSystem;
    }

    public Class instanceClass() {
        return class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = JavadocProcessor.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem;
    }

    public String instanceName() {
        return this.instanceClass().getName();
    }

    void throwIllegalMountException(String string, String string2) throws SAXException {
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = JavadocProcessor.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        String string3 = MessageFormat.format(Utilities.getString(string), string2, this.xmlDataObject.getPrimaryFile().toString());
        throw (SAXException)errorManager.annotate((Throwable)new SAXException("Mount resource not found"), 256, null, string3, null, null);
    }

    private void loadLibrary(final XMLDataObject xMLDataObject) throws IOException {
        HandlerBase handlerBase = new HandlerBase(){
            private boolean inJavadoc = false;

            public void startElement(String string, AttributeList attributeList) throws SAXException {
                File file;
                if (JavadocProcessor.TAG_JAVADOC.equals(string)) {
                    this.inJavadoc = true;
                } else if (!this.inJavadoc || !JavadocProcessor.TAG_ARCHIVE.equals(string) && !JavadocProcessor.TAG_FOLDER.equals(string) && !JavadocProcessor.TAG_HTTP.equals(string)) {
                    JavadocProcessor.this.throwIllegalMountException("FMT_ILLEGAL_RESOURCE_SPEC", null);
                }
                String string2 = attributeList.getValue(JavadocProcessor.ATTR_NAME);
                if (string2 == null) {
                    return;
                }
                String string3 = xMLDataObject.getPrimaryFile().getPackageNameExt('/', '.');
                if (string3.equals("")) {
                    return;
                }
                if (JavadocProcessor.TAG_HTTP.equals(string)) {
                    try {
                        JavadocHttp javadocHttp = new JavadocHttp(string3);
                        javadocHttp.setURL(string2);
                        JavadocProcessor.this.libraryFileSystem = javadocHttp;
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (FILE_SEPARATOR != '/') {
                    string2.replace('/', FILE_SEPARATOR);
                }
                if ((file = Utilities.findInstalledFile(string2)) == null) {
                    JavadocProcessor.this.throwIllegalMountException("FMT_RESOURCE_NOT_FOUND", string2);
                }
                try {
                    Object object;
                    if (JavadocProcessor.TAG_ARCHIVE.equals(string)) {
                        object = new JavadocArchive(string3);
                        object.setJarFile(file);
                        JavadocProcessor.this.libraryFileSystem = object;
                    } else if (JavadocProcessor.TAG_FOLDER.equals(string)) {
                        object = new JavadocDirectory(string3);
                        object.setRootDirectory(file);
                        JavadocProcessor.this.libraryFileSystem = object;
                    } else {
                        JavadocProcessor.this.throwIllegalMountException("FMT_ILLEGAL_RESOURCE_SPEC", null);
                    }
                    JavadocProcessor.this.libraryFileSystem.setHidden(true);
                    object = JavadocProcessor.this.libraryFileSystem.getCapability();
                    if (object instanceof FileSystemCapability.Bean) {
                        FileSystemCapability.Bean bean = (FileSystemCapability.Bean)object;
                        bean.setCompile(false);
                        bean.setExecute(false);
                        bean.setDebug(false);
                        bean.setDoc(true);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    JavadocProcessor.this.libraryFileSystem = null;
                    JavadocProcessor.this.throwIllegalMountException("FMT_ILLEGAL_RESOURCE_SPEC", null);
                    return;
                }
                catch (IOException iOException) {
                    JavadocProcessor.this.libraryFileSystem = null;
                    JavadocProcessor.this.throwIllegalMountException("FMT_ILLEGAL_RESOURCE_SPEC", null);
                    return;
                }
            }

            public void endElement(String string) throws SAXException {
                if (JavadocProcessor.TAG_JAVADOC.equals(string)) {
                    this.inJavadoc = false;
                }
            }
        };
        Parser parser = XMLDataObject.createParser();
        parser.setDocumentHandler(handlerBase);
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        });
        try {
            parser.parse(new InputSource(xMLDataObject.getPrimaryFile().getInputStream()));
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException();
            TopManager.getDefault().getErrorManager().copyAnnotation((Throwable)iOException, (Throwable)sAXException);
            throw iOException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

