/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPFieldMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.Field;

public final class Variable
extends Field {
    private boolean constant;
    private Object value;

    static Variable[] loadFields(DataInputStream dataInputStream, ConstantPool constantPool, ClassFile classFile) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        Variable[] variableArray = new Variable[n];
        int n2 = 0;
        while (n2 < n) {
            variableArray[n2] = new Variable(dataInputStream, constantPool, classFile);
            ++n2;
        }
        return variableArray;
    }

    Variable(DataInputStream dataInputStream, ConstantPool constantPool, ClassFile classFile) throws IOException {
        super(dataInputStream, constantPool, classFile);
        this.loadAttributes(dataInputStream, constantPool);
    }

    final boolean loadAttribute(String string, int n, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        if (string.equals("ConstantValue")) {
            this.constant = true;
            int n2 = dataInputStream.readUnsignedShort();
            CPEntry cPEntry = constantPool.get(n2);
            this.value = cPEntry.getValue();
            return true;
        }
        return false;
    }

    public final boolean isConstant() {
        return this.constant;
    }

    public final Object getValue() {
        return this.value;
    }

    public final String getDeclaration() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CPFieldMethodInfo.getSignature(this.getDescriptor(), false));
        stringBuffer.append(' ');
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    public String toString() {
        String string = super.toString();
        if (this.isConstant()) {
            string = string + ", const value=" + this.getValue();
        }
        return string;
    }
}

