/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPDoubleInfo;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPFieldInfo;
import org.netbeans.modules.classfile.CPFloatInfo;
import org.netbeans.modules.classfile.CPIntegerInfo;
import org.netbeans.modules.classfile.CPInterfaceMethodInfo;
import org.netbeans.modules.classfile.CPLongInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.CPNameAndTypeInfo;
import org.netbeans.modules.classfile.CPStringInfo;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPoolReader;

public final class ConstantPool {
    private static final int CONSTANT_POOL_START = 1;
    static final int CONSTANT_Utf8 = 1;
    static final int CONSTANT_Integer = 3;
    static final int CONSTANT_Float = 4;
    static final int CONSTANT_Long = 5;
    static final int CONSTANT_Double = 6;
    static final int CONSTANT_Class = 7;
    static final int CONSTANT_String = 8;
    static final int CONSTANT_FieldRef = 9;
    static final int CONSTANT_MethodRef = 10;
    static final int CONSTANT_InterfaceMethodRef = 11;
    static final int CONSTANT_NameAndType = 12;
    CPEntry[] cpEntries;
    int constantPoolCount = 0;
    static /* synthetic */ Class class$org$netbeans$modules$classfile$CPClassInfo;

    ConstantPool(int n, InputStream inputStream) {
        if (n < 0) {
            throw new IllegalArgumentException("size cannot be negative");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("byte stream not specified");
        }
        this.constantPoolCount = n;
        this.cpEntries = new CPEntry[this.constantPoolCount];
        this.load(inputStream);
    }

    ConstantPool() {
        this.constantPoolCount = 1;
        this.cpEntries = new CPEntry[this.constantPoolCount];
    }

    public final CPEntry get(int n) {
        if (n <= 0 || n >= this.cpEntries.length) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return this.cpEntries[n];
    }

    public final CPClassInfo getClass(int n) {
        if (n <= 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return (CPClassInfo)this.get(n);
    }

    public final Collection getAllConstants(Class clazz) {
        return Collections.unmodifiableCollection(this.getAllConstantsImpl(clazz));
    }

    private Collection getAllConstantsImpl(Class clazz) {
        int n = this.cpEntries.length;
        ArrayList<CPEntry> arrayList = new ArrayList<CPEntry>(n);
        int n2 = 1;
        while (n2 < n) {
            if (this.cpEntries[n2] != null && this.cpEntries[n2].getClass().equals(clazz)) {
                arrayList.add(this.cpEntries[n2]);
            }
            ++n2;
        }
        return arrayList;
    }

    public final Set getAllClassNames() {
        Collection collection = this.getAllConstantsImpl(class$org$netbeans$modules$classfile$CPClassInfo == null ? (class$org$netbeans$modules$classfile$CPClassInfo = ConstantPool.class$("org.netbeans.modules.classfile.CPClassInfo")) : class$org$netbeans$modules$classfile$CPClassInfo);
        HashSet<ClassName> hashSet = new HashSet<ClassName>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CPClassInfo cPClassInfo = (CPClassInfo)iterator.next();
            hashSet.add(cPClassInfo.getClassName());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    final String getString(int n) {
        CPUTF8Info cPUTF8Info = (CPUTF8Info)this.cpEntries[n];
        return cPUTF8Info.getName();
    }

    private void load(InputStream inputStream) {
        try {
            ConstantPoolReader constantPoolReader = new ConstantPoolReader(inputStream);
            int n = 1;
            while (n < this.constantPoolCount) {
                CPEntry cPEntry;
                this.cpEntries[n] = cPEntry = this.getConstantPoolEntry(constantPoolReader);
                if (cPEntry.usesTwoSlots()) {
                    ++n;
                }
                ++n;
            }
            int n2 = 1;
            while (n2 < this.constantPoolCount) {
                CPEntry cPEntry = this.cpEntries[n2];
                if (cPEntry != null) {
                    cPEntry.resolve(this.cpEntries);
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid class format");
        }
    }

    private CPEntry getConstantPoolEntry(ConstantPoolReader constantPoolReader) throws IOException {
        CPEntry cPEntry = null;
        byte by = constantPoolReader.readByte();
        switch (by) {
            case 1: {
                cPEntry = new CPUTF8Info(this, constantPoolReader.readRawUTF());
                break;
            }
            case 3: {
                cPEntry = new CPIntegerInfo(this, constantPoolReader.readInt());
                break;
            }
            case 4: {
                cPEntry = new CPFloatInfo(this, constantPoolReader.readFloat());
                break;
            }
            case 5: {
                cPEntry = new CPLongInfo(this, constantPoolReader.readLong());
                break;
            }
            case 6: {
                cPEntry = new CPDoubleInfo(this, constantPoolReader.readDouble());
                break;
            }
            case 7: {
                short s = constantPoolReader.readShort();
                cPEntry = new CPClassInfo(this, s);
                break;
            }
            case 8: {
                short s = constantPoolReader.readShort();
                cPEntry = new CPStringInfo(this, s);
                break;
            }
            case 9: {
                short s = constantPoolReader.readShort();
                short s2 = constantPoolReader.readShort();
                cPEntry = new CPFieldInfo(this, s, s2);
                break;
            }
            case 10: {
                short s = constantPoolReader.readShort();
                short s3 = constantPoolReader.readShort();
                cPEntry = new CPMethodInfo(this, s, s3);
                break;
            }
            case 11: {
                short s = constantPoolReader.readShort();
                short s4 = constantPoolReader.readShort();
                cPEntry = new CPInterfaceMethodInfo(this, s, s4);
                break;
            }
            case 12: {
                short s = constantPoolReader.readShort();
                short s5 = constantPoolReader.readShort();
                cPEntry = new CPNameAndTypeInfo(this, s, s5);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid constant pool type: " + by);
            }
        }
        if (cPEntry == null) {
            throw new InternalError("assertion failure");
        }
        return cPEntry;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

