/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.classfile.Access;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InnerClass;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.classfile.Variable;

public class ClassFile {
    ConstantPool constantPool;
    int classAccess;
    CPClassInfo classInfo;
    CPClassInfo superClassInfo;
    CPClassInfo[] interfaces;
    Variable[] variables;
    Method[] methods;
    String sourceFileName;
    boolean deprecated = false;
    boolean synthetic = false;
    InnerClass[] innerClasses;
    private HashMap attributes;
    private static final int BUFFER_SIZE = 4096;

    public ClassFile(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public ClassFile(String string) throws IOException {
        this(string, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClassFile(File file, boolean bl) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        if (file == null || !file.exists()) {
            throw new IOException("File name is invalid or file not exists");
        }
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 4096);
            this.load(bufferedInputStream, bl);
            Object var5_4 = null;
            if (bufferedInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bufferedInputStream == null) throw throwable;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((InputStream)bufferedInputStream).close();
    }

    public ClassFile(InputStream inputStream, boolean bl) throws IOException {
        if (inputStream == null) {
            throw new IOException("input stream not specified");
        }
        this.load(inputStream, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClassFile(String string, boolean bl) throws IOException {
        InputStream inputStream = null;
        try {
            if (string == null) {
                throw new IOException("input stream not specified");
            }
            inputStream = new BufferedInputStream(new FileInputStream(string), 4096);
            this.load(inputStream, bl);
            Object var5_4 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public final ConstantPool getConstantPool() {
        return this.constantPool;
    }

    private void load(InputStream inputStream, boolean bl) throws IOException {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (dataInputStream == null) {
                throw new IOException("invalid class format");
            }
            this.constantPool = this.loadClassHeader(dataInputStream);
            this.interfaces = ClassFile.getCPClassList(dataInputStream, this.constantPool);
            this.variables = Variable.loadFields(dataInputStream, this.constantPool, this);
            this.methods = Method.loadMethods(dataInputStream, this.constantPool, this, bl);
            this.loadAttributes(dataInputStream, this.constantPool);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IOException("invalid class format");
        }
    }

    private ConstantPool loadClassHeader(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n != -889275714) {
            throw new IOException("invalid class format");
        }
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        short s3 = dataInputStream.readShort();
        ConstantPool constantPool = new ConstantPool(s3, dataInputStream);
        this.classAccess = dataInputStream.readUnsignedShort();
        this.classInfo = constantPool.getClass(dataInputStream.readUnsignedShort());
        if (this.classInfo == null) {
            throw new IOException("invalid class format");
        }
        int n2 = dataInputStream.readUnsignedShort();
        if (n2 != 0) {
            this.superClassInfo = constantPool.getClass(n2);
        }
        return constantPool;
    }

    static CPClassInfo[] getCPClassList(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        CPClassInfo[] cPClassInfoArray = new CPClassInfo[n];
        int n2 = 0;
        while (n2 < n) {
            cPClassInfoArray[n2] = constantPool.getClass(dataInputStream.readUnsignedShort());
            ++n2;
        }
        return cPClassInfoArray;
    }

    private void loadAttributes(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        this.attributes = new HashMap(n + 1, 1.0f);
        int n2 = 0;
        while (n2 < n) {
            CPUTF8Info cPUTF8Info;
            try {
                cPUTF8Info = (CPUTF8Info)constantPool.get(dataInputStream.readUnsignedShort());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("invalid constant pool entry");
            }
            int n3 = dataInputStream.readInt();
            String string = cPUTF8Info.getName();
            if (string.equals("Deprecated")) {
                this.attributes.put(string, null);
                this.deprecated = true;
            } else if (string.equals("Synthetic")) {
                this.attributes.put(string, null);
                this.synthetic = true;
            } else if (string.equals("SourceFile")) {
                try {
                    cPUTF8Info = (CPUTF8Info)constantPool.get(dataInputStream.readUnsignedShort());
                }
                catch (ClassCastException classCastException) {
                    throw new IOException("invalid constant pool entry");
                }
                this.sourceFileName = cPUTF8Info.getName();
                this.attributes.put(string, this.sourceFileName);
            } else if (string.equals("InnerClasses")) {
                this.innerClasses = InnerClass.loadInnerClasses(dataInputStream, constantPool);
                this.attributes.put(string, this.innerClasses);
            } else {
                System.out.println("skipped unknown class attribute: " + string);
                ClassFile.skip(dataInputStream, n3);
                this.attributes.put(string, null);
            }
            ++n2;
        }
        if (this.innerClasses == null) {
            this.innerClasses = new InnerClass[0];
        }
    }

    static void skip(InputStream inputStream, int n) throws IOException {
        int n2;
        while ((n2 = (int)inputStream.skip(n)) > 0 && n2 < n) {
            n -= n2;
        }
    }

    public final int getAccess() {
        return this.classAccess;
    }

    public final ClassName getName() {
        return this.classInfo.getClassName();
    }

    public final ClassName getSuperClass() {
        if (this.superClassInfo == null) {
            return null;
        }
        return this.superClassInfo.getClassName();
    }

    public final Collection getInterfaces() {
        ArrayList<ClassName> arrayList = new ArrayList<ClassName>();
        int n = this.interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.interfaces[n2].getClassName());
            ++n2;
        }
        return arrayList;
    }

    public final Variable getVariable(String string) {
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = this.variables[n2];
            if (variable.getName().equals(string)) {
                return variable;
            }
            ++n2;
        }
        return null;
    }

    public final Collection getVariables() {
        return Arrays.asList(this.variables);
    }

    public final int getVariableCount() {
        return this.variables.length;
    }

    public final Method getMethod(String string, String string2) {
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = this.methods[n2];
            if (method.getName().equals(string) && method.getDescriptor().equals(string2)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public final Collection getMethods() {
        return Arrays.asList(this.methods);
    }

    public final int getMethodCount() {
        return this.methods.length;
    }

    public final String getSourceFileName() {
        return this.sourceFileName;
    }

    public final boolean isDeprecated() {
        return this.deprecated;
    }

    public final boolean isSynthetic() {
        return this.synthetic;
    }

    public final Map getAttributes() {
        return this.attributes;
    }

    public final Collection getInnerClasses() {
        return Arrays.asList(this.innerClasses);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ClassFile: ");
        stringBuffer.append(Access.toString(this.classAccess));
        stringBuffer.append(' ');
        stringBuffer.append(this.classInfo);
        if (this.synthetic) {
            stringBuffer.append(" (synthetic)");
        }
        if (this.deprecated) {
            stringBuffer.append(" (deprecated)");
        }
        stringBuffer.append("\n   source: ");
        stringBuffer.append(this.sourceFileName);
        stringBuffer.append("\n   super: ");
        stringBuffer.append(this.superClassInfo);
        stringBuffer.append("\n   ");
        if (this.interfaces.length > 0) {
            stringBuffer.append(this.arrayToString("interfaces", this.interfaces));
            stringBuffer.append("\n   ");
        }
        if (this.innerClasses.length > 0) {
            stringBuffer.append(this.arrayToString("innerclasses", this.innerClasses));
            stringBuffer.append("\n   ");
        }
        if (this.variables.length > 0) {
            stringBuffer.append(this.arrayToString("variables", this.variables));
            stringBuffer.append("\n   ");
        }
        if (this.methods.length > 0) {
            stringBuffer.append(this.arrayToString("methods", this.methods));
        }
        return stringBuffer.toString();
    }

    private String arrayToString(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(": ");
        int n = objectArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                stringBuffer.append("\n      ");
                stringBuffer.append(objectArray[n2++].toString());
            } while (n2 < n);
        } else {
            stringBuffer.append("none");
        }
        return stringBuffer.toString();
    }
}

