/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.customizer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.cvsclient.customizer.LoginDialog;
import org.netbeans.modules.javacvs.commands.ClientCreationException;
import org.netbeans.modules.javacvs.passwd.CVSPasswd;
import org.netbeans.modules.javacvs.passwd.PasswdEntry;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class LoginDialog
extends JDialog {
    public final Object STATUS_CONNECTING = new Integer(0);
    public final Object STATUS_FAILED = new Integer(1);
    private static ArrayList lastSuccessfullLoggings = new ArrayList();
    private String connectStr = "";
    private PasswdEntry entry = null;
    private boolean loggedIn = false;
    private boolean offline = false;
    private Thread loginThread = null;
    private CVSPasswd passwd = null;
    private int port;
    private JPanel buttonPanel;
    private JPanel loginPanel;
    private JPanel statusPanel;
    private JButton btnLogin;
    private JLabel lblLogin;
    private JLabel lblPasswd;
    private JLabel statusLabel;
    private JButton btnCancel;
    private JPasswordField txPasswd;
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog));
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$customizer$LoginDialog;

    public LoginDialog(Frame frame, boolean bl, String string, CVSPasswd cVSPasswd, int n) {
        super(frame, bl);
        this.initComponents();
        this.initAccessibility();
        this.connectStr = string;
        this.passwd = cVSPasswd;
        this.port = n;
        this.setTitle(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.title"));
        this.lblLogin.setText(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.lblLogin.text"), string));
        this.lblPasswd.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.lblPasswd.mnemonic").charAt(0));
        this.lblPasswd.setLabelFor(this.txPasswd);
        this.btnLogin.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.btnLogin.mnemonic").charAt(0));
        this.btnCancel.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.btnCancel.mnemonic").charAt(0));
        this.pack();
        this.txPasswd.requestFocus();
        this.getRootPane().setDefaultButton(this.btnLogin);
    }

    private void initComponents() {
        this.loginPanel = new JPanel();
        this.lblLogin = new JLabel();
        this.lblPasswd = new JLabel();
        this.txPasswd = new JPasswordField();
        this.buttonPanel = new JPanel();
        this.btnLogin = new JButton();
        this.btnCancel = new JButton();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoginDialog.this.closeDialog(windowEvent);
            }
        });
        this.loginPanel.setLayout(new GridBagLayout());
        this.lblLogin.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.lblLogin.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.loginPanel.add((Component)this.lblLogin, gridBagConstraints);
        this.lblPasswd.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.lblPasswd.text"));
        this.lblPasswd.setLabelFor(this.txPasswd);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.loginPanel.add((Component)this.lblPasswd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.loginPanel.add((Component)this.txPasswd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 11);
        this.getContentPane().add((Component)this.loginPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.btnLogin.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.btnLogin.text"));
        this.btnLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginDialog.this.loginButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.btnLogin, gridBagConstraints);
        this.btnCancel.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginDialog.this.offlineButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.buttonPanel.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 11);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.statusPanel.setLayout(new GridBagLayout());
        this.statusPanel.setBorder(new BevelBorder(1));
        this.statusLabel.setText(" ");
        this.statusLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.statusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 17, 11);
        this.getContentPane().add((Component)this.statusPanel, gridBagConstraints);
    }

    private void offlineButtonActionPerformed(ActionEvent actionEvent) {
        this.loggedIn = false;
        if (this.loginThread != null && this.loginThread.isAlive()) {
            this.loginThread.interrupt();
        }
        this.offline = true;
        this.closeDialog(null);
    }

    private void loginButtonActionPerformed(ActionEvent actionEvent) {
        this.loginThread = new Thread("CVS_AUTHORIZING_THREAD"){

            public void run() {
                LoginDialog.this.checkLogin();
            }
        };
        this.loginThread.start();
    }

    private void closeDialog(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void showLogging() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Runnable runnable = new Runnable(this){
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                LoginDialog.access$300(5.access$500(6.access$400(this.this$2)));
                            }
                        };
                        new Thread(runnable, "CVS_AUTHORIZING_THREAD").start();
                    }

                    static /* synthetic */ 5 access$400(6 var0) {
                        return var0.this$1;
                    }
                });
            }

            static /* synthetic */ LoginDialog access$500(5 var0) {
                return var0.LoginDialog.this;
            }
        });
        this.show();
    }

    private void checkLogin() {
        ((AbstractCollection)lastSuccessfullLoggings).remove(this.connectStr);
        this.txPasswd.setEnabled(false);
        this.btnLogin.setEnabled(false);
        this.setStatus(this.STATUS_CONNECTING, null);
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        this.loggedIn = false;
        try {
            try {
                PasswdEntry passwdEntry = new PasswdEntry();
                string = new String(this.txPasswd.getPassword());
                passwdEntry.setEntry(this.connectStr + " " + CVSPasswd.scramble(string));
                this.loggedIn = this.passwd.checkServer(passwdEntry, this.port);
            }
            catch (AuthenticationException authenticationException) {
                if (authenticationException.getUnderlyingThrowable() instanceof UnknownHostException) {
                    this.setStatus(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.unknownHost"));
                    Object var5_7 = null;
                    this.txPasswd.setEnabled(true);
                    this.btnLogin.setEnabled(true);
                    return;
                }
                if (authenticationException.getUnderlyingThrowable() instanceof IOException) {
                    this.setStatus(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.connectionIOError"));
                    Object var5_8 = null;
                    this.txPasswd.setEnabled(true);
                    this.btnLogin.setEnabled(true);
                    return;
                }
                Object var5_9 = null;
                this.txPasswd.setEnabled(true);
                this.btnLogin.setEnabled(true);
            }
            Object var5_6 = null;
            this.txPasswd.setEnabled(true);
            this.btnLogin.setEnabled(true);
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.txPasswd.setEnabled(true);
            this.btnLogin.setEnabled(true);
            throw throwable;
        }
        if (!this.loggedIn) {
            this.setStatus(this.STATUS_FAILED, stringBuffer.toString());
            this.txPasswd.requestFocus();
            this.txPasswd.setSelectionStart(0);
            this.txPasswd.setSelectionEnd(this.txPasswd.getText().length());
        } else {
            this.setStatus(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.status.succeeded"));
            this.passwd.add(this.connectStr, new String(this.txPasswd.getPassword()));
            try {
                this.passwd.savePassFile();
            }
            catch (ClientCreationException clientCreationException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)clientCreationException.getLocalizedMessage(), 0);
                TopManager.getDefault().notify((NotifyDescriptor)message);
            }
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void setConnectString(String string) {
        this.connectStr = string;
    }

    public void setPserverName(String string) {
        this.lblLogin.setText(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.loginLabel.text"), string));
        this.pack();
    }

    public void setStatus(Object object) {
        this.setStatus(object, null);
    }

    public void setStatus(Object object, String string) {
        if (object.equals(this.STATUS_FAILED)) {
            this.statusLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.status.failed"));
            if (string != null) {
                this.statusLabel.setToolTipText(string);
            }
        } else if (object.equals(this.STATUS_CONNECTING)) {
            this.statusLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.status.connecting"));
        } else if (object instanceof String) {
            this.statusLabel.setText((String)object);
        }
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public String getPassword() {
        return new String(this.txPasswd.getPassword());
    }

    public static LoginDialog createDialog(String string, CVSPasswd cVSPasswd, int n) {
        LoginDialog loginDialog = new LoginDialog(new JFrame(), true, string, cVSPasswd, n);
        return loginDialog;
    }

    private void initAccessibility() {
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleDescription(bundle.getString("ACSD_LoginDialog"));
        accessibleContext = this.statusLabel.getAccessibleContext();
        accessibleContext.setAccessibleDescription(bundle.getString("ACSD_LoginDialog.statusLabel"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

