/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.commands.log;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.modules.cvsclient.NbJavaCvsFileSystem;
import org.netbeans.modules.cvsclient.commands.log.RevisionExplorerAction;
import org.netbeans.modules.javacvs.events.CommandDisplayerListener;
import org.netbeans.modules.vcscore.revision.RevisionChildren;
import org.netbeans.modules.vcscore.revision.RevisionExplorer;
import org.netbeans.modules.vcscore.revision.RevisionItem;
import org.netbeans.modules.vcscore.revision.RevisionList;
import org.netbeans.modules.vcscore.revision.RevisionNode;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.actions.SystemAction;

public class RevisionExplorerInfo
implements CommandDisplayerListener {
    private LinkedList nodeList = new LinkedList();
    private NbJavaCvsFileSystem fSystem;

    public RevisionExplorerInfo(NbJavaCvsFileSystem nbJavaCvsFileSystem) {
        this.fSystem = nbJavaCvsFileSystem;
    }

    public void setDataToDisplay(LogInformation logInformation) {
        RevisionItem revisionItem;
        Object object;
        Image image;
        RevisionList revisionList = new RevisionList();
        LinkedList<RevisionItem> linkedList = new LinkedList<RevisionItem>();
        revisionList.setFileSystem((FileSystem)this.fSystem);
        FileObject fileObject = this.findFO(logInformation.getFile());
        revisionList.setFileObject(fileObject);
        InfoNode infoNode = new InfoNode(revisionList);
        String string = revisionList.getFileObject().getNameExt();
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        hashSet.add(revisionList.getFileObject());
        string = this.fSystem.getStatus().annotateName(string, hashSet);
        infoNode.setRootDisplay(revisionList.getFileObject().getNameExt());
        infoNode.setDisplayName(string);
        infoNode.setName(logInformation.getFile().getName());
        infoNode.setFileNode(true);
        try {
            image = DataObject.find((FileObject)fileObject).getNodeDelegate().getIcon(1);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            image = null;
        }
        Iterator iterator = logInformation.getRevisionList().iterator();
        while (iterator.hasNext()) {
            object = (LogInformation.Revision)iterator.next();
            revisionItem = new RevisionItem(((LogInformation.Revision)object).getNumber());
            revisionItem.setAuthor(((LogInformation.Revision)object).getAuthor());
            revisionItem.setDate(((LogInformation.Revision)object).getDateString());
            revisionItem.setMessage(((LogInformation.Revision)object).getMessage());
            revisionItem.setDisplayName(((LogInformation.Revision)object).getNumber());
            revisionItem.setTagNames(this.processTags(logInformation.getAllSymbolicNames(), ((LogInformation.Revision)object).getNumber()));
            linkedList.add(revisionItem);
            this.createBranchItems(linkedList, logInformation, (LogInformation.Revision)object);
        }
        Collections.sort(linkedList, Collections.reverseOrder());
        object = linkedList.iterator();
        while (object.hasNext()) {
            revisionItem = (RevisionItem)object.next();
            revisionList.add((Object)revisionItem);
        }
        revisionItem = RevisionExplorer.getRevisionExplorer((RevisionNode)infoNode, (String)infoNode.getRootDisplay(), (Image)image);
        revisionItem.open(TopManager.getDefault().getWindowManager().getCurrentWorkspace());
    }

    private String[] processTags(List list, String string) {
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (LogInformation.SymName)iterator.next();
            if (!((LogInformation.SymName)object).getRevision().equals(string)) continue;
            linkedList.add(((LogInformation.SymName)object).getName());
        }
        object = new String[linkedList.size()];
        object = (String[])linkedList.toArray((T[])object);
        return object;
    }

    private FileObject findFO(File file) {
        String string = file.getAbsolutePath();
        String string2 = this.fSystem.constructRootDirectory();
        string = string.substring(string2.length());
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        FileObject fileObject = this.fSystem.findResource(string);
        return fileObject;
    }

    private void createBranchItems(List list, LogInformation logInformation, LogInformation.Revision revision) {
        String string = revision.getNumber() + ".0.";
        Iterator iterator = logInformation.getAllSymbolicNames().iterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            String string2;
            String string3;
            LogInformation.SymName symName = (LogInformation.SymName)iterator.next();
            if (symName.getRevision().startsWith(string)) {
                string3 = symName.getRevision();
                int n = string3.lastIndexOf(".0.");
                string3 = string3.substring(0, n) + string3.substring(n + 2, string3.length());
                string2 = new RevisionItem(string3);
                string2.setDisplayName(string2.getRevision() + " (" + symName.getName() + ")");
                stringArray = new String[]{symName.getName()};
                string2.setTagNames(stringArray);
                list.add(string2);
                continue;
            }
            string3 = revision.getNumber();
            String string4 = symName.getRevision();
            if (!string4.startsWith(string3) || string3.length() >= string4.length() || (string2 = string4.substring(string3.length())).lastIndexOf(46) != 0) continue;
            stringArray = new RevisionItem(string4);
            stringArray.setDisplayName(stringArray.getRevision() + " (" + symName.getName() + ")");
            String[] stringArray2 = new String[]{symName.getName()};
            stringArray.setTagNames(stringArray2);
            list.add(stringArray);
        }
    }

    public void messageGenerated(MessageEvent messageEvent) {
    }

    public void showBeforeEachExecute(Command command) {
    }

    public void showExecutionFailed(Exception exception) {
    }

    public void showFinishedCommand() {
    }

    public void showStartCommand() {
    }

    public void showAfterEachExecute() {
    }

    public void showFileInfoGenerated(FileInfoContainer fileInfoContainer) {
        LogInformation logInformation = (LogInformation)fileInfoContainer;
        this.setDataToDisplay(logInformation);
    }

    public class InfoNode
    extends RevisionNode {
        private String rootDisplay = "";
        private FileObject FObj;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$openide$actions$OpenAction;
        static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$log$RevisionExplorerAction;

        public InfoNode(RevisionList revisionList) {
            super(revisionList);
            this.FObj = revisionList.getFileObject();
        }

        public InfoNode(RevisionChildren revisionChildren) {
            super(revisionChildren);
        }

        public InfoNode(RevisionList revisionList, RevisionItem revisionItem) {
            super(revisionList, revisionItem);
            this.FObj = revisionList.getFileObject();
        }

        public String getPath() {
            return this.getFileObject().getPackageNameExt('/', '.');
        }

        public void setRootDisplay(String string) {
            this.rootDisplay = string;
        }

        public String getRootDisplay() {
            return this.rootDisplay;
        }

        public void open() {
            NbJavaCvsFileSystem nbJavaCvsFileSystem = (NbJavaCvsFileSystem)this.getFileSystem();
            RevisionExplorerAction.openAction(this.getItem().getRevision(), nbJavaCvsFileSystem, this.getFileObject());
        }

        public SystemAction[] getActions() {
            SystemAction[] systemActionArray;
            ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>();
            NbJavaCvsFileSystem nbJavaCvsFileSystem = (NbJavaCvsFileSystem)this.getFileSystem();
            if (this.isFileNode()) {
                systemActionArray = nbJavaCvsFileSystem.getActions(Collections.singleton(this.FObj));
                if (systemActionArray != null) {
                    int n = 0;
                    while (n < systemActionArray.length) {
                        arrayList.add(systemActionArray[n]);
                        ++n;
                    }
                }
                arrayList.add(null);
                arrayList.add(SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = InfoNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)));
            } else {
                arrayList.add(SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = InfoNode.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)));
                arrayList.add(null);
                arrayList.add(SystemAction.get((Class)(class$org$netbeans$modules$cvsclient$commands$log$RevisionExplorerAction == null ? (class$org$netbeans$modules$cvsclient$commands$log$RevisionExplorerAction = InfoNode.class$("org.netbeans.modules.cvsclient.commands.log.RevisionExplorerAction")) : class$org$netbeans$modules$cvsclient$commands$log$RevisionExplorerAction)));
                arrayList.add(null);
                arrayList.add(SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = InfoNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)));
            }
            systemActionArray = new SystemAction[arrayList.size()];
            arrayList.toArray(systemActionArray);
            return systemActionArray;
        }

        public RevisionNode createInstance(RevisionList revisionList, RevisionItem revisionItem) {
            return new InfoNode(revisionList, revisionItem);
        }

        public RevisionNode createInstance(RevisionChildren revisionChildren) {
            return new InfoNode(revisionChildren);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

