/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class FileObjectSearchGroup
extends SearchGroup {
    static /* synthetic */ Class class$org$openide$filesystems$FileObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$filesystems$Repository;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    protected void add(SearchType searchType) {
        if (!Arrays.asList(searchType.getSearchTypeClasses()).contains(class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = FileObjectSearchGroup.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject)) {
            return;
        }
        ArrayList<SearchType> arrayList = new ArrayList<SearchType>(Arrays.asList(this.searchTypes));
        if (!arrayList.contains(searchType)) {
            arrayList.add(searchType);
        }
        this.searchTypes = arrayList.toArray(new SearchType[arrayList.size()]);
    }

    public void doSearch() {
        FileObject[] fileObjectArray = this.getFileFolders();
        if (fileObjectArray == null) {
            return;
        }
        int n = 0;
        while (n < fileObjectArray.length) {
            if (!this.scanFolder(fileObjectArray[n])) {
                return;
            }
            ++n;
        }
    }

    private FileObject[] getFileFolders() {
        Node[] nodeArray = FileObjectSearchGroup.normalizeNodes(this.searchRoots.toArray(new Node[this.searchRoots.size()]));
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(nodeArray.length);
        if (nodeArray.length == 1) {
            InstanceCookie instanceCookie = (InstanceCookie)nodeArray[0].getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = FileObjectSearchGroup.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            try {
                if (instanceCookie != null && (class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = FileObjectSearchGroup.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository).isAssignableFrom(instanceCookie.instanceClass())) {
                    Repository repository = TopManager.getDefault().getRepository();
                    Enumeration enumeration = repository.getFileSystems();
                    while (enumeration.hasMoreElements()) {
                        FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                        if (!fileSystem.isValid() || fileSystem.isHidden()) continue;
                        arrayList.add(fileSystem.getRoot());
                    }
                    return arrayList.toArray(new FileObject[arrayList.size()]);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        int n = 0;
        while (n < nodeArray.length) {
            DataFolder dataFolder = (DataFolder)nodeArray[n].getCookie(class$org$openide$loaders$DataFolder == null ? FileObjectSearchGroup.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
            if (dataFolder != null) {
                arrayList.add(dataFolder.getPrimaryFile());
            }
            ++n;
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private boolean scanFolder(FileObject fileObject) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = 0;
        while (n < fileObjectArray.length) {
            if (this.stopped) {
                this.stopped = true;
                return false;
            }
            if (fileObjectArray[n].isFolder()) {
                if (!this.scanFolder(fileObjectArray[n])) {
                    return false;
                }
            } else {
                this.processSearchObject(fileObjectArray[n]);
            }
            ++n;
        }
        return true;
    }

    public Node getNodeForFoundObject(final Object object) {
        if (!(object instanceof FileObject)) {
            return null;
        }
        try {
            return DataObject.find((FileObject)((FileObject)object)).getNodeDelegate();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return new AbstractNode(Children.LEAF){

                public String getName() {
                    return ((FileObject)object).getName();
                }
            };
        }
    }

    private static Node[] normalizeNodes(Node[] nodeArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (n < nodeArray.length) {
            if (!FileObjectSearchGroup.hasParent(nodeArray[n], nodeArray)) {
                arrayList.add(nodeArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private static boolean hasParent(Node node, Node[] nodeArray) {
        Node node2 = node.getParentNode();
        while (node2 != null) {
            int n = 0;
            while (n < nodeArray.length) {
                if (nodeArray[n].equals(node2)) {
                    return true;
                }
                ++n;
            }
            node2 = node2.getParentNode();
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

