/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.nodes.looks;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.openide.util.RequestProcessor;
import org.openidex.nodes.looks.Look;
import org.openidex.nodes.looks.LookNode;

public abstract class EventTranslator
extends WeakReference {
    private static ReferenceQueue QUEUE = new ReferenceQueue();
    private static int CLEANER_TIME = 25000;
    private static RequestProcessor.Task CLEANER_TASK = RequestProcessor.postRequest((Runnable)new Cleaner(), (int)CLEANER_TIME, (int)1);
    private static final LookNode NULL_NODE = new LookNode(null);

    public EventTranslator(Look.NodeSubstitute nodeSubstitute) {
        super(nodeSubstitute, QUEUE);
    }

    protected abstract void unregister();

    protected Look.NodeSubstitute getSubstitute() {
        Look.NodeSubstitute nodeSubstitute = (Look.NodeSubstitute)this.get();
        if (nodeSubstitute == null) {
            this.unregister();
            return NULL_NODE.getSubstitute();
        }
        return nodeSubstitute;
    }

    private static final class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        public void run() {
            EventTranslator eventTranslator;
            while ((eventTranslator = (EventTranslator)QUEUE.poll()) != null) {
                eventTranslator.unregister();
            }
            CLEANER_TASK.schedule(CLEANER_TIME);
        }
    }
}

