/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.wizard.JarContentsWizardIterator;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RecipeNamePanel
extends JPanel
implements WizardDescriptor.FinishPanel,
JarContentsWizardIterator.JarContentEditor {
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel == null ? (class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel = RecipeNamePanel.class$("org.netbeans.modules.jarpackager.wizard.RecipeNamePanel")) : class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel));
    private ChangeListener listener;
    private String extension;
    DataFolder targetFolder;
    File current;
    File currentParent;
    FileObjectFilter currentFilter;
    private FileObjectFilter filtervalue;
    private DefaultComboBoxModel model;
    private boolean setByUser = false;
    private boolean parentDirty = false;
    private boolean jarNameDirty = false;
    private JTextField generatedJarName;
    private JTextField generatedJarLocation;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JTextField targetName;
    private JComboBox filtersComboBox;
    private JButton BrowseButton;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel;

    public RecipeNamePanel(int n) {
        this.initComponents();
        this.setName(bundle.getString("TIT_RecipeName"));
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(n));
        this.model = new DefaultComboBoxModel();
        this.model.addElement(JarContent.DEFAULT);
        this.model.addElement(JarContent.CLASSES_ONLY);
        this.model.addElement(JarContent.ALL);
        this.filtersComboBox.setModel(this.model);
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel == null ? (class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel = RecipeNamePanel.class$("org.netbeans.modules.jarpackager.wizard.RecipeNamePanel")) : class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel).getName());
        this.BrowseButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACCD_Browse"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACCD_RecipeNamePanel"));
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return HelpCtx.findHelp((Component)this.getComponent());
    }

    public void readSettings(Object object) {
        Object object2;
        TemplateWizard templateWizard = (TemplateWizard)object;
        DataObject dataObject = templateWizard.getTemplate();
        if (dataObject != null) {
            this.extension = dataObject.getPrimaryFile().getExt();
        }
        try {
            object2 = templateWizard.getTargetName();
            if (object2 == null || ((String)object2).length() == 0) {
                object2 = RecipeNamePanel.defaultName();
            }
            this.targetName.setText((String)object2);
            this.targetFolder = templateWizard.getTargetFolder();
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
        }
        object2 = JarContentsWizardIterator.getJarContent(templateWizard);
        File file = JarContentsWizardIterator.getJarFile(templateWizard);
        if (this.setByUser) {
            this.current = ((JarContent)object2).getTargetFile();
            this.currentParent = this.current.getParentFile();
        } else {
            this.current = file;
            this.currentParent = this.current.getParentFile();
        }
        this.generatedJarName.setText(this.current.getName());
        if (this.derivedJarName().equals(this.current.getName())) {
            this.jarNameDirty = false;
        }
        this.generatedJarLocation.setText(this.current.getParent());
        this.filtersComboBox.setSelectedItem(((JarContent)object2).getFilter());
    }

    public void storeSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)object;
        JarContent jarContent = JarContentsWizardIterator.getJarContent(templateWizard);
        String string = this.targetName.getText();
        if (string.equals(RecipeNamePanel.defaultName())) {
            string = null;
        }
        templateWizard.setTargetName(string);
        File file = JarContentsWizardIterator.getJarFile(templateWizard);
        if (!this.generatedJarName.getText().equals(RecipeNamePanel.defaultJarName())) {
            this.current = new File(this.currentParent, this.generatedJarName.getText());
            jarContent.setTargetFile(this.current);
            this.setByUser = true;
        } else if (this.parentDirty) {
            this.current = new File(this.currentParent, this.derivedJarName());
            jarContent.setTargetFile(this.current);
            this.setByUser = true;
        }
        jarContent.setFilter((FileObjectFilter)this.filtersComboBox.getSelectedItem());
    }

    public boolean isValid() {
        return true;
    }

    public void requestFocus() {
        this.targetName.requestFocus();
        this.targetName.selectAll();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listener = null;
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    private static String defaultName() {
        return bundle.getString("FMT_DefaultName");
    }

    private static String defaultJarName() {
        return RecipeNamePanel.defaultName() + "." + JarContentsWizardIterator.getExt();
    }

    private String derivedJarName() {
        return this.targetName.getText() + "." + JarContentsWizardIterator.getExt();
    }

    private void browseRecipeLocation() {
        JFileChooser jFileChooser = new JFileChooser(this.currentParent);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, bundle.getString("CTL_Select"));
        if (n == 0) {
            this.currentParent = jFileChooser.getSelectedFile();
            this.generatedJarLocation.setText(this.currentParent.getPath());
            this.parentDirty = true;
        }
    }

    public void applyChanges(JarContent jarContent, JarContent jarContent2) {
        File file = jarContent2.getTargetFile();
        if (file != null) {
            jarContent.setTargetFile(file);
        }
        FileObjectFilter fileObjectFilter = jarContent2.getFilter();
        jarContent.setFilter(fileObjectFilter);
    }

    public void handleTargetNameChange() {
        if (this.jarNameDirty) {
            return;
        }
        this.generatedJarName.setText(this.derivedJarName());
        this.current = new File(this.currentParent, this.generatedJarName.getText());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.targetName = new JTextField();
        this.jLabel2 = new JLabel();
        this.generatedJarLocation = new JTextField();
        this.BrowseButton = new JButton();
        this.jLabel3 = new JLabel();
        this.generatedJarName = new JTextField();
        this.jLabel4 = new JLabel();
        this.filtersComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(700, 300));
        this.setMinimumSize(new Dimension(200, 100));
        this.jLabel1.setText(bundle.getString("CTL_RecipeName"));
        this.jLabel1.setLabelFor(this.targetName);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 30, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.targetName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecipeNamePanel.this.targetNameActionPerformed(actionEvent);
            }
        });
        this.targetName.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                RecipeNamePanel.this.targetNameFocusLost(focusEvent);
            }
        });
        this.targetName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                RecipeNamePanel.this.targetNameKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                RecipeNamePanel.this.targetNameKeyReleased(keyEvent);
            }
        });
        this.targetName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACCD_RecipeTargetName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 15, 30, 15);
        this.add((Component)this.targetName, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("CTL_GeneratedJarLocation"));
        this.jLabel2.setLabelFor(this.generatedJarLocation);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.generatedJarLocation.setEditable(false);
        this.generatedJarLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecipeNamePanel.this.generatedJarLocationActionPerformed(actionEvent);
            }
        });
        this.generatedJarLocation.getAccessibleContext().setAccessibleDescription(bundle.getString("ACCD_RecipeGeneratedJarLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.add((Component)this.generatedJarLocation, gridBagConstraints);
        this.BrowseButton.setText(bundle.getString("CTL_Browse"));
        this.BrowseButton.setMnemonic(bundle.getString("MNM_Browse").charAt(0));
        this.BrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecipeNamePanel.this.BrowseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.add((Component)this.BrowseButton, gridBagConstraints);
        this.jLabel3.setText(bundle.getString("CTL_GeneratedJarName"));
        this.jLabel3.setLabelFor(this.generatedJarName);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.generatedJarName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecipeNamePanel.this.generatedJarNameActionPerformed(actionEvent);
            }
        });
        this.generatedJarName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                RecipeNamePanel.this.generatedJarNameKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                RecipeNamePanel.this.generatedJarNameKeyReleased(keyEvent);
            }
        });
        this.generatedJarName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACCD_RecipeGeneratedJarName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.add((Component)this.generatedJarName, gridBagConstraints);
        this.jLabel4.setText(bundle.getString("CTL_Filter"));
        this.jLabel4.setLabelFor(this.filtersComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.filtersComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACCD_RecipeFiltersComboBox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.add((Component)this.filtersComboBox, gridBagConstraints);
    }

    private void targetNameFocusLost(FocusEvent focusEvent) {
    }

    private void generatedJarNameKeyReleased(KeyEvent keyEvent) {
        if (this.generatedJarName.getText().equals("")) {
            this.generatedJarName.setText(this.derivedJarName());
            this.generatedJarName.selectAll();
        }
        this.current = new File(this.currentParent, this.generatedJarName.getText());
        this.jarNameDirty = !this.derivedJarName().equals(this.current.getName());
    }

    private void targetNameKeyReleased(KeyEvent keyEvent) {
        if (this.targetName.getText().equals("")) {
            this.targetName.setText(RecipeNamePanel.defaultName());
            this.targetName.selectAll();
        }
        this.handleTargetNameChange();
    }

    private void generatedJarNameKeyPressed(KeyEvent keyEvent) {
        this.jarNameDirty = true;
    }

    private void targetNameKeyPressed(KeyEvent keyEvent) {
    }

    private void generatedJarNameActionPerformed(ActionEvent actionEvent) {
    }

    private void BrowseButtonActionPerformed(ActionEvent actionEvent) {
        this.browseRecipeLocation();
    }

    private void targetNameActionPerformed(ActionEvent actionEvent) {
        this.targetName.setText(this.targetName.getText().trim());
        if (this.targetName.getText().equals("")) {
            this.targetName.setText(RecipeNamePanel.defaultName());
            this.targetName.selectAll();
        }
        this.handleTargetNameChange();
        this.fireStateChanged();
    }

    private void generatedJarLocationActionPerformed(ActionEvent actionEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

