/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.ManifestTab;
import org.netbeans.modules.jarpackager.api.ArchiveBuilder;
import org.netbeans.modules.jarpackager.api.ArchiveController;
import org.netbeans.modules.jarpackager.api.ArchiveEntry;
import org.netbeans.modules.jarpackager.api.ArchiveFilter;
import org.netbeans.modules.jarpackager.api.ArchiveMember;
import org.netbeans.modules.jarpackager.api.ExtendedPropertyFactory;
import org.netbeans.modules.jarpackager.api.FOArchiveEntry;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.netbeans.modules.jarpackager.util.ProgressListener;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class JarCreator {
    private static final int BLOCKSIZE = 65536;
    private static MessageFormat progressInfo;
    private static List builders;
    private List myBuilders;
    ArchiveDescriptor ad;
    HashSet listeners;
    ArchiveEntry curEntry;
    private static Map extendedProperties;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarCreator;

    public JarCreator(ArchiveDescriptor archiveDescriptor) {
        this.ad = archiveDescriptor;
        if (progressInfo == null) {
            progressInfo = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarCreator == null ? (class$org$netbeans$modules$jarpackager$JarCreator = JarCreator.class$("org.netbeans.modules.jarpackager.JarCreator")) : class$org$netbeans$modules$jarpackager$JarCreator)).getString("FMT_ProgressInfo"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJar(FileObject fileObject) throws IOException {
        File file = NbClassPath.toFile((FileObject)fileObject);
        FileLock fileLock = fileObject.lock();
        try {
            this.createJar(file);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    public void createJar(OutputStream outputStream, File file) throws IOException {
        this.doCreateJar(outputStream, file);
        JarCreator.recognizeFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJar(File file) throws IOException {
        File file2;
        block8: {
            file2 = null;
            OutputStream outputStream = null;
            try {
                file2 = File.createTempFile("jarpackager", null, file.getParentFile());
                outputStream = new FileOutputStream(file2);
                this.doCreateJar(outputStream, file);
                outputStream.close();
                outputStream = null;
                JarCreator.copyFile(file2, file);
                Object var5_4 = null;
                if (outputStream == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (file2 != null) {
                    file2.delete();
                }
                throw throwable;
            }
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (file2 != null) {
            file2.delete();
        }
        JarCreator.recognizeFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyFile(File file, File file2) throws IOException {
        Exception exception3;
        FileOutputStream fileOutputStream;
        block11: {
            FileInputStream fileInputStream = null;
            fileOutputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                FileUtil.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
                Object var5_4 = null;
                if (fileInputStream == null) break block11;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var5_5 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception3) {}
        }
    }

    public FileObject getProcessedFileObject() {
        ArchiveEntry archiveEntry = this.getProcessedEntry();
        if (archiveEntry == null || !(archiveEntry instanceof FOArchiveEntry)) {
            ContentMemberList contentMemberList = ((JarContent)this.ad).getContentList();
            if (contentMemberList.size() > 0) {
                return (FileObject)contentMemberList.get(0);
            }
            return null;
        }
        return ((FOArchiveEntry)archiveEntry).getFileObject();
    }

    public ArchiveEntry getProcessedEntry() {
        return this.curEntry;
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(progressListener);
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(progressListener);
    }

    public static synchronized boolean addBuilder(ArchiveBuilder archiveBuilder) {
        return builders.contains(archiveBuilder) ? false : builders.add(archiveBuilder);
    }

    public static synchronized boolean removeBuilder(ArchiveBuilder archiveBuilder) {
        return builders.remove(archiveBuilder);
    }

    public synchronized boolean addSpecificBuilder(ArchiveBuilder archiveBuilder) {
        if (this.myBuilders == null) {
            this.myBuilders = new ArrayList();
        }
        return this.myBuilders.contains(archiveBuilder) ? false : this.myBuilders.add(archiveBuilder);
    }

    public synchronized boolean removeSpecificBuilder(ArchiveBuilder archiveBuilder) {
        return this.myBuilders == null ? false : this.myBuilders.remove(archiveBuilder);
    }

    synchronized ArchiveBuilder[] getBuilders() {
        ArrayList arrayList;
        if (this.myBuilders == null) {
            arrayList = builders;
        } else {
            arrayList = new ArrayList(builders);
            arrayList.addAll(this.myBuilders);
        }
        ArchiveBuilder[] archiveBuilderArray = new ArchiveBuilder[arrayList.size()];
        return arrayList.toArray(archiveBuilderArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProgressEvent(int n, String string) {
        HashSet hashSet;
        if (this.listeners == null) {
            return;
        }
        JarCreator jarCreator = this;
        synchronized (jarCreator) {
            hashSet = (HashSet)this.listeners.clone();
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((ProgressListener)iterator.next()).progress(n, string);
        }
    }

    public static String getCanonicalTargetName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equals("<root>")) {
            return string;
        }
        if (!string.endsWith("/")) {
            return string + "/";
        }
        return string;
    }

    private ArchiveController[] initControllers(File file, Map map) {
        Object object;
        ArchiveBuilder[] archiveBuilderArray = this.getBuilders();
        ArrayList<ArchiveController[]> arrayList = new ArrayList<ArchiveController[]>();
        int n = 0;
        while (n < archiveBuilderArray.length) {
            object = archiveBuilderArray[n].initController(file, map);
            if (object != null) {
                arrayList.add((ArchiveController[])object);
            }
            ++n;
        }
        object = new ArchiveController[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    private ArchiveMember[] processMemberSet(ArchiveDescriptor archiveDescriptor, ArchiveController[] archiveControllerArray) throws IOException {
        ContentMemberList.ArchiveMemberSetImpl archiveMemberSetImpl = new ContentMemberList.ArchiveMemberSetImpl(archiveDescriptor.getContentList());
        do {
            archiveMemberSetImpl.setUnchanged();
            int n = 0;
            while (n < archiveControllerArray.length) {
                archiveControllerArray[n].processMemberSet(archiveMemberSetImpl);
                ++n;
            }
        } while (archiveMemberSetImpl.wasChanged());
        return archiveMemberSetImpl.allMembers();
    }

    private List makeArchiveEntries(ArchiveFilter archiveFilter, ArchiveMember[] archiveMemberArray) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < archiveMemberArray.length) {
            Object object;
            Object object2;
            DataFolder dataFolder;
            DataObject dataObject = archiveMemberArray[n].getDataObject();
            Iterator iterator = null;
            if (dataObject instanceof DataFolder) {
                dataFolder = (DataFolder)dataObject;
                object2 = dataFolder.secondaryEntries();
                int n2 = object2.size();
                if (n2 > 0) {
                    object = new HashSet<FileObject>(n2);
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        MultiDataObject.Entry entry = (MultiDataObject.Entry)iterator2.next();
                        ((HashSet)object).add(entry.getFile());
                    }
                    iterator = ((HashSet)object).iterator();
                }
            } else {
                iterator = archiveMemberArray[n].getDataObject().files().iterator();
            }
            while (iterator != null && iterator.hasNext()) {
                dataFolder = (FileObject)iterator.next();
                if (archiveFilter != null && !archiveFilter.accept((FileObject)dataFolder)) {
                    dataFolder = null;
                } else {
                    object2 = archiveMemberArray[n].getFilter();
                    if (object2 != null && !object2.accept((FileObject)dataFolder)) {
                        dataFolder = null;
                    }
                }
                if (dataFolder == null) continue;
                String string = JarCreator.getCanonicalTargetName(archiveMemberArray[n].getTargetDirectory());
                if (string == null) {
                    string = dataFolder.getParent().getPackageName('/');
                }
                if ((object = archiveMemberArray[n].getTargetName()) == null || ((String)object).length() == 0) {
                    object = dataFolder.getNameExt();
                }
                if (string.equals("<root>")) {
                    object2 = new FOArchiveEntry((FileObject)dataFolder, (String)object);
                } else {
                    if (string.length() > 0 && !string.endsWith("/")) {
                        string = string + "/";
                    }
                    object2 = new FOArchiveEntry((FileObject)dataFolder, string + (String)object);
                }
                arrayList.add(object2);
            }
            ++n;
        }
        return arrayList;
    }

    private void addEntries(ArchiveController[] archiveControllerArray, List list) throws IOException {
        HashSet<String> hashSet = null;
        int n = 0;
        while (n < archiveControllerArray.length) {
            ArchiveEntry[] archiveEntryArray = archiveControllerArray[n].addEntry();
            if (archiveEntryArray != null) {
                if (hashSet == null) {
                    hashSet = new HashSet<String>(list.size());
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        hashSet.add(((ArchiveEntry)iterator.next()).getName());
                    }
                }
                int n2 = 0;
                while (n2 < archiveEntryArray.length) {
                    if (archiveEntryArray[n2] != null && !hashSet.contains(archiveEntryArray[n2].getName())) {
                        list.add(archiveEntryArray[n2]);
                        hashSet.add(archiveEntryArray[n2].getName());
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private List willPostprocess(ArchiveController[] archiveControllerArray, List list) throws IOException {
        ArrayList<ArchiveController> arrayList = null;
        ArrayList<AnnotatedEntry> arrayList2 = new ArrayList<AnnotatedEntry>();
        int n = 0;
        while (n < list.size()) {
            ArchiveEntry archiveEntry = (ArchiveEntry)list.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList<ArchiveController>();
            }
            ArchiveController archiveController = null;
            ArchiveController archiveController2 = null;
            int n2 = 0;
            while (n2 < archiveControllerArray.length) {
                int n3 = archiveControllerArray[n2].willPostprocess(archiveEntry);
                switch (n3) {
                    case 1: {
                        arrayList.add(archiveControllerArray[n2]);
                        break;
                    }
                    case 2: {
                        if (archiveController != null) {
                            // empty if block
                        }
                        archiveController = archiveControllerArray[n2];
                        break;
                    }
                    case 3: {
                        if (archiveController2 != null) {
                            // empty if block
                        }
                        archiveController2 = archiveControllerArray[n2];
                    }
                }
                ++n2;
            }
            if (archiveController != null) {
                arrayList.add(0, archiveController);
            }
            if (archiveController2 != null) {
                arrayList.add(archiveController2);
            }
            ArrayList<ArchiveController> arrayList3 = null;
            if (arrayList.size() > 0) {
                arrayList3 = arrayList;
                arrayList = null;
            }
            AnnotatedEntry annotatedEntry = new AnnotatedEntry(archiveEntry, arrayList3);
            arrayList2.add(annotatedEntry);
            ++n;
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCreateJar(OutputStream outputStream, File file) throws IOException {
        Object object;
        Object object2;
        ArchiveEntry archiveEntry;
        Manifest manifest;
        List list;
        block17: {
            long l = System.currentTimeMillis();
            ArchiveController[] archiveControllerArray = this.initControllers(file, this.ad.getExtendedProperties());
            ArchiveMember[] archiveMemberArray = this.processMemberSet(this.ad, archiveControllerArray);
            List list2 = this.makeArchiveEntries(this.ad.getFilter(), archiveMemberArray);
            this.addEntries(archiveControllerArray, list2);
            list = this.willPostprocess(archiveControllerArray, list2);
            manifest = this.ad.getManifest();
            archiveEntry = null;
            if (manifest != null && manifest.getMainAttributes().size() == 0 && manifest.getEntries().size() == 0) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (AnnotatedEntry)object2.next();
                    if (!((AnnotatedEntry)object).entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                    if (((AnnotatedEntry)object).controllers != null && ((AnnotatedEntry)object).controllers.size() > 0) {
                        throw new IOException(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarCreator == null ? (class$org$netbeans$modules$jarpackager$JarCreator = JarCreator.class$("org.netbeans.modules.jarpackager.JarCreator")) : class$org$netbeans$modules$jarpackager$JarCreator)).getString("MSG_CannotPostprocessManifest"));
                    }
                    archiveEntry = ((AnnotatedEntry)object).entry;
                }
                try {
                    if (archiveEntry == null) break block17;
                    object = archiveEntry.createInputStream();
                    try {
                        manifest = ManifestTab.readManifest((InputStream)object);
                        ManifestTab.ensureVersionAttribute(manifest);
                        Object var14_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        ((InputStream)object).close();
                        throw throwable;
                    }
                    ((InputStream)object).close();
                    {
                    }
                }
                catch (IOException iOException) {
                    String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarCreator == null ? (class$org$netbeans$modules$jarpackager$JarCreator = JarCreator.class$("org.netbeans.modules.jarpackager.JarCreator")) : class$org$netbeans$modules$jarpackager$JarCreator)).getString("FMT_CanNotReadManifest"), iOException.getMessage());
                    throw new IOException(string);
                }
            }
        }
        object2 = manifest == null ? new JarOutputStream(outputStream) : new JarOutputStream(outputStream, manifest);
        try {
            ((ZipOutputStream)object2).setMethod(8);
            ((ZipOutputStream)object2).setLevel(this.ad.getCompLevel().getValue());
            this.curEntry = null;
            object = null;
            JarEntry jarEntry = null;
            long l = 0L;
            InputStream inputStream = null;
            long l2 = 1L;
            double d = (double)list.size() / 100.0;
            String string = file.getAbsolutePath();
            int n = string.lastIndexOf(".");
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = string + "." + JarPackagerOption.singleton().getContentExt();
            File file2 = new File(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object var30_31;
                Object object3;
                AnnotatedEntry annotatedEntry = (AnnotatedEntry)iterator.next();
                this.curEntry = annotatedEntry.entry;
                if (this.curEntry == archiveEntry || this.curEntry instanceof FOArchiveEntry && (object3 = NbClassPath.toFile((FileObject)((FOArchiveEntry)this.curEntry).getFileObject())) != null && (file.compareTo((File)object3) == 0 || file2.compareTo((File)object3) == 0)) continue;
                try {
                    inputStream = this.curEntry.createInputStream();
                }
                catch (IOException iOException) {
                    JarCreator.cannotAdd(this.curEntry);
                    continue;
                }
                object = new BufferedInputStream(inputStream);
                jarEntry = new JarEntry(this.curEntry.getName());
                ((JarOutputStream)object2).putNextEntry(jarEntry);
                try {
                    object3 = object;
                    if (annotatedEntry.controllers != null) {
                        int n2 = 0;
                        while (n2 < annotatedEntry.controllers.size()) {
                            ArchiveController archiveController = (ArchiveController)annotatedEntry.controllers.get(n2);
                            object3 = archiveController.postProcess(this.curEntry, (InputStream)object3);
                            ++n2;
                        }
                    }
                    FileUtil.copy((InputStream)object3, (OutputStream)object2);
                    var30_31 = null;
                }
                catch (Throwable throwable) {
                    var30_31 = null;
                    ((BufferedInputStream)object).close();
                    throw throwable;
                }
                ((BufferedInputStream)object).close();
                ((ZipOutputStream)object2).closeEntry();
                this.fireProgressEvent((int)Math.round((double)l2++ / d), progressInfo.format(new Object[]{this.curEntry.getName()}));
            }
            Object var32_33 = null;
        }
        catch (Throwable throwable) {
            Object var32_34 = null;
            ((ZipOutputStream)object2).finish();
            this.curEntry = null;
            throw throwable;
        }
        ((ZipOutputStream)object2).finish();
        this.curEntry = null;
        return true;
    }

    private static void showWarning(String string) {
        String string2 = NbBundle.getBundle((String)"org.openide.compiler.Bundle").getString("CTL_CompileTab");
        TopManager.getDefault().getStdOut().println(string);
        InputOutput inputOutput = TopManager.getDefault().getIO(string2, false);
        if (inputOutput != null) {
            inputOutput.getOut().println(string);
        }
    }

    private static void cannotAdd(ArchiveEntry archiveEntry) {
        String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarCreator == null ? (class$org$netbeans$modules$jarpackager$JarCreator = JarCreator.class$("org.netbeans.modules.jarpackager.JarCreator")) : class$org$netbeans$modules$jarpackager$JarCreator)).getString("FMT_CannotAddFo"), archiveEntry.getName());
        JarCreator.showWarning(string);
    }

    static void recognizeFile(File file) {
        String string;
        int n;
        FileObject[] fileObjectArray = null;
        File file2 = file.getParentFile();
        if (file2 != null) {
            fileObjectArray = FileUtil.fromFile((File)file2);
        }
        if (fileObjectArray != null && (n = (string = file.getName()).lastIndexOf(46)) >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            int n2 = 0;
            while (n2 < fileObjectArray.length) {
                fileObjectArray[n2].refresh();
                FileObject fileObject = fileObjectArray[n2].getFileObject(string2, string3);
                if (fileObject != null) {
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fileObject);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
    }

    public static synchronized boolean addExtendedProperty(ExtendedPropertyFactory extendedPropertyFactory) {
        String string = extendedPropertyFactory.getName();
        ExtendedPropertyFactory extendedPropertyFactory2 = extendedProperties.put(string, extendedPropertyFactory);
        return extendedPropertyFactory2 != extendedPropertyFactory;
    }

    public static synchronized boolean removeExtendedProperty(String string) {
        return extendedProperties.remove(string) != null;
    }

    static synchronized Map getExtendedProperties() {
        return new HashMap(extendedProperties);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        builders = new ArrayList();
        extendedProperties = new HashMap();
    }

    static class AnnotatedEntry {
        ArchiveEntry entry;
        List controllers;

        AnnotatedEntry(ArchiveEntry archiveEntry, List list) {
            this.entry = archiveEntry;
            this.controllers = list;
        }
    }
}

