/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.netbeans.modules.jarpackager.CompressionLevel;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.api.ExtendedPropertyFactory;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.netbeans.modules.jarpackager.util.JarUtils;
import org.netbeans.modules.jarpackager.util.VersionSerializator;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JarContent
implements ArchiveDescriptor,
Cloneable {
    public static final FileObjectFilter CLASSES_ONLY = new ClassesOnlyFilter();
    public static final FileObjectFilter DEFAULT = new AllButJavaFilter();
    public static final FileObjectFilter ALL = new AcceptAllFilter();
    ContentMemberList contentList;
    FileObjectFilter filter;
    Manifest manifest;
    boolean manifestFileList;
    boolean mainAttributes;
    CompressionLevel compressionLevel;
    File targetFile;
    Map extendedProperties;
    private boolean sameFolder;
    private List sameFSPath;
    VersionSerializator serializationManager;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarContent;

    public JarContent() {
        this(DEFAULT);
    }

    public JarContent(FileObjectFilter fileObjectFilter) {
        this.filter = fileObjectFilter;
        this.manifestFileList = false;
        this.compressionLevel = new CompressionLevel();
        this.mainAttributes = true;
    }

    public void putFile(FileObject fileObject) {
        try {
            this.addDataObject(DataObject.find((FileObject)fileObject));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)dataObjectNotFoundException);
        }
    }

    public void putFiles(FileObject[] fileObjectArray) {
        int n = 0;
        while (n < fileObjectArray.length) {
            this.putFile(fileObjectArray[n]);
            ++n;
        }
    }

    public void putFiles(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.putFile((FileObject)iterator.next());
        }
    }

    public void removeFile(FileObject fileObject) {
        try {
            this.removeDataObject(DataObject.find((FileObject)fileObject));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)dataObjectNotFoundException);
        }
    }

    public void removeFiles(FileObject[] fileObjectArray) {
        int n = 0;
        while (n < fileObjectArray.length) {
            this.removeFile(fileObjectArray[n]);
            ++n;
        }
    }

    public void clear() {
        this.getContentList().clear();
    }

    public FileObjectFilter getFilter() {
        return this.filter;
    }

    public synchronized void setFilter(FileObjectFilter fileObjectFilter) {
        this.filter = fileObjectFilter;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public Manifest getManifest() {
        return this.manifest();
    }

    public String saveManifest() {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.getManifest().write(byteArrayOutputStream);
            string = byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            string = "";
        }
        return string;
    }

    public void restoreManifest(String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            Manifest manifest = new Manifest();
            manifest.read(byteArrayInputStream);
            this.setManifest(manifest);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setManifestFileList(boolean bl) {
        this.manifestFileList = bl;
    }

    public boolean isManifestFileList() {
        return this.manifestFileList;
    }

    public void setMainAttributes(boolean bl) {
        this.mainAttributes = bl;
    }

    public boolean isMainAttributes() {
        return this.mainAttributes;
    }

    public File getTargetFile() {
        if (this.targetFile != null) {
            return this.targetFile.getAbsoluteFile();
        }
        return this.targetFile;
    }

    public void setTargetFile(File file) {
        this.targetFile = file;
    }

    public int getCompressionLevel() {
        return this.compressionLevel.getValue();
    }

    public void setCompressionLevel(int n) {
        this.compressionLevel = new CompressionLevel(n);
    }

    private Manifest manifest() {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        return this.manifest;
    }

    public Object getExtendedProperty(String string) {
        if (this.extendedProperties == null) {
            return null;
        }
        return this.extendedProperties.get(string);
    }

    public void setExtendedProperty(String string, Object object) {
        Map map = this.getExtendedProperties();
        map.put(string, object);
    }

    public Map getExtendedProperties() {
        if (this.extendedProperties == null) {
            this.extendedProperties = new HashMap();
        }
        return this.extendedProperties;
    }

    public void setExtendedProperties(Map map) {
        this.extendedProperties = map;
    }

    public void readContent(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.readContent(objectInput, null);
    }

    public void readContent(ObjectInput objectInput, FileObject fileObject) throws IOException, ClassNotFoundException {
        VersionSerializator versionSerializator = this.serializationManager();
        versionSerializator.readVersion(objectInput);
        if (fileObject != null) {
            if (this.sameFolder) {
                File file = this.getTargetFile();
                File file2 = FileUtil.toFile((FileObject)fileObject.getParent());
                if (file != null && file2 != null) {
                    this.setTargetFile(new File(file2, file.getName()));
                }
            } else if (this.sameFSPath != null) {
                try {
                    File file = FileUtil.toFile((FileObject)fileObject.getFileSystem().getRoot());
                    if (file != null) {
                        int n = this.sameFSPath.size() - 1;
                        while (n >= 0) {
                            file = new File(file, (String)this.sameFSPath.get(n));
                            --n;
                        }
                        this.setTargetFile(file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean targetInSameFolder(FileObject fileObject) {
        boolean bl = false;
        try {
            File file = this.getTargetFile();
            if (fileObject != null && file != null) {
                String string = NbClassPath.toFile((FileObject)fileObject.getParent()).getCanonicalPath();
                String string2 = file.getParent();
                String string3 = new File(string2).getCanonicalPath();
                bl = string3.equals(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private List targetInSameFS(FileObject fileObject) {
        ArrayList<String> arrayList;
        boolean bl;
        block4: {
            bl = false;
            arrayList = null;
            try {
                File file = fileObject == null ? null : FileUtil.toFile((FileObject)fileObject.getFileSystem().getRoot());
                File file2 = this.getTargetFile();
                if (file == null || file2 == null) break block4;
                arrayList = new ArrayList<String>();
                arrayList.add(file2.getName());
                for (File file3 = file2.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
                    if (file.equals(file3)) {
                        bl = true;
                        break;
                    }
                    arrayList.add(file3.getName());
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl ? arrayList : null;
    }

    public void writeContent(ObjectOutput objectOutput) throws IOException {
        this.writeContent(objectOutput, null);
    }

    public void writeContent(ObjectOutput objectOutput, FileObject fileObject) throws IOException {
        this.sameFolder = this.targetInSameFolder(fileObject);
        this.sameFSPath = this.sameFolder ? null : this.targetInSameFS(fileObject);
        VersionSerializator versionSerializator = this.serializationManager();
        versionSerializator.writeLastVersion(objectOutput);
    }

    private VersionSerializator serializationManager() {
        if (this.serializationManager == null) {
            this.serializationManager = new VersionSerializator();
            this.serializationManager.putVersion(new Version1Serializator(this));
        }
        return this.serializationManager;
    }

    public boolean addDataObject(DataObject dataObject) {
        return this.getContentList().addMember(dataObject);
    }

    public boolean removeDataObject(DataObject dataObject) {
        return this.getContentList().removeMember(dataObject);
    }

    public ContentMemberList getContentList() {
        if (this.contentList == null) {
            this.contentList = new ContentMemberList();
        }
        return this.contentList;
    }

    public void setContentList(ContentMemberList contentMemberList) {
        this.contentList = contentMemberList;
    }

    public String getTarget() {
        URL uRL = this.getTargetResource();
        return uRL != null ? uRL.toString() : null;
    }

    public URL getTargetResource() {
        if (this.targetFile == null) {
            return null;
        }
        try {
            return this.targetFile.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)malformedURLException);
            return null;
        }
    }

    public void setTarget(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)malformedURLException);
            return;
        }
        this.setTargetResource(uRL);
    }

    public void setTargetResource(URL uRL) {
        this.targetFile = JarUtils.urlToFile(uRL);
    }

    public CompressionLevel getCompLevel() {
        return this.compressionLevel;
    }

    public void setCompLevel(CompressionLevel compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static JarContent readFromFile(FileObject fileObject) {
        JarContent jarContent;
        block19: {
            ObjectInputStream objectInputStream;
            InputStream inputStream;
            block18: {
                jarContent = new JarContent();
                inputStream = null;
                objectInputStream = null;
                inputStream = fileObject.getInputStream();
                if (inputStream.available() <= 2) break block18;
                objectInputStream = new ObjectInputStream(inputStream);
                jarContent.readContent(objectInputStream, fileObject);
            }
            Object var9_4 = null;
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                } else if (inputStream != null) {
                    inputStream.close();
                }
                break block19;
            }
            catch (IOException iOException) {}
            break block19;
            {
                catch (Exception exception) {
                    ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                    String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = JarContent.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent)).getString("EXC_AnnotatedReadErrorAt");
                    String string2 = MessageFormat.format(string, fileObject.getPackageName('/'));
                    errorManager.annotate((Throwable)exception, string2);
                    errorManager.notify(65536, (Throwable)exception);
                    if (jarContent.getTargetFile() == null) {
                        jarContent.setTargetFile(JarContent.getDefaultTargetFile(fileObject));
                    }
                    Object var9_5 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        } else if (inputStream != null) {
                            inputStream.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_6 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    } else if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return jarContent;
    }

    public static File getDefaultTargetFile(FileObject fileObject) {
        File file;
        StringBuffer stringBuffer = new StringBuffer("jarRecipe");
        if (fileObject != null && (file = FileUtil.toFile((FileObject)fileObject)) != null) {
            stringBuffer.setLength(0);
            String string = file.getParent();
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append(File.separator);
            }
            stringBuffer.append(fileObject.getName());
        }
        stringBuffer.append('.');
        stringBuffer.append("jar");
        return new File(new String(stringBuffer));
    }

    public JarContent makeCopy() {
        JarContent jarContent = null;
        try {
            jarContent = (JarContent)super.clone();
            this.serializationManager = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return jarContent;
    }

    public void copyContentList(JarContent jarContent) {
        ContentMemberList contentMemberList = jarContent == null ? new ContentMemberList() : new ContentMemberList(jarContent.getContentList());
        this.setContentList(contentMemberList);
    }

    public void copyManifest(JarContent jarContent) {
        Manifest manifest = jarContent == null ? new Manifest() : new Manifest(jarContent.getManifest());
        this.setManifest(manifest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class Version1Serializator
    implements VersionSerializator.Versionable {
        JarContent jc;
        private static final String JCPA_JAR_IN_SAME_FOLDER = "SameFolder";
        private static final String JCPA_JAR_SAME_FS_PATH = "SameFSPath";

        public Version1Serializator(JarContent jarContent) {
            this.jc = jarContent;
        }

        public String getName() {
            return "Version_1.0";
        }

        public void readData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            Object object = objectInput.readObject();
            if (object instanceof ContentMemberList) {
                this.jc.setContentList((ContentMemberList)object);
            } else {
                this.jc.setContentList(new ContentMemberList((ArrayList)object));
            }
            this.jc.filter = (FileObjectFilter)objectInput.readObject();
            Object object2 = objectInput.readObject();
            this.jc.sameFolder = false;
            this.jc.sameFSPath = null;
            if (object2 instanceof Map) {
                Object v;
                Map map = (Map)object2;
                Object v2 = map.get(JCPA_JAR_IN_SAME_FOLDER);
                if (v2 != null && v2 instanceof Boolean) {
                    this.jc.sameFolder = (Boolean)v2;
                }
                if (!this.jc.sameFolder && (v = map.get(JCPA_JAR_SAME_FS_PATH)) != null && v instanceof List) {
                    this.jc.sameFSPath = (List)v;
                }
            }
            this.jc.setTargetFile((File)objectInput.readObject());
            this.jc.manifestFileList = (Boolean)objectInput.readObject();
            this.jc.mainAttributes = (Boolean)objectInput.readObject();
            objectInput.readObject();
            this.jc.setCompressionLevel((Integer)objectInput.readObject());
            if (((Boolean)objectInput.readObject()).booleanValue()) {
                this.jc.manifest = new Manifest();
                this.jc.manifest.read((InputStream)((Object)objectInput));
            }
            try {
                this.readExtendedProperties(objectInput, this.jc);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }

        public void writeData(ObjectOutput objectOutput) throws IOException {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(JCPA_JAR_IN_SAME_FOLDER, new Boolean(this.jc.sameFolder));
            if (this.jc.sameFSPath != null) {
                hashMap.put(JCPA_JAR_SAME_FS_PATH, this.jc.sameFSPath);
            }
            objectOutput.writeObject(this.jc.getContentList());
            objectOutput.writeObject(this.jc.filter);
            objectOutput.writeObject(hashMap);
            objectOutput.writeObject(this.jc.getTargetFile());
            objectOutput.writeObject(new Boolean(this.jc.manifestFileList));
            objectOutput.writeObject(new Boolean(this.jc.mainAttributes));
            objectOutput.writeObject(null);
            objectOutput.writeObject(new Integer(this.jc.getCompressionLevel()));
            objectOutput.writeObject(new Boolean(this.jc.manifest != null));
            if (this.jc.manifest != null) {
                this.jc.manifest.write((OutputStream)((Object)objectOutput));
            }
            this.writeExtendedProperties(objectOutput, this.jc);
        }

        private void readExtendedProperties(ObjectInput objectInput, JarContent jarContent) throws IOException, ClassNotFoundException {
            jarContent.extendedProperties = new HashMap();
            Map map = (Map)objectInput.readObject();
            Map map2 = JarCreator.getExtendedProperties();
            if (map == null || map2 == null) {
                return;
            }
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ExtendedPropertyFactory extendedPropertyFactory = (ExtendedPropertyFactory)map2.get(string);
                if (extendedPropertyFactory == null) continue;
                Node.Property property = extendedPropertyFactory.createProperty(null, jarContent);
                PropertyEditor propertyEditor = property.getPropertyEditor();
                propertyEditor.setAsText((String)map.get(string));
                try {
                    property.setValue(propertyEditor.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void writeExtendedProperties(ObjectOutput objectOutput, JarContent jarContent) throws IOException {
            HashMap<String, String> hashMap = null;
            Map map = JarCreator.getExtendedProperties();
            if (jarContent.extendedProperties != null && map != null) {
                hashMap = new HashMap<String, String>();
                Iterator iterator = jarContent.extendedProperties.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    ExtendedPropertyFactory extendedPropertyFactory = (ExtendedPropertyFactory)map.get(string);
                    if (extendedPropertyFactory == null) continue;
                    Node.Property property = extendedPropertyFactory.createProperty(null, jarContent);
                    PropertyEditor propertyEditor = property.getPropertyEditor();
                    try {
                        propertyEditor.setValue(property.getValue());
                        hashMap.put(string, propertyEditor.getAsText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            objectOutput.writeObject(hashMap);
        }
    }

    public static final class AcceptAllFilter
    implements FileObjectFilter {
        static final long serialVersionUID = 8921981094756492767L;

        public boolean accept(FileObject fileObject) {
            return true;
        }

        private Object readResolve() throws ObjectStreamException {
            return ALL;
        }

        public String toString() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = JarContent.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent)).getString("CTL_AcceptAllFilter");
        }

        public boolean equals(Object object) {
            return object instanceof AcceptAllFilter;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static final class AllButJavaFilter
    implements FileObjectFilter {
        static final long serialVersionUID = -6474655716324211768L;

        public boolean accept(FileObject fileObject) {
            String string = fileObject.getExt();
            return !"java".equals(string) && !"jar".equals(string) && !"form".equals(string) && !JarPackagerOption.singleton().getContentExt().equals(string);
        }

        private Object readResolve() throws ObjectStreamException {
            return DEFAULT;
        }

        public String toString() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = JarContent.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent)).getString("CTL_AllButJavaFilter");
        }

        public boolean equals(Object object) {
            return object instanceof AllButJavaFilter;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static final class ClassesOnlyFilter
    implements FileObjectFilter {
        static final long serialVersionUID = 7475557013758392767L;

        public boolean accept(FileObject fileObject) {
            return "class".equals(fileObject.getExt());
        }

        private Object readResolve() throws ObjectStreamException {
            return CLASSES_ONLY;
        }

        public String toString() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = JarContent.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent)).getString("CTL_ClassesOnlyFilter");
        }

        public boolean equals(Object object) {
            return object instanceof ClassesOnlyFilter;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

