/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.jarpackager.ContentMember;
import org.netbeans.modules.jarpackager.DataObjectList;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.api.ArchiveFilter;
import org.netbeans.modules.jarpackager.api.ArchiveMember;
import org.netbeans.modules.jarpackager.api.ArchiveMemberSet;
import org.netbeans.modules.jarpackager.util.JarUtils;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.util.NbBundle;

public class ContentMemberList
extends ArrayList
implements Serializable {
    static final long serialVersionUID = 7194592824986427208L;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ContentMemberList;

    public ContentMemberList() {
    }

    public ContentMemberList(Collection collection) {
        super(collection);
    }

    public ContentMemberList(int n) {
        super(n);
    }

    public ContentMemberList(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            String string;
            Object object;
            Object e = arrayList.get(n);
            if (e instanceof ContentMember) {
                this.add(e);
            } else if (e instanceof DataObject) {
                this.addMember((DataObject)e);
            } else if (e instanceof FileObject) {
                object = ContentMemberList.resolveFileObject((FileObject)e);
                if (object != null) {
                    this.addMember((DataObject)object);
                } else {
                    string = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ContentMemberList == null ? ContentMemberList.class$("org.netbeans.modules.jarpackager.ContentMemberList") : class$org$netbeans$modules$jarpackager$ContentMemberList)).getString("FMT_ContentFileNotFound");
                    System.out.println(MessageFormat.format(string, e));
                }
            } else {
                object = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ContentMemberList == null ? ContentMemberList.class$("org.netbeans.modules.jarpackager.ContentMemberList") : class$org$netbeans$modules$jarpackager$ContentMemberList)).getString("FMT_ContentBadClass`");
                string = e.getClass().getName();
                System.out.println(MessageFormat.format((String)object, string));
            }
            ++n;
        }
    }

    public boolean addMember(DataObject dataObject) {
        if (this.findDataObject(dataObject) == -1) {
            ContentMember contentMember = new ContentMember();
            contentMember.dataObject = dataObject;
            contentMember.isRecursive = true;
            this.add(contentMember);
            return true;
        }
        return false;
    }

    public boolean addMember(DataObject dataObject, String string) {
        return this.addMember(dataObject, string, null);
    }

    public boolean addMember(DataObject dataObject, String string, String string2) {
        if (this.findDataObject(dataObject) == -1) {
            ContentMember contentMember = new ContentMember();
            contentMember.dataObject = dataObject;
            contentMember.targetDirectory = string;
            if (!(dataObject instanceof DataFolder)) {
                contentMember.targetName = string2;
            }
            contentMember.isRecursive = true;
            this.add(contentMember);
            return true;
        }
        return false;
    }

    public void addList(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            Object e = arrayList.get(n);
            if (e instanceof DataObject) {
                this.addMember((DataObject)e);
            } else if (e instanceof ContentMember) {
                this.add(e);
            }
            ++n;
        }
    }

    public boolean removeMember(DataObject dataObject) {
        int n = this.findDataObject(dataObject);
        if (n != -1) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public boolean removeMember(int n) {
        if (n >= 0 && n < this.size()) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public int findDataObject(DataObject dataObject) {
        int n = 0;
        while (n < this.size()) {
            ContentMember contentMember = (ContentMember)this.get(n);
            if (contentMember.getDataObject().equals(dataObject)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public List getAllFiles(ArchiveFilter archiveFilter) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.size()) {
            ContentMember contentMember = (ContentMember)this.get(n);
            this.addFiles(arrayList, contentMember.getDataObject(), contentMember.isRecursive, archiveFilter, contentMember.getFilter());
            ++n;
        }
        return arrayList;
    }

    private void addFiles(List list, DataObject dataObject, boolean bl, ArchiveFilter archiveFilter, ArchiveFilter archiveFilter2) {
        FileObject fileObject;
        Object object;
        if (dataObject instanceof DataFolder) {
            object = ((DataFolder)dataObject).children(false);
            while (object.hasMoreElements()) {
                fileObject = (DataObject)object.nextElement();
                if (!bl && fileObject instanceof DataFolder) continue;
                this.addFiles(list, (DataObject)fileObject, bl, archiveFilter, archiveFilter2);
            }
        }
        object = dataObject.files().iterator();
        while (object.hasNext()) {
            fileObject = (FileObject)object.next();
            if (archiveFilter != null && !archiveFilter.accept(fileObject)) {
                fileObject = null;
            }
            if (fileObject != null && archiveFilter2 != null && !archiveFilter2.accept(fileObject)) {
                fileObject = null;
            }
            if (fileObject == null) continue;
            list.add(fileObject);
        }
    }

    public Enumeration enumerateDataObjects() {
        return new DataObjectEnumeration();
    }

    public boolean anyInvalid() {
        int n = 0;
        while (n < this.size()) {
            ContentMember contentMember = (ContentMember)this.get(n);
            if (!contentMember.getDataObject().isValid()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean resolveAll() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.size()) {
            ContentMember contentMember = (ContentMember)this.get(n2);
            DataObject dataObject = contentMember.getDataObject();
            if (!dataObject.isValid()) {
                DataObject dataObject2 = ContentMemberList.resolveDataObject(dataObject);
                if (dataObject2 != null) {
                    ContentMember contentMember2 = new ContentMember(dataObject2, contentMember);
                    this.set(n2, contentMember2);
                } else {
                    ++n;
                }
            }
            ++n2;
        }
        return n == 0;
    }

    static DataObject resolveDataObject(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        DataObject dataObject2 = null;
        String string = null;
        try {
            string = fileObject.getFileSystem().getSystemName();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            string = fileStateInvalidException.getFileSystemName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = fileObject.toString();
        Repository repository = TopManager.getDefault().getRepository();
        FileSystem fileSystem = string == null ? null : repository.findFileSystem(string);
        FileObject fileObject2 = null;
        if (fileSystem != null) {
            fileObject2 = fileSystem.findResource(string2);
        }
        if (fileObject2 == null) {
            fileObject2 = repository.findResource(string2);
        }
        if (fileObject2 != null) {
            dataObject2 = ContentMemberList.resolveFileObject(fileObject2);
        }
        if (dataObject2 != null) {
            // empty if block
        }
        return dataObject2;
    }

    static DataObject resolveFileObject(FileObject fileObject) {
        DataObject dataObject = null;
        try {
            dataObject = TopManager.getDefault().getLoaderPool().findDataObject(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            dataObject = dataObjectExistsException.getDataObject();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dataObject;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ArchiveMemberSetImpl
    implements ArchiveMemberSet {
        private Map entries = new HashMap();
        private ArchiveMember[] members = null;
        private boolean changed = false;

        ArchiveMemberSetImpl(ContentMemberList contentMemberList) {
            int n = 0;
            while (n < contentMemberList.size()) {
                ContentMember contentMember = (ContentMember)contentMemberList.get(n);
                ContentMember contentMember2 = contentMember.resolve();
                if (contentMember2.dataObject instanceof DataFolder) {
                    List list = this.expandFolder(contentMember2, contentMember2.isRecursive);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ContentMember contentMember3 = (ContentMember)iterator.next();
                        contentMember3.setFilter(contentMember2.filter);
                        this.addEntry(contentMember3);
                    }
                } else {
                    this.addEntry(contentMember2, contentMember2.dataObject, contentMember2.filter, contentMember2.targetDirectory, contentMember2.targetName);
                }
                ++n;
            }
        }

        ArchiveMemberSetImpl(DataObjectList dataObjectList) {
            this(new ContentMemberList(dataObjectList));
        }

        int size() {
            return this.entries.size();
        }

        void setChanged() {
            this.changed = true;
            this.members = null;
        }

        void setUnchanged() {
            this.changed = false;
        }

        boolean wasChanged() {
            return this.changed;
        }

        public ArchiveMember[] allMembers() {
            if (this.members == null) {
                ArchiveMember[] archiveMemberArray = new ArchiveMember[this.entries.size()];
                this.members = this.entries.values().toArray(archiveMemberArray);
            }
            return this.members;
        }

        public int addMember(DataObject dataObject, ArchiveFilter archiveFilter, String string) {
            if (dataObject == null) {
                return 0;
            }
            return this.addMember(dataObject, archiveFilter, string, null, false);
        }

        public int addMember(DataObject dataObject, ArchiveFilter archiveFilter, String string, String string2) {
            if (dataObject == null) {
                return 0;
            }
            return this.addMember(dataObject, archiveFilter, string, string2, false);
        }

        private int addMember(DataObject dataObject, ArchiveFilter archiveFilter, String string, String string2, boolean bl) {
            int n = 0;
            if (dataObject instanceof DataFolder) {
                List list = ArchiveMemberSetImpl.expandFolder((DataFolder)dataObject, bl, string);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ContentMember contentMember = (ContentMember)iterator.next();
                    contentMember.filter = archiveFilter;
                    if (!this.addEntry(contentMember)) continue;
                    ++n;
                }
            } else if (this.addEntry(dataObject, dataObject, archiveFilter, string, string2)) {
                ++n;
            }
            return n;
        }

        public int removeMember(DataObject dataObject) {
            int n = 0;
            if (dataObject == null) {
                return 0;
            }
            if (dataObject instanceof DataFolder) {
                List list = ArchiveMemberSetImpl.expandFolder((DataFolder)dataObject, false, null);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ContentMember contentMember = (ContentMember)iterator.next();
                    int n2 = this.removeMember(contentMember.dataObject);
                    if (n2 <= 0) continue;
                    this.setChanged();
                    n += n2;
                }
            } else {
                Object object = this.findDataObjectKey(dataObject);
                if (object != null && this.entries.remove(object) != null) {
                    this.setChanged();
                    ++n;
                }
            }
            return n;
        }

        Object findDataObjectKey(DataObject dataObject) {
            Iterator iterator = this.entries.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                ContentMember contentMember = (ContentMember)this.entries.get(k);
                if (!contentMember.getDataObject().equals(dataObject)) continue;
                return k;
            }
            return null;
        }

        public ArchiveMember getMember(DataObject dataObject) {
            Object object = this.findDataObjectKey(dataObject);
            if (object != null) {
                return (ArchiveMember)this.entries.get(object);
            }
            return null;
        }

        public ArchiveMember[] getMembers(DataFolder dataFolder) {
            Object object;
            if (dataFolder == null) {
                return new ArchiveMember[0];
            }
            ArrayList<ArchiveMember> arrayList = new ArrayList<ArchiveMember>();
            List list = ArchiveMemberSetImpl.expandFolder(dataFolder, false, null);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (ContentMember)iterator.next();
                ArchiveMember archiveMember = this.getMember(object.dataObject);
                if (archiveMember == null) continue;
                arrayList.add(archiveMember);
            }
            object = new ArchiveMember[arrayList.size()];
            return arrayList.toArray((T[])object);
        }

        private boolean addEntry(Object object, DataObject dataObject, ArchiveFilter archiveFilter, String string, String string2) {
            if (this.entries.get(object) == null) {
                this.entries.put(object, new ContentMember(dataObject, archiveFilter, string, string2));
                this.setChanged();
                return true;
            }
            return false;
        }

        private boolean addEntry(ContentMember contentMember) {
            if (this.entries.get(contentMember.dataObject) == null) {
                this.entries.put(contentMember, contentMember);
                this.setChanged();
                return true;
            }
            return false;
        }

        private List expandFolder(ContentMember contentMember, boolean bl) {
            return ArchiveMemberSetImpl.expandFolder((DataFolder)contentMember.dataObject, bl, contentMember.targetDirectory);
        }

        static List expandFolder(DataFolder dataFolder, boolean bl, String string) {
            string = JarCreator.getCanonicalTargetName(string);
            ArrayList<ContentMember> arrayList = new ArrayList<ContentMember>();
            Set set = dataFolder.secondaryEntries();
            if (set.size() > 0) {
                arrayList.add(new ContentMember((DataObject)dataFolder));
            }
            Enumeration enumeration = dataFolder.children(false);
            while (enumeration.hasMoreElements()) {
                DataObject dataObject = JarUtils.resolve((DataObject)enumeration.nextElement());
                if (!(dataObject instanceof DataFolder)) {
                    arrayList.add(new ContentMember(dataObject, null, string));
                    continue;
                }
                if (!bl) continue;
                String string2 = null;
                if ("<root>".equals(string)) {
                    string2 = dataObject.getName();
                } else if (string != null) {
                    string2 = string + dataObject.getName();
                }
                List list = ArchiveMemberSetImpl.expandFolder((DataFolder)dataObject, bl, string2);
                arrayList.addAll(list);
            }
            return arrayList;
        }
    }

    class DataObjectEnumeration
    implements Enumeration {
        private int index = 0;
        private int size;

        DataObjectEnumeration() {
            this.size = ContentMemberList.this.size();
        }

        public boolean hasMoreElements() {
            return this.index < this.size;
        }

        public Object nextElement() {
            ContentMember contentMember = (ContentMember)ContentMemberList.this.get(this.index++);
            return contentMember.getDataObject();
        }
    }
}

