/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;
import org.openidex.search.DataObjectSearchGroup;
import org.openidex.search.FileObjectSearchGroup;
import org.openidex.search.SearchType;

public abstract class SearchGroup {
    public static final String PROP_FOUND = "org.openidex.search.found";
    public static final String PROP_RESULT = "org.openidex.search.result";
    private PropertyChangeSupport propChangeSupport;
    protected SearchType[] searchTypes = new SearchType[0];
    protected final Set searchRoots = new HashSet(5);
    protected final Set searchObjects = new HashSet(50);
    protected final Set resultObjects = new HashSet(50);
    protected boolean stopped = false;
    private PropertyChangeListener propListener;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$filesystems$FileObject;

    protected void add(SearchType searchType) {
        ArrayList<SearchType> arrayList = new ArrayList<SearchType>(Arrays.asList(this.searchTypes));
        if (!arrayList.contains(searchType)) {
            arrayList.add(searchType);
        }
        this.searchTypes = arrayList.toArray(new SearchType[arrayList.size()]);
    }

    public SearchType[] getSearchTypes() {
        return this.searchTypes;
    }

    public void setSearchRootNodes(Node[] nodeArray) {
        int n = 0;
        while (n < this.searchTypes.length) {
            nodeArray = this.searchTypes[n].acceptSearchRootNodes(nodeArray);
            ++n;
        }
        this.searchRoots.clear();
        this.searchRoots.addAll(Arrays.asList(nodeArray));
    }

    public Node[] getSearchRoots() {
        return this.searchRoots.toArray(new Node[this.searchRoots.size()]);
    }

    public final void stopSearch() {
        this.stopped = true;
    }

    public void search() {
        this.prepareSearch();
        this.doSearch();
    }

    protected void prepareSearch() {
        int n = 0;
        while (n < this.searchTypes.length) {
            this.searchTypes[n].addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.getSearchTypeListener(), (Object)this.searchTypes[n]));
            ++n;
        }
    }

    private synchronized PropertyChangeListener getSearchTypeListener() {
        if (this.propListener == null) {
            this.propListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("org.openidex.search.objectChanged".equals(propertyChangeEvent.getPropertyName())) {
                        Object object = propertyChangeEvent.getNewValue();
                        int n = 0;
                        while (n < SearchGroup.this.searchTypes.length) {
                            if (!SearchGroup.this.searchTypes[n].testObject(object)) {
                                if (SearchGroup.this.resultObjects.remove(object)) {
                                    SearchGroup.this.firePropertyChange(SearchGroup.PROP_RESULT, object, null);
                                }
                                return;
                            }
                            ++n;
                        }
                        if (SearchGroup.this.resultObjects.add(object)) {
                            SearchGroup.this.firePropertyChange(SearchGroup.PROP_RESULT, null, object);
                        }
                    }
                }
            };
        }
        return this.propListener;
    }

    protected abstract void doSearch();

    protected void processSearchObject(Object object) {
        int n = 0;
        while (n < this.searchTypes.length) {
            if (!this.searchTypes[n].acceptSearchObject(object)) {
                return;
            }
            ++n;
        }
        this.searchObjects.add(object);
        int n2 = 0;
        while (n2 < this.searchTypes.length) {
            this.searchTypes[n2].prepareSearchObject(object);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.searchTypes.length) {
            if (!this.searchTypes[n3].testObject(object)) {
                return;
            }
            ++n3;
        }
        this.resultObjects.add(object);
        this.firePropertyChange(PROP_FOUND, null, object);
    }

    public abstract Node getNodeForFoundObject(Object var1);

    public Set getResultObjects() {
        return new HashSet(this.resultObjects);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertySupport().addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertySupport().removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertySupport().firePropertyChange(string, object, object2);
    }

    private synchronized PropertyChangeSupport getPropertySupport() {
        if (this.propChangeSupport == null) {
            this.propChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propChangeSupport;
    }

    public static SearchGroup[] createSearchGroups(SearchType[] searchTypeArray) {
        Collection<Class<Object>> collection;
        HashSet<Class<Object>> hashSet = new HashSet<Class<Object>>(searchTypeArray.length);
        int n = 0;
        while (n < searchTypeArray.length) {
            collection = Arrays.asList(searchTypeArray[n].getSearchTypeClasses());
            if (n == 0) {
                hashSet.addAll(collection);
            } else {
                hashSet.retainAll(collection);
            }
            ++n;
        }
        if (hashSet.isEmpty()) {
            return new SearchGroup[0];
        }
        collection = new HashSet(hashSet.size());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            SearchGroup searchGroup = Registry.createSearchGroup((Class)iterator.next());
            if (searchGroup == null) continue;
            int n2 = 0;
            while (n2 < searchTypeArray.length) {
                searchGroup.add(searchTypeArray[n2]);
                ++n2;
            }
            collection.add((Class<Object>)((Object)searchGroup));
        }
        return collection.toArray((SearchGroup[])new SearchGroup[collection.size()]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Registry {
        private static final Map registry = new HashMap(2);

        private Registry() {
        }

        public static synchronized boolean registerSearchGroupFactory(Class clazz, Factory factory) {
            if (registry.containsKey(clazz)) {
                return false;
            }
            registry.put(clazz, factory);
            return true;
        }

        public static SearchGroup createSearchGroup(Class clazz) {
            Factory factory = (Factory)registry.get(clazz);
            if (factory == null) {
                return null;
            }
            return factory.createSearchGroup();
        }

        public static boolean hasFactory(Class clazz) {
            return registry.containsKey(clazz);
        }

        static {
            registry.put(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SearchGroup.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, new Factory(){

                public SearchGroup createSearchGroup() {
                    return new DataObjectSearchGroup();
                }
            });
            registry.put(class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = SearchGroup.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject, new Factory(){

                public SearchGroup createSearchGroup() {
                    return new FileObjectSearchGroup();
                }
            });
        }
    }

    public static interface Factory {
        public SearchGroup createSearchGroup();
    }
}

