/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class DataObjectSearchGroup
extends SearchGroup {
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$filesystems$Repository;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;

    protected void add(SearchType searchType) {
        if (!Arrays.asList(searchType.getSearchTypeClasses()).contains(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObjectSearchGroup.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) {
            return;
        }
        ArrayList<SearchType> arrayList = new ArrayList<SearchType>(Arrays.asList(this.searchTypes));
        if (!arrayList.contains(searchType)) {
            arrayList.add(searchType);
        }
        this.searchTypes = arrayList.toArray(new SearchType[arrayList.size()]);
    }

    public void doSearch() {
        DataObject.Container[] containerArray = this.getContainers();
        if (containerArray == null) {
            return;
        }
        int n = 0;
        while (n < containerArray.length) {
            if (!this.scanContainer(containerArray[n])) {
                return;
            }
            ++n;
        }
    }

    private DataObject.Container[] getContainers() {
        Node[] nodeArray = DataObjectSearchGroup.normalizeNodes(this.searchRoots.toArray(new Node[this.searchRoots.size()]));
        ArrayList<Object> arrayList = new ArrayList<Object>(nodeArray.length);
        if (nodeArray.length == 1) {
            InstanceCookie instanceCookie = (InstanceCookie)nodeArray[0].getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = DataObjectSearchGroup.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            try {
                if (instanceCookie != null && (class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = DataObjectSearchGroup.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository).isAssignableFrom(instanceCookie.instanceClass())) {
                    Repository repository = TopManager.getDefault().getRepository();
                    Enumeration enumeration = repository.getFileSystems();
                    while (enumeration.hasMoreElements()) {
                        FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                        if (!fileSystem.isValid() || fileSystem.isHidden()) continue;
                        arrayList.add(DataObject.find((FileObject)fileSystem.getRoot()));
                    }
                    return arrayList.toArray(new DataObject.Container[arrayList.size()]);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        int n = 0;
        while (n < nodeArray.length) {
            DataObject.Container container = (DataObject.Container)nodeArray[n].getCookie(class$org$openide$loaders$DataObject$Container == null ? DataObjectSearchGroup.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container);
            if (container != null) {
                arrayList.add(container);
            }
            ++n;
        }
        return arrayList.toArray(new DataObject.Container[arrayList.size()]);
    }

    private boolean scanContainer(DataObject.Container container) {
        DataObject[] dataObjectArray = container.getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            if (this.stopped) {
                this.stopped = true;
                return false;
            }
            DataObject.Container container2 = (DataObject.Container)dataObjectArray[n].getCookie(class$org$openide$loaders$DataObject$Container == null ? DataObjectSearchGroup.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container);
            if (container2 != null) {
                if (!this.scanContainer(container2)) {
                    return false;
                }
            } else {
                this.processSearchObject(dataObjectArray[n]);
            }
            ++n;
        }
        return true;
    }

    public Node getNodeForFoundObject(Object object) {
        if (!(object instanceof DataObject)) {
            return null;
        }
        return ((DataObject)object).getNodeDelegate();
    }

    private static Node[] normalizeNodes(Node[] nodeArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (n < nodeArray.length) {
            if (!DataObjectSearchGroup.hasParent(nodeArray[n], nodeArray)) {
                arrayList.add(nodeArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private static boolean hasParent(Node node, Node[] nodeArray) {
        Node node2 = node.getParentNode();
        while (node2 != null) {
            int n = 0;
            while (n < nodeArray.length) {
                if (nodeArray[n].equals(node2)) {
                    return true;
                }
                ++n;
            }
            node2 = node2.getParentNode();
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

