/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.nodes.looks;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openidex.nodes.looks.Look;
import org.openidex.nodes.looks.LookNode;

class LookProperties {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$openidex$nodes$looks$LookProperties == null ? (class$org$openidex$nodes$looks$LookProperties = LookProperties.class$("org.openidex.nodes.looks.LookProperties")) : class$org$openidex$nodes$looks$LookProperties));
    public static final String LOOK_SHEET_SET_NAME = "Look";
    private static final String DEFAULT = bundle.getString("CTL_Default");
    static /* synthetic */ Class class$org$openidex$nodes$looks$LookProperties;
    static /* synthetic */ Class class$org$openidex$nodes$looks$LookProperties$SetLookAction;
    static /* synthetic */ Class class$org$openidex$nodes$looks$Look;

    LookProperties() {
    }

    public static SystemAction getSetLookAction(LookNode lookNode) {
        SetLookAction setLookAction = (SetLookAction)SystemAction.get((Class)(class$org$openidex$nodes$looks$LookProperties$SetLookAction == null ? (class$org$openidex$nodes$looks$LookProperties$SetLookAction = LookProperties.class$("org.openidex.nodes.looks.LookProperties$SetLookAction")) : class$org$openidex$nodes$looks$LookProperties$SetLookAction));
        setLookAction.setLookNode(lookNode);
        return setLookAction;
    }

    public static Sheet.Set getLookPropertySet(LookNode lookNode) {
        Sheet.Set set = new Sheet.Set();
        set.setName(LOOK_SHEET_SET_NAME);
        set.setDisplayName(bundle.getString("CTL_LookSheetSetName"));
        set.put((Node.Property)new LookProperty(lookNode));
        return set;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class LookItemListener
    implements ActionListener {
        private LookNode lookNode;
        private Look look;

        LookItemListener(LookNode lookNode, Look look) {
            this.lookNode = lookNode;
            this.look = look;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.lookNode.setLook(this.look);
        }
    }

    private static final class MainItemListener
    implements MenuListener {
        private JMenu menu;
        private LookNode lookNode;

        public MainItemListener(LookNode lookNode) {
            this.lookNode = lookNode;
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
        }

        public void menuSelected(MenuEvent menuEvent) {
            this.menu = (JMenu)menuEvent.getSource();
            if (this.lookNode.hasLookNodeParent()) {
                this.menu.add(this.createMenuItem(this.lookNode, null));
            }
            if (this.lookNode != null) {
                Look[] lookArray = LookEditor.getAllLooks(this.lookNode);
                int n = 0;
                while (n < lookArray.length) {
                    this.menu.add(this.createMenuItem(this.lookNode, lookArray[n]));
                    ++n;
                }
            }
        }

        private JMenuItem createMenuItem(LookNode lookNode, Look look) {
            JMenuItem jMenuItem = new JMenuItem();
            if (look == null) {
                Actions.setMenuText((AbstractButton)jMenuItem, (String)DEFAULT, (boolean)true);
                jMenuItem.addActionListener(new LookItemListener(lookNode, null));
            } else {
                Actions.setMenuText((AbstractButton)jMenuItem, (String)look.getName(), (boolean)true);
                jMenuItem.addActionListener(new LookItemListener(lookNode, look));
            }
            return jMenuItem;
        }
    }

    public static class SetLookAction
    extends NodeAction {
        private LookNode lookNode = null;

        public String getName() {
            return bundle.getString("ACT_SetLook");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void setLookNode(LookNode lookNode) {
            this.lookNode = lookNode;
        }

        public JMenuItem getPopupPresenter() {
            JMenuPlus jMenuPlus = new JMenuPlus();
            Actions.setMenuText((AbstractButton)jMenuPlus, (String)this.getName(), (boolean)true);
            HelpCtx.setHelpIDString((JComponent)jMenuPlus, (String)(class$org$openidex$nodes$looks$LookProperties$SetLookAction == null ? (class$org$openidex$nodes$looks$LookProperties$SetLookAction = LookProperties.class$("org.openidex.nodes.looks.LookProperties$SetLookAction")) : class$org$openidex$nodes$looks$LookProperties$SetLookAction).getName());
            jMenuPlus.addMenuListener(new MainItemListener(this.lookNode));
            return jMenuPlus;
        }

        protected boolean enable(Node[] nodeArray) {
            return nodeArray.length == 1;
        }

        protected void performAction(Node[] nodeArray) {
        }
    }

    static class LookEditor
    extends PropertyEditorSupport {
        LookNode lookNode = null;
        private Look look = null;

        public LookEditor(LookNode lookNode) {
            this.lookNode = lookNode;
        }

        public String getAsText() {
            if (this.getValue() == null) {
                return DEFAULT;
            }
            return ((Look)this.getValue()).getName();
        }

        public void setAsText(String string) throws IllegalArgumentException {
            if (string.equals(DEFAULT)) {
                this.setValue(null);
            }
            Look[] lookArray = LookEditor.getAllLooks(this.lookNode);
            int n = 0;
            while (n < lookArray.length) {
                if (lookArray[n].getName().equals(string)) {
                    this.setValue(lookArray[n]);
                    return;
                }
                ++n;
            }
            throw new IllegalArgumentException("No such look - " + string);
        }

        public String getJavaInitializationString() {
            return this.getValue() == null ? "" : this.look.getName();
        }

        public String[] getTags() {
            String[] stringArray;
            Look[] lookArray = LookEditor.getAllLooks(this.lookNode);
            int n = 0;
            if (this.lookNode.hasLookNodeParent()) {
                stringArray = new String[lookArray.length + 1];
                stringArray[0] = DEFAULT;
                n = 1;
            } else {
                stringArray = new String[lookArray.length];
            }
            int n2 = 0;
            while (n2 < lookArray.length) {
                stringArray[n2 + n] = lookArray[n2].getName();
                ++n2;
            }
            return stringArray;
        }

        static Look[] getAllLooks(LookNode lookNode) {
            Lookup.Template template = new Lookup.Template(class$org$openidex$nodes$looks$Look == null ? (class$org$openidex$nodes$looks$Look = LookProperties.class$("org.openidex.nodes.looks.Look")) : class$org$openidex$nodes$looks$Look);
            Lookup.Result result = Lookup.getDefault().lookup(template);
            Collection collection = result.allInstances();
            ArrayList<Look> arrayList = new ArrayList<Look>(collection.size());
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Look look = (Look)iterator.next();
                if (look.isLookStandalone(lookNode.getRepresentedObject())) {
                    arrayList.add(look);
                }
                ++n;
            }
            return arrayList.toArray(new Look[0]);
        }
    }

    static class LookProperty
    extends PropertySupport.ReadWrite {
        private final LookNode lookNode;

        LookProperty(LookNode lookNode) {
            super(bundle.getString("CTL_LookProperty"), class$org$openidex$nodes$looks$Look == null ? (class$org$openidex$nodes$looks$Look = LookProperties.class$("org.openidex.nodes.looks.Look")) : class$org$openidex$nodes$looks$Look, bundle.getString("CTL_LookProperty"), bundle.getString("CTL_LookPropertyShortDescription"));
            this.lookNode = lookNode;
        }

        public Object getValue() {
            return this.lookNode.getHardLook();
        }

        public void setValue(Object object) {
            this.lookNode.setLook((Look)object);
        }

        public PropertyEditor getPropertyEditor() {
            return new LookEditor(this.lookNode);
        }
    }
}

