/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jndi;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.netbeans.modules.jndi.JndiChildren;
import org.netbeans.modules.jndi.JndiDataType;
import org.netbeans.modules.jndi.JndiIcons;
import org.netbeans.modules.jndi.JndiKey;
import org.netbeans.modules.jndi.JndiObjectCreator;
import org.netbeans.modules.jndi.JndiObjectNode;
import org.netbeans.modules.jndi.JndiProperty;
import org.netbeans.modules.jndi.JndiRootNode;
import org.netbeans.modules.jndi.JndiRootNodeChildren;
import org.netbeans.modules.jndi.gui.AttributePanel;
import org.netbeans.modules.jndi.utils.DisconnectCtxCookie;
import org.netbeans.modules.jndi.utils.Refreshable;
import org.openide.TopManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.NewType;

public final class JndiNode
extends JndiObjectNode
implements Refreshable,
DisconnectCtxCookie,
Node.Cookie {
    private NewType[] jndinewtypes;
    private boolean needRefresh;
    private transient Dialog dlg;
    private int index;
    static /* synthetic */ Class class$org$netbeans$modules$jndi$LookupCopyAction;
    static /* synthetic */ Class class$org$netbeans$modules$jndi$BindingCopyAction;
    static /* synthetic */ Class class$org$netbeans$modules$jndi$RefreshAction;
    static /* synthetic */ Class class$org$netbeans$modules$jndi$DisconnectAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$java$lang$String;

    public JndiNode(Context context, int n) throws NamingException {
        super((String)context.getEnvironment().get("NB_LABEL"), (Children)new JndiChildren(context, new CompositeName()));
        this.index = n;
        this.init();
    }

    public JndiNode(JndiKey jndiKey, CompositeName compositeName) throws InvalidNameException {
        super(jndiKey, (Children)new JndiChildren((Context)jndiKey.name.getObject(), (CompositeName)((CompositeName)compositeName.clone()).add(jndiKey.name.getName())));
        this.index = -1;
        this.init();
    }

    public boolean isRoot() {
        return this.index != -1;
    }

    public String createTemplate() throws NamingException {
        return JndiObjectCreator.getLookupCode(((JndiChildren)this.getChildren()).getContext(), this.getOffsetAsString(), this.getClassName());
    }

    public NewType[] getNewTypes() {
        if (this.jndinewtypes == null) {
            this.jndinewtypes = new NewType[]{new JndiDataType(this)};
        }
        return this.jndinewtypes;
    }

    public void destroy() throws IOException {
        try {
            Context context = ((JndiNode)this.getParentNode()).getContext();
            context.destroySubcontext(this.getKey().name.getName());
            super.destroy();
        }
        catch (NamingException namingException) {
            JndiRootNode.notifyForeignException(namingException);
        }
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$jndi$LookupCopyAction == null ? (class$org$netbeans$modules$jndi$LookupCopyAction = JndiNode.class$("org.netbeans.modules.jndi.LookupCopyAction")) : class$org$netbeans$modules$jndi$LookupCopyAction)), SystemAction.get((Class)(class$org$netbeans$modules$jndi$BindingCopyAction == null ? (class$org$netbeans$modules$jndi$BindingCopyAction = JndiNode.class$("org.netbeans.modules.jndi.BindingCopyAction")) : class$org$netbeans$modules$jndi$BindingCopyAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$jndi$RefreshAction == null ? (class$org$netbeans$modules$jndi$RefreshAction = JndiNode.class$("org.netbeans.modules.jndi.RefreshAction")) : class$org$netbeans$modules$jndi$RefreshAction)), this.isRoot() ? SystemAction.get((Class)(class$org$netbeans$modules$jndi$DisconnectAction == null ? (class$org$netbeans$modules$jndi$DisconnectAction = JndiNode.class$("org.netbeans.modules.jndi.DisconnectAction")) : class$org$netbeans$modules$jndi$DisconnectAction)) : SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = JndiNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = JndiNode.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = JndiNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JndiNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public final void refresh() {
        ((JndiChildren)this.getChildren()).prepareKeys();
    }

    public final void bindingCopy() {
        try {
            ExClipboard exClipboard = TopManager.getDefault().getClipboard();
            StringSelection stringSelection = new StringSelection(JndiObjectCreator.generateBindingCode(((JndiChildren)this.getChildren()).getContext(), this.getOffsetAsString(), this.getClassName()));
            exClipboard.setContents(stringSelection, stringSelection);
            JndiRootNode.showLocalizedStatus("STS_CopyBindingCode");
        }
        catch (NamingException namingException) {
            JndiRootNode.notifyForeignException(namingException);
            return;
        }
    }

    public Context getContext() {
        return ((JndiChildren)this.getChildren()).getContext();
    }

    public Hashtable getInitialDirContextProperties() throws NamingException {
        return ((JndiChildren)this.getChildren()).getContext().getEnvironment();
    }

    public CompositeName getOffset() {
        return ((JndiChildren)this.getChildren()).getOffset();
    }

    public String getOffsetAsString() {
        return ((JndiChildren)this.getChildren()).getOffsetAsString();
    }

    public String getClassName() {
        return "javax.naming.Context";
    }

    public void updateData() {
        this.createSheet();
    }

    public boolean needRefresh() {
        return this.needRefresh;
    }

    public void clearRefresh() {
        this.needRefresh = false;
    }

    public void setRefresh() {
        this.needRefresh = true;
    }

    public void disconnect() {
        try {
            ((JndiRootNodeChildren)this.getParentNode().getChildren()).remove(this.index);
            super.destroy();
        }
        catch (IOException iOException) {
            JndiRootNode.notifyForeignException(iOException);
        }
    }

    public boolean hasCustomizer() {
        return this.getContext() instanceof DirContext;
    }

    public Component getCustomizer() {
        return new AttributePanel((DirContext)this.getContext(), new CompositeName(), this);
    }

    public Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (this.getContext() instanceof DirContext) {
            try {
                Attributes attributes = ((DirContext)this.getContext()).getAttributes("");
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    Attribute attribute = (Attribute)namingEnumeration.nextElement();
                    String string = attribute.getID();
                    sheet.get("Jndi").put((Node.Property)new JndiProperty(string, class$java$lang$String == null ? JndiNode.class$("java.lang.String") : class$java$lang$String, string, null, attribute.get().toString(), this, true));
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return sheet;
    }

    protected void handleChangeJndiPropertyValue(Attributes attributes) throws NamingException {
        ((DirContext)this.getContext()).modifyAttributes("", 2, attributes);
    }

    private void init() {
        this.needRefresh = false;
        this.setIconBase("/org/netbeans/modules/jndi/resources/" + JndiIcons.getIconName("javax.naming.Context"));
        this.getCookieSet().add((Node.Cookie)this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

