/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.LReference;
import org.netbeans.modules.debugger.jpda.evaluator.PValue;
import org.netbeans.modules.debugger.jpda.evaluator.VMEngine;

abstract class RemoteValue {
    protected LReference ref = null;

    RemoteValue() {
    }

    public void setReference(LReference lReference) {
        this.ref = lReference;
    }

    public LReference getReference() {
        return this.ref;
    }

    public boolean isLValue() {
        return this.ref != null;
    }

    public void setValue(RemoteValue remoteValue) throws EvaluateException {
        if (this.ref == null) {
            PValue.error("CTL_Value_cannot_be_set");
            return;
        }
        this.ref.setValue(remoteValue);
    }

    public abstract java.lang.String typeName();

    public java.lang.String toString(VMEngine vMEngine) {
        return this.toString();
    }

    static class Void
    extends RemoteValue {
        Void() {
        }

        public java.lang.String typeName() {
            return "void";
        }

        public java.lang.String toString() {
            return "void";
        }
    }

    static class Null
    extends RemoteValue {
        Null() {
        }

        public java.lang.String typeName() {
            return "null";
        }

        public java.lang.String toString() {
            return "null";
        }
    }

    static class Boolean
    extends Primitive {
        private boolean value;

        Boolean(boolean bl) {
            this.value = bl;
        }

        public boolean booleanValue() {
            return this.value;
        }

        public java.lang.String typeName() {
            return "boolean";
        }

        public java.lang.String toString() {
            return new java.lang.Boolean(this.value).toString();
        }
    }

    static class Double
    extends Numeric {
        private double value;

        Double(double d) {
            this.value = d;
        }

        public short shortValue() {
            return (short)this.value;
        }

        public byte byteValue() {
            return (byte)this.value;
        }

        public char charValue() {
            return (char)this.value;
        }

        public int intValue() {
            return (int)this.value;
        }

        public double doubleValue() {
            return this.value;
        }

        public java.lang.String typeName() {
            return "double";
        }

        public java.lang.String toString() {
            return new java.lang.Double(this.value).toString();
        }
    }

    static class Float
    extends Numeric {
        private float value;

        Float(float f) {
            this.value = f;
        }

        public short shortValue() {
            return (short)this.value;
        }

        public byte byteValue() {
            return (byte)this.value;
        }

        public char charValue() {
            return (char)this.value;
        }

        public int intValue() {
            return (int)this.value;
        }

        public float floatValue() {
            return this.value;
        }

        public double doubleValue() {
            return this.value;
        }

        public java.lang.String typeName() {
            return "float";
        }

        public java.lang.String toString() {
            return new java.lang.Float(this.value).toString();
        }
    }

    static class Long
    extends Numeric {
        private long value;

        Long(long l) {
            this.value = l;
        }

        public short shortValue() {
            return (short)this.value;
        }

        public byte byteValue() {
            return (byte)this.value;
        }

        public char charValue() {
            return (char)this.value;
        }

        public int intValue() {
            return (int)this.value;
        }

        public long longValue() {
            return this.value;
        }

        public float floatValue() {
            return this.value;
        }

        public double doubleValue() {
            return this.value;
        }

        public java.lang.String typeName() {
            return "long";
        }

        public java.lang.String toString() {
            return new java.lang.Long(this.value).toString();
        }
    }

    static class Integer
    extends Numeric {
        private int value;

        Integer(int n) {
            this.value = n;
        }

        public short shortValue() {
            return (short)this.value;
        }

        public byte byteValue() {
            return (byte)this.value;
        }

        public char charValue() {
            return (char)this.value;
        }

        public int intValue() {
            return this.value;
        }

        public java.lang.String typeName() {
            return "int";
        }

        public java.lang.String toString() {
            return new java.lang.Integer(this.value).toString();
        }
    }

    static class Character
    extends Numeric {
        private char value;

        Character(char c) {
            this.value = c;
        }

        public char charValue() {
            return this.value;
        }

        public short shortValue() {
            return (short)this.value;
        }

        public byte byteValue() {
            return (byte)this.value;
        }

        public int intValue() {
            return this.value;
        }

        public java.lang.String typeName() {
            return "char";
        }

        public java.lang.String toString() {
            return new java.lang.Character(this.value).toString();
        }
    }

    static class Short
    extends Numeric {
        private short value;

        Short(short s) {
            this.value = s;
        }

        public short shortValue() {
            return this.value;
        }

        public byte byteValue() {
            return (byte)this.value;
        }

        public char charValue() {
            return (char)this.value;
        }

        public int intValue() {
            return this.value;
        }

        public java.lang.String typeName() {
            return "short";
        }

        public java.lang.String toString() {
            return new java.lang.Short(this.value).toString();
        }
    }

    static class Byte
    extends Numeric {
        private byte value;

        Byte(byte by) {
            this.value = by;
        }

        public short shortValue() {
            return this.value;
        }

        public byte byteValue() {
            return this.value;
        }

        public char charValue() {
            return (char)this.value;
        }

        public int intValue() {
            return this.value;
        }

        public java.lang.String typeName() {
            return "byte";
        }

        public java.lang.String toString() {
            return new java.lang.Byte(this.value).toString();
        }
    }

    static abstract class Numeric
    extends Primitive {
        Numeric() {
        }

        public abstract short shortValue();

        public abstract byte byteValue();

        public abstract char charValue();

        public abstract int intValue();

        public long longValue() {
            return this.intValue();
        }

        public float floatValue() {
            return this.intValue();
        }

        public double doubleValue() {
            return this.intValue();
        }
    }

    static abstract class Primitive
    extends RemoteValue {
        Primitive() {
        }
    }

    static class String
    extends Object {
        String(StringReference stringReference) {
            super(stringReference);
        }
    }

    static class Array
    extends Object {
        Array(ArrayReference arrayReference) {
            super(arrayReference);
        }
    }

    static class Object
    extends RemoteValue {
        private ObjectReference objectRef;
        private java.lang.String typeName;

        Object(ObjectReference objectReference) {
            this.objectRef = objectReference;
            try {
                this.typeName = objectReference.referenceType().name();
            }
            catch (Exception exception) {
                this.typeName = "";
            }
        }

        public ObjectReference reference() {
            return this.objectRef;
        }

        public java.lang.String typeName() {
            return this.typeName;
        }

        public java.lang.String toString() {
            return this.objectRef.toString();
        }

        public java.lang.String toString(VMEngine vMEngine) {
            try {
                return vMEngine.toStringValue(this);
            }
            catch (EvaluateException evaluateException) {
                return "???";
            }
        }
    }
}

