/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.InstanceField;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.StaticField;
import org.netbeans.modules.debugger.jpda.VariableBreakpointPanel;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Requestor;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.ClassBreakpointEvent;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.Debugger;
import org.openide.explorer.propertysheet.editors.ChoicePropertyEditor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.text.Line;

public class VariableBreakpoint
extends ClassBreakpointEvent
implements Executor,
StopEvent,
InfoProducer {
    static final long serialVersionUID = -2579587576443670523L;
    public static final String PROP_FIELD_NAME = "fieldName";
    public static final String PROP_FIELD = "field";
    public static final String PROP_TYPE = "type";
    public static final String PROP_CONDITION = "condition";
    public static final int ACCESS_TYPE = 0;
    public static final int MODIFICATION_TYPE = 1;
    public static final String TYPE_NAME = "java-field";
    private transient ThreadReference thread;
    private Requestor requestor;
    private transient Field field;
    private String fieldName = "";
    private int type = 1;
    private transient JPDAVariable value;
    private transient String action;
    private String condition = "";
    private HashSet refTypesWithBreakpoint;
    private transient CoreBreakpoint.Action[] actions;
    static /* synthetic */ Class class$java$lang$String;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.condition == null) {
            this.condition = "";
        }
    }

    public boolean set() {
        Debugger debugger = this.getDebugger();
        if (!(debugger instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debugger;
        if (jPDADebugger.virtualMachine == null || jPDADebugger.isDisconnected()) {
            return false;
        }
        if (this.getClassName() == null || this.getClassName().trim().length() < 1) {
            return false;
        }
        if (this.type == 0 && !jPDADebugger.virtualMachine.canWatchFieldAccess()) {
            return false;
        }
        if (this.type == 1 && !jPDADebugger.virtualMachine.canWatchFieldModification()) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = new Requestor(jPDADebugger.requestManager, jPDADebugger.operator, this);
        }
        try {
            ReferenceType referenceType;
            this.requestor.removeRequests();
            if (this.refTypesWithBreakpoint != null) {
                this.refTypesWithBreakpoint.clear();
            }
            ClassPrepareRequest classPrepareRequest = jPDADebugger.requestManager.createClassPrepareRequest();
            classPrepareRequest.addClassFilter(this.getClassName() + '*');
            classPrepareRequest.setSuspendPolicy(2);
            this.requestor.add(classPrepareRequest);
            classPrepareRequest.enable();
            List<ReferenceType> list = jPDADebugger.virtualMachine.classesByName(this.getClassName());
            if (list.size() == 0) {
                return false;
            }
            boolean bl = false;
            ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                referenceType = list.get(n);
                if (this.set(referenceType)) {
                    bl = true;
                }
                try {
                    arrayList.addAll(Utils.anonymousInnerClasses((String)referenceType.name(), referenceType.nestedTypes()));
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
                ++n;
            }
            n = 0;
            while (n < arrayList.size()) {
                referenceType = (ReferenceType)arrayList.get(n);
                if (this.set(referenceType)) {
                    bl = true;
                }
                try {
                    arrayList.addAll(referenceType.nestedTypes());
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
                ++n;
            }
            return bl;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = VariableBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)"className", (String)JPDADebugger.getLocString("PROP_breakpoint_class_name"), (String)JPDADebugger.getLocString("HINT_breakpoint_class_name"), (String)"getClassName", (String)"setClassName"), Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = VariableBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_FIELD_NAME, (String)JPDADebugger.getLocString("PROP_breakpoint_field_name"), (String)JPDADebugger.getLocString("HINT_breakpoint_field_name"), (String)"getFieldName", (String)"setFieldName"), new PropertySupport.ReadWrite(PROP_TYPE, Integer.TYPE, JPDADebugger.getLocString("PROP_breakpoint_type_name"), JPDADebugger.getLocString("HINT_breakpoint_type_name")){

            public Object getValue() throws IllegalArgumentException {
                return new Integer(VariableBreakpoint.this.getType());
            }

            public void setValue(Object object) throws IllegalArgumentException {
                if (!(object instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                VariableBreakpoint.this.setType((Integer)object);
            }

            public PropertyEditor getPropertyEditor() {
                return new ChoicePropertyEditor(new int[]{0, 1}, new String[]{JPDADebugger.getLocString("CTL_Breakpoint_type_access_value"), JPDADebugger.getLocString("CTL_Breakpoint_type_modification_value")});
            }
        }, Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = VariableBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_CONDITION, (String)JPDADebugger.getLocString("PROP_condition"), (String)JPDADebugger.getLocString("HINT_condition"), (String)"getCondition", (String)"setCondition")};
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] actionArray = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new VariablePrintAction()};
            if (actionArray.length != 0) {
                CoreBreakpoint.Action[] actionArray2 = this.actions;
                this.actions = new CoreBreakpoint.Action[actionArray.length + actionArray2.length];
                System.arraycopy(actionArray, 0, this.actions, 0, actionArray.length);
                System.arraycopy(actionArray2, 0, this.actions, actionArray.length, actionArray2.length);
            }
        }
        return this.actions;
    }

    public Line[] getLines() {
        return null;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JPDADebugger.getLocString("CTL_Variable_event_type_name");
    }

    public String getCategoryDisplayName() {
        return JPDADebugger.getLocString("CTL_Java_breakpoint_events_cathegory_name");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType().equals(TYPE_NAME);
    }

    public String getDisplayName() {
        if (this.type == 1) {
            return new MessageFormat(JPDADebugger.getLocString("CTL_Variable_modification_event_name")).format(new Object[]{this.getClassName(), this.getFieldName()});
        }
        return new MessageFormat(JPDADebugger.getLocString("CTL_Variable_access_event_name")).format(new Object[]{this.getClassName(), this.getFieldName()});
    }

    public String getIconBase() {
        return "/org/netbeans/modules/debugger/resources/breakpointOnVariable";
    }

    public JComponent getCustomizer() {
        this.setClassName(JUtils.getCurrentClassName());
        this.setFieldName(JUtils.getCurrentFieldName());
        return new VariableBreakpointPanel(this);
    }

    public JavaThread getThread() {
        JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
        return jPDADebugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((JPDAThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        return this.value;
    }

    public void exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            boolean bl;
            boolean bl2;
            ReferenceType referenceType = ((ClassPrepareEvent)event).referenceType();
            String string = referenceType.name();
            if (string.equals(this.getClassName())) {
                bl2 = true;
            } else {
                String string2 = this.getClassName() + '$';
                boolean bl3 = bl2 = string.startsWith(string2) && !Character.isJavaIdentifierStart(string.charAt(string2.length()));
            }
            if (bl2 && (bl = this.set(referenceType)) && !this.getBreakpoint().isValid()) {
                this.setValid(true);
            }
            ((JPDADebugger)this.getDebugger()).operator.resume();
            return;
        }
        this.thread = ((WatchpointEvent)event).thread();
        ObjectReference objectReference = ((WatchpointEvent)event).object();
        Field field = ((WatchpointEvent)event).field();
        this.value = objectReference != null ? new InstanceField((JPDADebugger)this.getDebugger(), objectReference, field) : new StaticField((JPDADebugger)this.getDebugger(), field.declaringType(), field);
        this.action = event instanceof AccessWatchpointEvent ? JPDADebugger.getLocString("CTL_Access") : JPDADebugger.getLocString("CTL_Modification");
        this.perform();
    }

    public void stop(boolean bl) {
        ((JPDADebugger)this.getDebugger()).stop(bl, (AbstractThread)this.getThread());
    }

    public void setClassName(String string, boolean bl) {
        if (string == this.className || string != null && this.className != null && this.className.equals(string)) {
            return;
        }
        String string2 = this.className;
        this.className = string;
        this.field = null;
        if (bl) {
            this.updater.setClassName(this.className);
        }
        this.firePropertyChange("className", string2, this.className);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string == this.fieldName || string != null && this.fieldName != null && this.fieldName.equals(string)) {
            return;
        }
        String string2 = this.fieldName;
        this.fieldName = string;
        this.field = null;
        this.firePropertyChange(PROP_FIELD_NAME, string2, this.fieldName);
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        if (this.field == field) {
            return;
        }
        Field field2 = field;
        this.field = field;
        this.firePropertyChange(PROP_FIELD, field2, field);
        if (field == null) {
            return;
        }
        try {
            this.setClassName(field.declaringType().name());
            this.setFieldName(field.type().name());
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (ClassNotLoadedException classNotLoadedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (this.type == n) {
            return;
        }
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.type;
        this.type = n;
        this.firePropertyChange(PROP_TYPE, new Integer(n2), new Integer(n));
    }

    public void setCondition(String string) {
        if (string != null) {
            string = string.trim();
        }
        String string2 = this.condition;
        this.condition = string;
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String getCondition() {
        return this.condition;
    }

    protected void perform() {
        if (!this.condition.trim().equals("")) {
            JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
            JPDAWatch jPDAWatch = new JPDAWatch(jPDADebugger, true);
            jPDAWatch.setVariableName(this.condition);
            jPDAWatch.refreshValue((JPDAThread)this.getThread());
            String string = jPDAWatch.getType();
            String string2 = jPDAWatch.getAsText();
            if (string != null && string.equals("boolean") && string2 != null && string2.equals("false")) {
                this.stop(false);
                return;
            }
            if (string == null || !string.equals("boolean")) {
                jPDADebugger.getIOManager().println(JPDADebugger.getLocString("CTL_Incorrect_condition") + ": " + JPDADebugger.getLocString("CTL_breakpoint_at") + " " + this.getDisplayName() + ".", 1);
            }
        }
        super.perform();
    }

    public boolean set(ReferenceType referenceType) {
        JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
        if (jPDADebugger.virtualMachine == null || jPDADebugger.isDisconnected()) {
            return false;
        }
        VariableBreakpoint variableBreakpoint = this;
        synchronized (variableBreakpoint) {
            if (this.refTypesWithBreakpoint == null) {
                this.refTypesWithBreakpoint = new HashSet(17);
            } else {
                try {
                    if (this.refTypesWithBreakpoint.contains(referenceType)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
            }
            this.refTypesWithBreakpoint.add(referenceType);
        }
        try {
            Field field = null;
            boolean bl = false;
            try {
                field = referenceType.fieldByName(this.getFieldName());
            }
            catch (ClassNotPreparedException classNotPreparedException) {
            }
            catch (ObjectCollectedException objectCollectedException) {
                // empty catch block
            }
            if (field == null) {
                return false;
            }
            if (this.type == 0) {
                AccessWatchpointRequest accessWatchpointRequest = jPDADebugger.requestManager.createAccessWatchpointRequest(field);
                accessWatchpointRequest.setSuspendPolicy(2);
                accessWatchpointRequest.addClassFilter("*");
                this.requestor.add(accessWatchpointRequest);
                accessWatchpointRequest.enable();
                bl = true;
            } else {
                ModificationWatchpointRequest modificationWatchpointRequest = jPDADebugger.requestManager.createModificationWatchpointRequest(field);
                modificationWatchpointRequest.setSuspendPolicy(2);
                modificationWatchpointRequest.addClassFilter("*");
                this.requestor.add(modificationWatchpointRequest);
                modificationWatchpointRequest.enable();
                bl = true;
            }
            return bl;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
    }

    public String toString() {
        return "JPDAVariableBreakpoint " + this.getClassName() + "." + this.getFieldName() + "." + this.getType();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class VariablePrintAction
    extends PrintAction {
        static final long serialVersionUID = -3852634593799541249L;

        VariablePrintAction() {
            super(JPDADebugger.getLocString("CTL_Variable_print_name"));
        }

        protected void resolveTag(String string, CoreBreakpoint.Event event, StringBuffer stringBuffer) {
            if (string.equals("variableName")) {
                stringBuffer.append(((VariableBreakpoint)event).getFieldName());
            } else if (string.equals("action")) {
                stringBuffer.append(((VariableBreakpoint)event).action);
            } else {
                super.resolveTag(string, event, stringBuffer);
            }
        }
    }
}

