/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.ProcessDebuggerInfo;
import org.netbeans.modules.debugger.support.ProcessDebuggerType;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Launcher {
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebugger = Launcher.class$("org.netbeans.modules.debugger.jpda.JPDADebugger")) : class$org$netbeans$modules$debugger$jpda$JPDADebugger));
    private ListeningConnector connector = null;
    private Map arguments = null;
    private String transport = null;
    private String address;
    private VirtualMachine virtualMachine;
    private Process process = null;
    private Exception thrownException = null;
    private boolean exited = false;
    private IOManager ioManager;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDADebugger;

    Launcher(IOManager iOManager) {
        this.ioManager = iOManager;
    }

    public synchronized VirtualMachine launch(DebuggerInfo debuggerInfo) throws DebuggerException {
        VirtualMachineManager virtualMachineManager;
        Object object;
        this.transport = System.getProperty("netbeans.debugger.jpda.transport");
        if (this.transport == null && Utilities.isWindows() && Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.3")) >= 0) {
            this.transport = "dt_socket";
        }
        if ((this.transport == null || (this.connector = Launcher.getListeningConnectorFor(this.transport)) == null) && (object = (virtualMachineManager = Bootstrap.virtualMachineManager()).defaultConnector()) != null) {
            this.transport = object.transport().name();
            this.connector = Launcher.getListeningConnectorFor(this.transport);
        }
        if (this.connector != null) {
            this.arguments = this.connector.defaultArguments();
        }
        if (this.connector == null) {
            this.finish();
            throw new DebuggerException(new MessageFormat(bundle.getString("EXC_Cannot_find_launcher")).format(new Object[]{"default"}));
        }
        object = null;
        if (debuggerInfo instanceof ProcessDebuggerInfo) {
            virtualMachineManager = ((ProcessDebuggerInfo)debuggerInfo).getDebuggerProcess();
            object = ((ProcessDebuggerInfo)debuggerInfo).getWorkingDirectory();
        } else {
            virtualMachineManager = ProcessDebuggerType.DEFAULT_DEBUGGER_PROCESS;
        }
        try {
            this.address = this.connector.startListening(this.arguments);
        }
        catch (Exception exception) {
            this.throwDebuggerException(virtualMachineManager.getProcessName(), exception);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(debuggerInfo.getClassName());
        String[] stringArray = debuggerInfo.getArguments();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(" \"").append(stringArray[n]).append('\"');
            ++n;
        }
        String string = new String(stringBuffer);
        HashMap hashMap = Utils.processDebuggerInfo((DebuggerInfo)debuggerInfo, (String)("-Xdebug -Xnoagent -Xrunjdwp:transport=" + this.transport + ",address=" + this.address + ",suspend=y"), (String)string);
        MapFormat mapFormat = new MapFormat((Map)hashMap);
        String string2 = mapFormat.format(virtualMachineManager.getProcessName() + " " + virtualMachineManager.getArguments());
        String string3 = mapFormat.format(virtualMachineManager.getProcessName());
        this.ioManager.println(string2, 1);
        try {
            this.process = virtualMachineManager.exec((Format)mapFormat, null, (File)object);
        }
        catch (IOException iOException) {
            this.throwDebuggerException(string3, iOException);
        }
        Thread thread = this.acceptConnection();
        Thread thread2 = this.monitorTarget();
        this.virtualMachine = null;
        this.exited = false;
        this.thrownException = null;
        try {
            block17: {
                try {
                    while (this.virtualMachine == null && this.thrownException == null && !this.exited) {
                        this.wait();
                    }
                    if (this.exited) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                        this.checkStream(bufferedReader, 1);
                        bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                        this.checkStream(bufferedReader, 2);
                        this.throwDebuggerException(string3, new IOException(bundle.getString("CTL_VM_init_failed")));
                    }
                    if (this.thrownException == null) break block17;
                    this.throwDebuggerException(string3, this.thrownException);
                }
                catch (InterruptedException interruptedException) {
                    this.throwDebuggerException(string3, interruptedException);
                    Object var16_19 = null;
                    thread.interrupt();
                    thread2.interrupt();
                }
            }
            Object var16_18 = null;
            thread.interrupt();
            thread2.interrupt();
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            thread.interrupt();
            thread2.interrupt();
            throw throwable;
        }
        return this.virtualMachine;
    }

    public void finish() {
        if (this.connector != null) {
            try {
                this.connector.stopListening(this.connector.defaultArguments());
            }
            catch (IOException iOException) {
            }
            catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                // empty catch block
            }
            this.connector = null;
        }
    }

    public Process process() {
        return this.process;
    }

    public String address() {
        return this.address;
    }

    public AttachingConnector attachingConnector() {
        return Launcher.getAttachingConnectorFor(this.transport);
    }

    synchronized void notifyOfExit() {
        this.exited = true;
        this.notify();
    }

    synchronized void notifyOfConnection(VirtualMachine virtualMachine) {
        this.virtualMachine = virtualMachine;
        this.notify();
    }

    synchronized void notifyOfThrownException(Exception exception) {
        this.thrownException = exception;
        this.notify();
    }

    private Thread monitorTarget() {
        Thread thread = new Thread("Launched target monitor"){

            public void run() {
                try {
                    Launcher.this.process.waitFor();
                    Launcher.this.notifyOfExit();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        return thread;
    }

    private Thread acceptConnection() {
        Thread thread = new Thread("Connection acceptor"){

            public void run() {
                try {
                    VirtualMachine virtualMachine = Launcher.this.connector.accept(Launcher.this.arguments);
                    Launcher.this.finish();
                    Launcher.this.notifyOfConnection(virtualMachine);
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (IOException iOException) {
                    Launcher.this.notifyOfThrownException(iOException);
                }
                catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                    Launcher.this.notifyOfThrownException(illegalConnectorArgumentsException);
                }
            }
        };
        thread.start();
        return thread;
    }

    public static ListeningConnector getListeningConnectorFor(String string) {
        List<ListeningConnector> list = Bootstrap.virtualMachineManager().listeningConnectors();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ListeningConnector listeningConnector = list.get(n2);
            if (listeningConnector.transport().name().equals(string)) {
                return listeningConnector;
            }
            ++n2;
        }
        return null;
    }

    public static AttachingConnector getAttachingConnectorFor(String string) {
        List<AttachingConnector> list = Bootstrap.virtualMachineManager().attachingConnectors();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            AttachingConnector attachingConnector = list.get(n2);
            if (attachingConnector.transport().name().equals(string)) {
                return attachingConnector;
            }
            ++n2;
        }
        return null;
    }

    private void throwDebuggerException(String string, Exception exception) throws DebuggerException {
        this.finish();
        String string2 = exception instanceof UnknownHostException ? bundle.getString("EXC_Cannot_establish_connection_to_VM") : new MessageFormat(bundle.getString("EXC_While_create_debuggee")).format(new Object[]{string, exception.toString()});
        throw new DebuggerException(string2, (Throwable)exception);
    }

    static boolean isUnknownHost(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        if (n == 0) {
            return true;
        }
        if (n < 6) {
            return false;
        }
        char c = string.charAt(0);
        if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '-') {
            return false;
        }
        char c2 = string.charAt(5);
        if (c2 == c) {
            return string.substring(1, 5).equalsIgnoreCase("none");
        }
        if (n < 9) {
            return false;
        }
        c2 = string.charAt(8);
        if (c2 == c) {
            return string.substring(1, 8).equalsIgnoreCase("unknown");
        }
        return false;
    }

    public boolean checkStream(BufferedReader bufferedReader, int n) {
        int n2 = 0;
        boolean bl = false;
        try {
            String string = bufferedReader.readLine();
            while (string != null && n2 < 20) {
                this.ioManager.println(string, n);
                string = bufferedReader.readLine();
                ++n2;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

