/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.DuplicateRequestException;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.jpda.JPDAClass;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.Launcher;
import org.netbeans.modules.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.RemoteDebuggerInfo;
import org.netbeans.modules.debugger.jpda.ThreadManager;
import org.netbeans.modules.debugger.jpda.VariableBreakpoint;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.actions.GoToCalledMethodAction;
import org.netbeans.modules.debugger.support.actions.GoToCallingMethodAction;
import org.netbeans.modules.debugger.support.java.ActionTIPanel;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaDebuggerSettings;
import org.netbeans.modules.debugger.support.java.LoadedClassesProducer;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.debugger.Watch;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public class JPDADebugger
extends JavaDebugger
implements Executor,
LoadedClassesProducer {
    static final long serialVersionUID = 2797853329739651906L;
    public static int ACTION_ON_TI_FIND;
    static ResourceBundle bundle;
    private static Random random;
    transient VirtualMachine virtualMachine = null;
    transient EventRequestManager requestManager = null;
    protected transient ThreadManager threadManager;
    protected transient Operator operator;
    private transient Process process;
    transient StepRequest stepRequest;
    private transient MethodEntryRequest findSourceMER;
    private transient StepRequest findSourceSR;
    private transient int findSourceCounter = 0;
    private transient Thread debuggerThread;
    transient boolean finishVM;
    private transient boolean disconnected = false;
    private transient Launcher launcher;
    private transient Hashtable loadedClasses = new Hashtable();
    private transient boolean isSuspended = false;
    private transient AttachingConnector connector;
    private transient Map args;
    private transient String mainClassName;
    private transient String stopClassName;
    private transient JPDAThread currentThread = null;
    protected transient JPDAThreadGroup threadGroup = new JPDAThreadGroup(null);
    private transient boolean stopOnMain = false;
    private transient DebuggerInfo debuggerInfo;
    private static transient String[] stopMethodNames;
    private transient CoreBreakpoint[] breakpointMain = null;
    protected transient Breakpoint runToCursorBreakpoint;
    private Method toStringMethod;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDADebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings;

    static String getLocString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebugger = JPDADebugger.class$("org.netbeans.modules.debugger.jpda.JPDADebugger")) : class$org$netbeans$modules$debugger$jpda$JPDADebugger));
        }
        return bundle.getString(string);
    }

    public void startDebugger(DebuggerInfo debuggerInfo) throws DebuggerException {
        BreakpointProducer breakpointProducer;
        this.debuggerInfo = debuggerInfo;
        if (this.virtualMachine != null) {
            this.finishDebugger();
        }
        this.stopOnMain = debuggerInfo.getStopClassName() != null;
        this.mainClassName = debuggerInfo.getClassName();
        this.finishVM = true;
        if (!(debuggerInfo instanceof RemoteDebuggerInfo) && !this.compile(debuggerInfo)) {
            this.finishDebugger();
            return;
        }
        this.disconnected = false;
        super.startDebugger(debuggerInfo);
        if (this.stopOnMain) {
            try {
                String string = this.debuggerInfo.getStopClassName();
                breakpointProducer = (BreakpointProducer)TopManager.getDefault().getDebugger();
                this.breakpointMain = new CoreBreakpoint[stopMethodNames.length];
                int n = 0;
                while (n < this.breakpointMain.length) {
                    this.breakpointMain[n] = breakpointProducer.createBreakpoint(true);
                    MethodBreakpoint methodBreakpoint = new MethodBreakpoint();
                    methodBreakpoint.setClassName(string);
                    methodBreakpoint.setMethodName(stopMethodNames[n]);
                    this.breakpointMain[n].setEvent((CoreBreakpoint.Event)methodBreakpoint);
                    CoreBreakpoint.Action[] actionArray = this.breakpointMain[n].getActions();
                    int n2 = actionArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        if (actionArray[n3] instanceof PrintAction) {
                            ((PrintAction)actionArray[n3]).setPrintText(JPDADebugger.getLocString("CTL_Stop_On_Main_print_text"));
                        }
                        ++n3;
                    }
                    ++n;
                }
                this.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("state") && ((Integer)propertyChangeEvent.getNewValue() == 4 || (Integer)propertyChangeEvent.getNewValue() == 1)) {
                            if (JPDADebugger.this.breakpointMain != null) {
                                int n = 0;
                                while (n < JPDADebugger.this.breakpointMain.length) {
                                    JPDADebugger.this.breakpointMain[n].remove();
                                    ++n;
                                }
                                JPDADebugger.access$002(JPDADebugger.this, null);
                            }
                            JPDADebugger.this.removePropertyChangeListener(this);
                        }
                    }
                });
            }
            catch (DebuggerException debuggerException) {
                debuggerException.printStackTrace();
            }
        }
        boolean bl = false;
        breakpointProducer = this.getClass();
        synchronized (breakpointProducer) {
            if (debuggerInfo instanceof ReconnectDebuggerInfo) {
                this.virtualMachine = this.reconnect((ReconnectDebuggerInfo)debuggerInfo);
            } else if (debuggerInfo instanceof RemoteDebuggerInfo) {
                this.virtualMachine = this.connect((RemoteDebuggerInfo)debuggerInfo);
            } else {
                this.virtualMachine = this.launch(debuggerInfo);
                this.getIOManager().showOutput(this.process, 3, 2);
                this.getIOManager().connectInput(this.process);
                bl = true;
            }
            this.requestManager = this.virtualMachine.eventRequestManager();
            this.operator = new Operator(this.virtualMachine, bl ? new Runnable(){

                public void run() {
                    JPDADebugger.this.startDebugger(true);
                }
            } : null, new Runnable(){

                public void run() {
                    try {
                        JPDADebugger.this.finishVM = false;
                        JPDADebugger.this.finishDebugger();
                    }
                    catch (DebuggerException debuggerException) {
                        // empty catch block
                    }
                }
            });
            this.operator.start();
            if (!bl) {
                this.startDebugger(false);
            }
        }
    }

    public synchronized void finishDebugger() throws DebuggerException {
        this.removeStepRequest();
        this.disconnected = true;
        if (this.threadManager != null) {
            this.threadManager.finish();
        }
        this.threadManager = null;
        if (this.debuggerThread != null) {
            this.debuggerThread.interrupt();
            this.debuggerThread.stop();
        }
        this.loadedClasses = new Hashtable();
        if (this.breakpointMain != null) {
            int n = 0;
            while (n < this.breakpointMain.length) {
                this.breakpointMain[n].remove();
                ++n;
            }
            this.breakpointMain = null;
        }
        if (this.requestManager != null) {
            try {
                this.requestManager.deleteAllBreakpoints();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (InternalException internalException) {
                // empty catch block
            }
        }
        if (this.finishVM) {
            try {
                if (this.virtualMachine != null) {
                    if (this.debuggerInfo instanceof RemoteDebuggerInfo) {
                        this.virtualMachine.dispose();
                    } else {
                        this.virtualMachine.exit(0);
                        if (this.process != null) {
                            this.process.destroy();
                        }
                    }
                }
                this.virtualMachine = null;
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.requestManager = null;
        super.finishDebugger();
    }

    public synchronized void traceInto() throws DebuggerException {
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        try {
            if (!this.currentThread.isSuspended()) {
                return;
            }
            this.removeStepRequest();
            this.setLastAction(3);
            this.stepRequest = this.requestManager.createStepRequest(this.currentThread.getThreadReference(), -2, 1);
            this.stepRequest.addCountFilter(1);
            this.stepRequest.putProperty("traceInto", "traceInto");
            this.stepRequest.setSuspendPolicy(2);
            this.operator.register(this.stepRequest, this);
            this.stepRequest.enable();
            this.resume();
            super.traceInto();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public synchronized void traceOver() throws DebuggerException {
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        try {
            if (!this.currentThread.isSuspended()) {
                return;
            }
            this.removeStepRequest();
            this.setLastAction(2);
            this.stepRequest = this.requestManager.createStepRequest(this.currentThread.getThreadReference(), -2, 2);
            this.stepRequest.addCountFilter(1);
            this.stepRequest.setSuspendPolicy(2);
            this.operator.register(this.stepRequest, this);
            this.stepRequest.enable();
            this.resume();
            super.traceOver();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public synchronized void go() throws DebuggerException {
        if (this.virtualMachine == null) {
            return;
        }
        try {
            this.setLastAction(5);
            this.removeStepRequest();
            this.resume();
            super.go();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public synchronized void stepOut() throws DebuggerException {
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        try {
            if (!this.currentThread.isSuspended()) {
                return;
            }
            this.removeStepRequest();
            this.setLastAction(4);
            this.stepRequest = this.requestManager.createStepRequest(this.currentThread.getThreadReference(), -2, 3);
            this.stepRequest.addCountFilter(1);
            this.stepRequest.setSuspendPolicy(2);
            this.operator.register(this.stepRequest, this);
            this.stepRequest.enable();
            this.resume();
            super.stepOut();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public synchronized void runToCursor(Line line) {
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        try {
            this.removeStepRequest();
            this.setLastAction(2);
            try {
                Debugger debugger = TopManager.getDefault().getDebugger();
                this.runToCursorBreakpoint = debugger.createBreakpoint(line, true);
                CoreBreakpoint.Action[] actionArray = ((CoreBreakpoint)this.runToCursorBreakpoint).getActions();
                int n = actionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (actionArray[n2] instanceof PrintAction) {
                        ((PrintAction)actionArray[n2]).setPrintText(PrintAction.RUN_TO_CURSOR_TEXT);
                    }
                    ++n2;
                }
            }
            catch (DebuggerNotFoundException debuggerNotFoundException) {
                // empty catch block
            }
            this.resume();
            super.runToCursor(line);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public void pause() {
        this.setSuspended(true);
    }

    public void setSuspended(boolean bl) {
        if (bl) {
            Object object;
            this.suspend();
            if (this.currentThread == null && !this.isDisconnected() && (object = this.threadManager.getAnyThread()) != null) {
                object.setCurrent(true);
            }
            this.setState(4);
            object = this.getIOManager();
            SwingUtilities.invokeLater(new Runnable((IOManager)object){
                private final /* synthetic */ IOManager val$ioManager;
                {
                    this.val$ioManager = iOManager;
                }

                public void run() {
                    this.val$ioManager.println(JPDADebugger.getLocString("CTL_Debugger_paused"), 4);
                }
            });
            this.threadManager.refreshStacks();
        } else {
            this.resume();
            this.setState(3);
        }
    }

    private synchronized void suspend() {
        if (this.isSuspended) {
            return;
        }
        this.isSuspended = true;
        if (this.virtualMachine != null) {
            this.virtualMachine.suspend();
        }
    }

    private synchronized void resume() {
        this.isSuspended = false;
        if (this.virtualMachine == null) {
            return;
        }
        if (this.currentThread == null) {
            this.virtualMachine.resume();
            return;
        }
        ThreadReference threadReference = this.currentThread.getThreadReference();
        int n = threadReference.suspendCount();
        if (n == 0) {
            this.virtualMachine.resume();
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.virtualMachine.resume();
            ++n2;
        }
    }

    public Watch createWatch() {
        JPDAWatch jPDAWatch = new JPDAWatch(this, false);
        this.addWatch((Watch)jPDAWatch);
        return jPDAWatch;
    }

    public Watch createWatch(String string, boolean bl) {
        JPDAWatch jPDAWatch = new JPDAWatch(this, false);
        jPDAWatch.setVariableName(string);
        this.addWatch((Watch)jPDAWatch);
        return jPDAWatch;
    }

    public String getLocationName(DebuggerInfo debuggerInfo) {
        if (debuggerInfo instanceof RemoteDebuggerInfo) {
            if (JPDADebugger.hasShmemTransport(((RemoteDebuggerInfo)debuggerInfo).getConnector())) {
                return "localhost";
            }
            if (JPDADebugger.hasSocketTransport(((RemoteDebuggerInfo)debuggerInfo).getConnector())) {
                Connector.Argument argument = (Connector.Argument)((RemoteDebuggerInfo)debuggerInfo).getArgs().get("hostname");
                return argument == null ? "localhost" : argument.value();
            }
            return "localhost";
        }
        return "localhost";
    }

    public ThreadsProducer getThreadsRoot() {
        return this.threadGroup;
    }

    public AbstractThread getCurrentThread() {
        return this.currentThread;
    }

    public void setCurrentThread(AbstractThread abstractThread) {
        if (this.currentThread == abstractThread) {
            return;
        }
        JPDAThread jPDAThread = this.currentThread;
        this.currentThread = (JPDAThread)abstractThread;
        this.updateCurrentStackPosition();
        this.updateStoppedState();
        this.firePropertyChange("currentThread", (Object)jPDAThread, abstractThread);
    }

    public List getLoadedClasses() {
        if (this.virtualMachine == null || this.isDisconnected()) {
            this.loadedClasses = new Hashtable();
            return new ArrayList();
        }
        try {
            List<ReferenceType> list = this.virtualMachine.allClasses();
            ArrayList<JPDAClass> arrayList = new ArrayList<JPDAClass>();
            Hashtable<ReferenceType, JPDAClass> hashtable = new Hashtable<ReferenceType, JPDAClass>();
            int n = 0;
            while (n < list.size()) {
                try {
                    ReferenceType referenceType = list.get(n);
                    if (!(referenceType instanceof ArrayType) && referenceType.name().indexOf(36) == -1) {
                        JPDAClass jPDAClass = (JPDAClass)((Object)this.loadedClasses.get(referenceType));
                        if (jPDAClass == null) {
                            jPDAClass = new JPDAClass(referenceType, this);
                        }
                        hashtable.put(referenceType, jPDAClass);
                        arrayList.add(jPDAClass);
                    }
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
                ++n;
            }
            this.loadedClasses = hashtable;
            return arrayList;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.loadedClasses = new Hashtable();
            return new ArrayList();
        }
    }

    public synchronized void exec(Event event) {
        this.removeStepRequest();
        StepEvent stepEvent = (StepEvent)event;
        ThreadReference threadReference = stepEvent.thread();
        Location location = stepEvent.location();
        int n = -1;
        String string = "?";
        String string2 = "?";
        String string3 = "?";
        String string4 = threadReference.name();
        Line line = null;
        if (location != null) {
            if (location.method() != null) {
                string = location.method().name();
            }
            string2 = location.declaringType().name();
            n = location.lineNumber();
            if (n >= 0) {
                string3 = "" + location.lineNumber();
            }
        }
        if (n != -1) {
            try {
                line = Utils.getLineForSource((String)string2, (String)location.sourceName(), (int)n);
            }
            catch (AbsentInformationException absentInformationException) {
                line = Utils.getLine((String)string2, (int)n);
            }
        }
        if (this.resolveCanBeCurrent(threadReference, line)) {
            return;
        }
        if (line == null && this.getLastAction() == 3) {
            int n2;
            JavaDebuggerSettings javaDebuggerSettings = (JavaDebuggerSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings = JPDADebugger.class$("org.netbeans.modules.debugger.support.java.JavaDebuggerSettings")) : class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings), (boolean)true);
            if (javaDebuggerSettings.isActionOnTraceIntoSet()) {
                ActionTIPanel actionTIPanel = new ActionTIPanel(string2, string, string3);
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)actionTIPanel, 2);
                Object object = TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                if (object.equals(NotifyDescriptor.OK_OPTION)) {
                    actionTIPanel.updateSettings();
                }
            }
            if ((n2 = javaDebuggerSettings.getActionOnTraceInto()) == ACTION_ON_TI_FIND) {
                this.traceToSourceCode(threadReference);
            } else if (n2 == JavaDebuggerSettings.ACTION_ON_TI_TRACE_OUT) {
                this.stepRequest = this.requestManager.createStepRequest(threadReference, -2, 3);
                this.stepRequest.addCountFilter(1);
                this.stepRequest.setSuspendPolicy(2);
                this.operator.register(this.stepRequest, this);
                this.stepRequest.enable();
                this.operator.resume();
            } else {
                this.makeCurrent(string4, string2, string, string3, line != null, threadReference, line);
                this.operator.stopRequest();
            }
        } else {
            this.makeCurrent(string4, string2, string, string3, line != null, threadReference, line);
            this.operator.stopRequest();
        }
    }

    public void disconnect() throws DebuggerException {
        if (this.breakpointMain != null) {
            int n = 0;
            while (n < this.breakpointMain.length) {
                this.breakpointMain[n].remove();
                ++n;
            }
            this.breakpointMain = null;
        }
        try {
            if (this.virtualMachine != null) {
                this.virtualMachine.dispose();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        if (this.threadManager != null) {
            this.threadManager.finish();
        }
        if (this.debuggerThread != null) {
            this.debuggerThread.interrupt();
            this.debuggerThread.stop();
        }
        super.finishDebugger();
    }

    public void reconnect() throws DebuggerException {
        this.startDebugger((DebuggerInfo)new ReconnectDebuggerInfo(this.connector, this.args));
    }

    public synchronized void traceToSourceCode(ThreadReference threadReference) {
        try {
            this.findSourceSR = this.requestManager.createStepRequest(threadReference, -2, 3);
            this.findSourceSR.addCountFilter(1);
            this.findSourceSR.setSuspendPolicy(2);
            this.operator.register(this.findSourceSR, this);
            this.findSourceSR.enable();
        }
        catch (DuplicateRequestException duplicateRequestException) {
            duplicateRequestException.printStackTrace();
        }
        this.findSourceMER = this.requestManager.createMethodEntryRequest();
        this.findSourceMER.setSuspendPolicy(2);
        this.findSourceMER.addThreadFilter(threadReference);
        this.findSourceCounter = 0;
        this.operator.register(this.findSourceMER, new Executor(){

            public void exec(Event event) {
                JPDADebugger jPDADebugger = JPDADebugger.this;
                synchronized (jPDADebugger) {
                    if (JPDADebugger.this.findSourceCounter == 1500) {
                        JPDADebugger.this.operator.resume();
                        if (JPDADebugger.this.findSourceMER != null) {
                            JPDADebugger.this.requestManager.deleteEventRequest(JPDADebugger.this.findSourceMER);
                            JPDADebugger.this.findSourceMER = null;
                        }
                        return;
                    }
                    JPDADebugger.this.findSourceCounter++;
                    Location location = ((MethodEntryEvent)event).location();
                    if (location == null) {
                        JPDADebugger.this.operator.resume();
                        return;
                    }
                    String string = location.declaringType().name();
                    int n = location.lineNumber();
                    try {
                        Line line = null;
                        line = Utils.getLineForSource((String)string, (String)location.sourceName(), (int)n);
                        if (line == null) {
                            JPDADebugger.this.operator.resume();
                            return;
                        }
                        ThreadReference threadReference = ((MethodEntryEvent)event).thread();
                        if (JPDADebugger.this.resolveCanBeCurrent(threadReference, line)) {
                            return;
                        }
                        String string2 = threadReference.name();
                        String string3 = location.method() != null ? location.method().name() : "";
                        String string4 = n == -1 ? "?" : "" + n;
                        JPDADebugger.this.makeCurrent(string2, string, string3, string4, true, threadReference, line);
                        JPDADebugger.this.operator.stopRequest();
                    }
                    catch (AbsentInformationException absentInformationException) {
                        // empty catch block
                    }
                }
            }
        });
        this.findSourceMER.enable();
        this.operator.resume();
    }

    boolean resolveCanBeCurrent(ThreadReference threadReference) {
        try {
            Location location = threadReference.frame(0).location();
            if (location == null) {
                return false;
            }
            return this.resolveCanBeCurrent(threadReference, Utils.getLineForSource((String)location.declaringType().name(), (String)location.sourceName(), (int)location.lineNumber()));
        }
        catch (Exception exception) {
            return false;
        }
    }

    synchronized boolean resolveCanBeCurrent(ThreadReference threadReference, Line line) {
        if (line != null && !this.canBeCurrent(line, false)) {
            try {
                this.removeStepRequest();
                this.findSourceSR = this.requestManager.createStepRequest(threadReference, -2, 2);
                this.findSourceSR.addCountFilter(1);
                this.findSourceSR.setSuspendPolicy(2);
                this.operator.register(this.findSourceSR, this);
                this.findSourceSR.enable();
                this.operator.resume();
            }
            catch (DuplicateRequestException duplicateRequestException) {
                duplicateRequestException.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void makeCurrent(String string, String string2, String string3, String string4, boolean bl, ThreadReference threadReference, Line line) {
        this.setState(4);
        IOManager iOManager = this.getIOManager();
        if (bl) {
            iOManager.println(new MessageFormat(JPDADebugger.getLocString("CTL_Thread_stopped")).format(new Object[]{string, string2, string3, string4}), 5, line);
        } else {
            iOManager.println(new MessageFormat(JPDADebugger.getLocString("CTL_Thread_stopped_no_source")).format(new Object[]{string, string2, string3, string4}), 5);
        }
        JPDAThread jPDAThread = this.threadManager.getThread(threadReference);
        jPDAThread.setCurrent(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this.threadManager.refreshStacks();
            }
        });
    }

    private void startDebugger(boolean bl) {
        this.threadManager = new ThreadManager(this);
        boolean bl2 = this.virtualMachine.canWatchFieldAccess();
        boolean bl3 = this.virtualMachine.canWatchFieldModification();
        if (!bl2 || !bl3) {
            try {
                AbstractDebugger abstractDebugger = (AbstractDebugger)TopManager.getDefault().getDebugger();
                Breakpoint[] breakpointArray = abstractDebugger.getBreakpoints();
                int n = 0;
                while (n < breakpointArray.length) {
                    CoreBreakpoint.Event event;
                    if (((CoreBreakpoint)breakpointArray[n]).isEnabled() && (event = ((CoreBreakpoint)breakpointArray[n]).getEvent((Debugger)abstractDebugger)) instanceof VariableBreakpoint) {
                        if (!bl2 && !bl3) {
                            this.getIOManager().println(JPDADebugger.getLocString("CTL_Break_on_field_not_supported"), 1);
                            break;
                        }
                        if (((VariableBreakpoint)event).getType() == 0 && !bl2) {
                            this.getIOManager().println(JPDADebugger.getLocString("CTL_Break_on_field_access_not_supported"), 1);
                            break;
                        }
                        if (((VariableBreakpoint)event).getType() == 1 && !bl3) {
                            this.getIOManager().println(JPDADebugger.getLocString("CTL_Break_on_field_modification_not_supported"), 1);
                            break;
                        }
                    }
                    ++n;
                }
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
        }
        this.getIOManager().println(JPDADebugger.getLocString("CTL_Debugger_running"), 4);
        this.setState(3);
        if (bl) {
            this.operator.resume();
        } else {
            this.resume();
        }
        if (this.debuggerThread != null) {
            this.debuggerThread.stop();
        }
        this.debuggerThread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (JPDADebugger.this.getState() != 3 || JPDADebugger.this.threadManager == null) continue;
                    JPDADebugger.this.threadManager.refreshThreads();
                }
            }
        }, "Debugger refresh thread");
        this.debuggerThread.setPriority(1);
        this.debuggerThread.start();
    }

    synchronized void removeStepRequest() {
        try {
            if (this.runToCursorBreakpoint != null) {
                this.runToCursorBreakpoint.remove();
                this.runToCursorBreakpoint = null;
            }
            if (this.stepRequest != null) {
                this.requestManager.deleteEventRequest(this.stepRequest);
                this.operator.unregister(this.stepRequest);
                this.stepRequest = null;
            }
            if (this.findSourceMER != null) {
                this.requestManager.deleteEventRequest(this.findSourceMER);
                this.operator.unregister(this.findSourceMER);
                this.findSourceMER = null;
            }
            if (this.findSourceSR != null) {
                this.requestManager.deleteEventRequest(this.findSourceSR);
                this.operator.unregister(this.findSourceSR);
                this.findSourceSR = null;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    private static String generatePassword() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 4) {
            stringBuffer.append((char)(random.nextInt(26) + 97));
            ++n;
        }
        return new String(stringBuffer);
    }

    private VirtualMachine launch(DebuggerInfo debuggerInfo) throws DebuggerException {
        try {
            if (this.launcher == null) {
                this.launcher = new Launcher(this.getIOManager());
            }
            VirtualMachine virtualMachine = this.launcher.launch(debuggerInfo);
            this.process = this.launcher.process();
            this.connector = this.launcher.attachingConnector();
            String string = this.launcher.address();
            this.args = this.connector.defaultArguments();
            if (JPDADebugger.hasShmemTransport(this.connector)) {
                ((Connector.Argument)this.args.get("name")).setValue(string);
            } else {
                ((Connector.Argument)this.args.get("port")).setValue(string);
            }
            return virtualMachine;
        }
        catch (DebuggerException debuggerException) {
            this.finishDebugger();
            throw debuggerException;
        }
    }

    private VirtualMachine reconnect(ReconnectDebuggerInfo reconnectDebuggerInfo) throws DebuggerException {
        return this.connect("CTL_Reconnecting_to", reconnectDebuggerInfo.getConnector(), reconnectDebuggerInfo.getArgs());
    }

    private VirtualMachine connect(RemoteDebuggerInfo remoteDebuggerInfo) throws DebuggerException {
        this.connector = remoteDebuggerInfo.getConnector();
        this.args = remoteDebuggerInfo.getArgs();
        return this.connect("CTL_Connecting_to", this.connector, this.args);
    }

    private VirtualMachine connect(String string, AttachingConnector attachingConnector, Map map) throws DebuggerException {
        Object object;
        if (string != null) {
            if (JPDADebugger.hasShmemTransport(attachingConnector)) {
                object = (Connector.Argument)map.get("name");
                if (object == null) {
                    this.getIOManager().println(JPDADebugger.getLocString(string + "_shmem_noargs"), 1);
                } else {
                    this.getIOManager().println(new MessageFormat(JPDADebugger.getLocString(string + "_shmem")).format(new Object[]{object.value()}), 1);
                }
            } else if (JPDADebugger.hasSocketTransport(attachingConnector)) {
                object = (Connector.Argument)map.get("hostname");
                Connector.Argument argument = (Connector.Argument)map.get("port");
                if (object == null || argument == null) {
                    this.getIOManager().println(JPDADebugger.getLocString(string + "_socket_noargs"), 1);
                } else {
                    this.getIOManager().println(new MessageFormat(JPDADebugger.getLocString(string + "_socket")).format(new Object[]{object.value(), argument.value()}), 1);
                }
            } else {
                this.getIOManager().println(JPDADebugger.getLocString(string), 1);
            }
        }
        try {
            object = attachingConnector.attach(map);
            if (object != null) {
                this.getIOManager().println(JPDADebugger.getLocString("CTL_Connection_established"), 1);
            }
            return object;
        }
        catch (Exception exception) {
            this.finishDebugger();
            throw new DebuggerException(new MessageFormat(JPDADebugger.getLocString("EXC_While_connecting_to_debuggee")).format(new Object[]{exception.toString()}), (Throwable)exception);
        }
    }

    synchronized void stop(boolean bl, final AbstractThread abstractThread) {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebugger = JPDADebugger.class$("org.netbeans.modules.debugger.jpda.JPDADebugger")) : class$org$netbeans$modules$debugger$jpda$JPDADebugger));
        if (bl) {
            this.removeStepRequest();
            this.setLastAction(1);
            this.setState(4);
            this.operator.stopRequest();
            SwingUtilities.invokeLater(new Runnable(){
                static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction;
                static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction;

                public void run() {
                    if (abstractThread != null) {
                        abstractThread.setCurrent(true);
                    }
                    ((GoToCalledMethodAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction = 8.class$("org.netbeans.modules.debugger.support.actions.GoToCalledMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction))).setEnabled(JPDADebugger.this.getDebuggerState().isGoToCalledMethodEnabled());
                    ((GoToCallingMethodAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction = 8.class$("org.netbeans.modules.debugger.support.actions.GoToCallingMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction))).setEnabled(JPDADebugger.this.getDebuggerState().isGoToCallingMethodEnabled());
                    if (JPDADebugger.this.threadManager != null) {
                        JPDADebugger.this.threadManager.refreshStacks();
                    }
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        } else {
            this.operator.resume();
        }
    }

    boolean isDisconnected() {
        if (this.operator == null) {
            return false;
        }
        return this.disconnected || this.operator.isDisconnected();
    }

    public synchronized void setState(int n) {
        super.setState(n);
    }

    public void setDebuggerState(State state) {
        super.setDebuggerState(state);
    }

    private static boolean hasSocketTransport(Connector connector) {
        try {
            return connector.transport().name().toLowerCase().indexOf("socket") > -1;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    private static boolean hasShmemTransport(Connector connector) {
        try {
            return connector.transport().name().toLowerCase().indexOf("shmem") > -1;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    Method getToStringMethod() {
        if (this.toStringMethod != null) {
            return this.toStringMethod;
        }
        List<Comparable<ReferenceType>> list = this.virtualMachine.classesByName("java.lang.Object");
        ReferenceType referenceType = list.iterator().next();
        list = referenceType.methodsByName("toString");
        this.toStringMethod = (Method)list.iterator().next();
        return this.toStringMethod;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ CoreBreakpoint[] access$002(JPDADebugger jPDADebugger, CoreBreakpoint[] coreBreakpointArray) {
        jPDADebugger.breakpointMain = coreBreakpointArray;
        return coreBreakpointArray;
    }

    static {
        random = new Random();
        stopMethodNames = new String[]{"main", "start", "init", "<init>"};
    }

    private class ReconnectDebuggerInfo
    extends RemoteDebuggerInfo {
        private ReconnectDebuggerInfo(AttachingConnector attachingConnector, Map map) {
            super(attachingConnector, map);
        }
    }
}

