/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.StaticField;
import org.netbeans.modules.debugger.jpda.ValueVariable;
import org.netbeans.modules.debugger.jpda.WatchVariable;
import org.netbeans.modules.debugger.support.java.JavaClass;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class JPDAClass
extends JavaClass {
    private ReferenceType referenceType;
    private JPDADebugger debugger;
    private boolean isClass;
    private MethodElement[] methods = null;
    private ConstructorElement[] constructors = null;
    private InitializerElement initializer = null;
    private FieldElement[] fields = null;
    private Hashtable classes = new Hashtable();

    public JPDAClass(ReferenceType referenceType, JPDADebugger jPDADebugger) {
        this.referenceType = referenceType;
        this.debugger = jPDADebugger;
        this.isClass = this.referenceType instanceof ClassType;
    }

    public String getName() {
        if (this.debugger.isDisconnected()) {
            return "";
        }
        try {
            return this.referenceType.name();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return "";
        }
    }

    /*
     * Unable to fully structure code
     */
    public JavaClass[] getInnerClasses() {
        if (this.debugger.isDisconnected()) {
            return new JPDAClass[0];
        }
        try {
            var1_1 = null;
            try {
                var1_1 = this.referenceType.nestedTypes();
            }
            catch (ConcurrentModificationException var2_3) {
                try {
                    var1_1 = this.referenceType.nestedTypes();
                }
                catch (ConcurrentModificationException var3_6) {
                    return new JPDAClass[0];
                }
            }
            if (var1_1.isEmpty()) {
                if (this.classes != null) {
                    this.classes.clear();
                }
                return new JavaClass[0];
            }
            var2_4 = var1_1.iterator();
            var3_7 = new Hashtable<JavaClass[], JavaClass>();
            try {
                var4_8 = this.referenceType.name().length() + 1;
                if (true) ** GOTO lbl38
            }
            catch (ObjectCollectedException var5_9) {
                return new JavaClass[0];
            }
            do {
                try {
                    var5_10 = var2_4.next();
                    var6_12 = var5_10.name().substring(var4_8);
                    var8_13 = null;
                    if ((this.classes == null || (var8_13 = (JavaClass)this.classes.get(var6_12)) == null) && var6_12.indexOf(36) == -1) {
                        var8_13 = new JPDAClass((ReferenceType)var5_10, this.debugger);
                    }
                    if (var8_13 == null) continue;
                    var3_7.put(var6_12, var8_13);
                }
                catch (ObjectCollectedException var5_11) {
                    // empty catch block
                }
lbl38:
                // 4 sources

            } while (var2_4.hasNext());
            this.classes = var3_7;
            var5_10 = this.classes.elements();
            var6_12 = new JavaClass[this.classes.size()];
            var7_14 = 0;
            while (var5_10.hasMoreElements()) {
                var6_12[var7_14++] = (JPDAClass)var5_10.nextElement();
            }
            return var6_12;
        }
        catch (ObjectCollectedException var1_2) {
        }
        catch (VMDisconnectedException var2_5) {
            // empty catch block
        }
        return new JavaClass[0];
    }

    private void initMethods() {
        if (this.debugger.isDisconnected()) {
            return;
        }
        if (this.methods != null && this.constructors != null) {
            return;
        }
        try {
            List<Method> list = this.referenceType.methods();
            Iterator<Method> iterator = list.iterator();
            MethodElement[] methodElementArray = new MethodElement[list.size()];
            int n = 0;
            ArrayList<ConstructorElement> arrayList = new ArrayList<ConstructorElement>();
            while (iterator.hasNext()) {
                Method method = iterator.next();
                if (method.isSynthetic()) continue;
                List<Object> list2 = new ArrayList();
                boolean bl = true;
                try {
                    list2 = method.arguments();
                    bl = false;
                }
                catch (AbsentInformationException absentInformationException) {
                }
                catch (NativeMethodException nativeMethodException) {
                    // empty catch block
                }
                if (bl) {
                    list2 = method.argumentTypeNames();
                }
                MethodParameter[] methodParameterArray = new MethodParameter[list2.size()];
                if (!bl) {
                    int n2 = 0;
                    while (n2 < list2.size()) {
                        LocalVariable localVariable = (LocalVariable)list2.get(n2);
                        methodParameterArray[n2] = new MethodParameter(localVariable.name(), Type.createClass((Identifier)Identifier.create((String)localVariable.typeName())), false);
                        ++n2;
                    }
                } else {
                    int n3 = 0;
                    while (n3 < list2.size()) {
                        methodParameterArray[n3] = new MethodParameter("", Type.createClass((Identifier)Identifier.create((String)((String)list2.get(n3)))), false);
                        ++n3;
                    }
                }
                if (method.isStaticInitializer()) {
                    this.initializer = new InitializerElement();
                    this.initializer.setStatic(true);
                    continue;
                }
                ConstructorElement constructorElement = null;
                if (method.isConstructor()) {
                    constructorElement = new ConstructorElement();
                    arrayList.add(constructorElement);
                } else {
                    constructorElement = new MethodElement();
                    ((MethodElement)constructorElement).setReturn(Type.createClass((Identifier)Identifier.create((String)method.returnTypeName())));
                    methodElementArray[n++] = (MethodElement)constructorElement;
                }
                constructorElement.setParameters(methodParameterArray);
                constructorElement.setName(Identifier.create((String)method.name()));
                constructorElement.setModifiers(method.modifiers());
            }
            this.methods = new MethodElement[n];
            int n4 = 0;
            while (n4 < n) {
                this.methods[n4] = methodElementArray[n4];
                ++n4;
            }
            this.constructors = new ConstructorElement[arrayList.size()];
            int n5 = 0;
            while (n5 < arrayList.size()) {
                this.constructors[n5] = (ConstructorElement)arrayList.get(n5);
                ++n5;
            }
            return;
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (SourceException sourceException) {
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            // empty catch block
        }
    }

    public MethodElement[] getMethods() {
        this.initMethods();
        if (this.methods != null) {
            return this.methods;
        }
        return new MethodElement[0];
    }

    public ConstructorElement[] getConstructors() {
        this.initMethods();
        if (this.constructors != null) {
            return this.constructors;
        }
        return new ConstructorElement[0];
    }

    public InitializerElement[] getInitializers() {
        InitializerElement[] initializerElementArray;
        this.initMethods();
        if (this.initializer == null) {
            initializerElementArray = new InitializerElement[]{};
        } else {
            InitializerElement[] initializerElementArray2 = new InitializerElement[1];
            initializerElementArray = initializerElementArray2;
            initializerElementArray2[0] = this.initializer;
        }
        return initializerElementArray;
    }

    public FieldElement[] getFields() {
        if (this.debugger.isDisconnected()) {
            return new FieldElement[0];
        }
        if (this.fields != null) {
            return this.fields;
        }
        try {
            List<Field> list = this.referenceType.fields();
            Iterator<Field> iterator = list.iterator();
            FieldElement[] fieldElementArray = new FieldElement[list.size()];
            int n = 0;
            while (iterator.hasNext()) {
                Field field = iterator.next();
                FieldElement fieldElement = new FieldElement();
                fieldElement.setName(Identifier.create((String)field.name()));
                fieldElement.setType(Type.createClass((Identifier)Identifier.create((String)field.typeName())));
                fieldElement.setModifiers(field.modifiers());
                fieldElementArray[n++] = fieldElement;
            }
            this.fields = fieldElementArray;
            return fieldElementArray;
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (SourceException sourceException) {
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            // empty catch block
        }
        return new FieldElement[0];
    }

    public Identifier getSuperClass() {
        if (this.debugger.isDisconnected()) {
            return null;
        }
        if (!(this.referenceType instanceof ClassType)) {
            return null;
        }
        try {
            ClassType classType = ((ClassType)this.referenceType).superclass();
            if (classType != null) {
                return JavaClass.createClassIdentifier((String)classType.name());
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            // empty catch block
        }
        return null;
    }

    public Identifier[] getInterfaces() {
        if (this.debugger.isDisconnected()) {
            return new Identifier[0];
        }
        try {
            List<InterfaceType> list = null;
            if (this.referenceType instanceof ClassType) {
                list = ((ClassType)this.referenceType).interfaces();
            }
            if (this.referenceType instanceof InterfaceType) {
                list = ((InterfaceType)this.referenceType).superinterfaces();
            }
            if (list == null) {
                return new Identifier[0];
            }
            Identifier[] identifierArray = new Identifier[list.size()];
            int n = 0;
            while (n < list.size()) {
                identifierArray[n] = JavaClass.createClassIdentifier((String)((ReferenceType)list.get(n)).name());
                ++n;
            }
            return identifierArray;
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            // empty catch block
        }
        return new Identifier[0];
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isPrepared() {
        if (this.debugger.isDisconnected()) {
            return false;
        }
        return this.referenceType.isPrepared();
    }

    public int modifiers() {
        if (this.debugger.isDisconnected()) {
            return 0;
        }
        return this.referenceType.modifiers();
    }

    public String classLoaderTypeName() {
        if (this.debugger.isDisconnected()) {
            return null;
        }
        if (this.referenceType.classLoader() == null) {
            return null;
        }
        try {
            return this.referenceType.classLoader().referenceType().name();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return null;
        }
    }

    public JavaVariable getClassLoader() {
        if (this.debugger.isDisconnected()) {
            return null;
        }
        ClassLoaderReference classLoaderReference = this.referenceType.classLoader();
        if (classLoaderReference == null) {
            return null;
        }
        ValueVariable valueVariable = new ValueVariable(this.debugger, "Classloader", classLoaderReference.referenceType().toString(), classLoaderReference);
        return valueVariable;
    }

    public JavaVariable getStaticVariable(FieldElement fieldElement) {
        if (this.debugger.isDisconnected()) {
            return new WatchVariable(this.debugger, false);
        }
        return new StaticField(this.debugger, this.referenceType, this.referenceType.fieldByName(fieldElement.getName().getFullName()));
    }

    ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JPDAClass)) {
            return false;
        }
        return ((JPDAClass)((Object)object)).getReferenceType().equals(this.referenceType);
    }

    public int hashCode() {
        return this.referenceType.hashCode();
    }
}

