/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.jpda.LocalVariable;
import org.netbeans.modules.debugger.jpda.ThisLocalVariable;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.openide.debugger.DebuggerException;
import org.openide.util.NbBundle;

public class JPDACallStackFrame
extends CallStackFrame {
    private ThreadReference threadS;
    private int indexS;
    private JPDADebugger debugger;
    private VariablesFilter filter;
    HashMap oldLocals = new HashMap();
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDACallStackFrame;

    JPDACallStackFrame(JPDADebugger jPDADebugger, ThreadReference threadReference, int n) {
        this.debugger = jPDADebugger;
        this.threadS = threadReference;
        this.indexS = n;
    }

    StackFrame stackFrame() {
        try {
            return this.threadS.frame(this.indexS);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            // empty catch block
        }
        return null;
    }

    public int getLineNumber() {
        try {
            return this.stackFrame().location().lineNumber();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getMethodName() {
        try {
            Method method = this.stackFrame().location().method();
            if (method == null) {
                return "";
            }
            return method.name();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getClassName() {
        try {
            return this.stackFrame().location().declaringType().name();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getSourceName() throws DebuggerException {
        try {
            return this.stackFrame().location().sourceName();
        }
        catch (Exception exception) {
            throw new DebuggerException((Throwable)exception);
        }
    }

    public String getInfo() {
        try {
            if (this.stackFrame().location().method().isNative()) {
                return null;
            }
            this.stackFrame().visibleVariables();
            return null;
        }
        catch (AbsentInformationException absentInformationException) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDACallStackFrame == null ? (class$org$netbeans$modules$debugger$jpda$JPDACallStackFrame = JPDACallStackFrame.class$("org.netbeans.modules.debugger.jpda.JPDACallStackFrame")) : class$org$netbeans$modules$debugger$jpda$JPDACallStackFrame)).getString("CTL_Source_compiled_without_g");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public AbstractVariable[] getVariables() {
        if (this.debugger.isDisconnected()) {
            return new AbstractVariable[0];
        }
        try {
            JPDAVariable jPDAVariable;
            Object object;
            List<Object> list = null;
            if (this.stackFrame().location().method().isNative()) {
                list = new LinkedList();
            } else {
                try {
                    list = this.stackFrame().visibleVariables();
                }
                catch (AbsentInformationException absentInformationException) {
                    list = new LinkedList();
                }
            }
            HashMap<String, JPDAVariable> hashMap = new HashMap<String, JPDAVariable>();
            int n = list.size();
            ObjectReference objectReference = this.stackFrame().thisObject();
            ArrayList<JPDAVariable> arrayList = new ArrayList<JPDAVariable>();
            int n2 = 0;
            while (n2 < n) {
                object = (com.sun.jdi.LocalVariable)list.get(n2);
                jPDAVariable = (JPDAVariable)this.oldLocals.get(object.name());
                try {
                    if (jPDAVariable == null) {
                        jPDAVariable = new LocalVariable(this.debugger, this.threadS, this.indexS, (com.sun.jdi.LocalVariable)object);
                    } else if (JPDAVariable.ON_LINE) {
                        jPDAVariable.validate();
                    }
                    arrayList.add(jPDAVariable);
                    hashMap.put(object.name(), jPDAVariable);
                }
                catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
                    // empty catch block
                }
                ++n2;
            }
            if (objectReference != null) {
                jPDAVariable = (JPDAVariable)this.oldLocals.get("this");
                if (jPDAVariable == null) {
                    jPDAVariable = new ThisLocalVariable(this.debugger, this.threadS, this.indexS);
                } else if (JPDAVariable.ON_LINE) {
                    jPDAVariable.validate();
                }
                arrayList.add(jPDAVariable);
                hashMap.put("this", jPDAVariable);
            }
            this.oldLocals = hashMap;
            object = ((AbstractList)arrayList).iterator();
            JPDAVariable[] jPDAVariableArray = new JPDAVariable[arrayList.size()];
            int n3 = 0;
            while (n3 < arrayList.size()) {
                jPDAVariableArray[n3] = (JPDAVariable)object.next();
                ++n3;
            }
            return jPDAVariableArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new AbstractVariable[0];
        }
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.debugger.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter variablesFilter) {
        if (variablesFilter == this.filter) {
            return;
        }
        if (variablesFilter != null && variablesFilter.equals(this.filter)) {
            return;
        }
        VariablesFilter variablesFilter2 = this.filter;
        this.filter = variablesFilter;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

