/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMMismatchException;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.ExceptionBreakpointPanel;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.ValueVariable;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Requestor;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.ClassBreakpointEvent;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.Debugger;
import org.openide.explorer.propertysheet.editors.ChoicePropertyEditor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class ExceptionBreakpoint
extends ClassBreakpointEvent
implements Executor,
StopEvent,
InfoProducer {
    static final long serialVersionUID = -1543264672497993747L;
    public static final String PROP_CATCH_TYPE = "catchType";
    public static final String PROP_CONDITION = "condition";
    public static final int EXCEPTION_CATCHED = 1;
    public static final int EXCEPTION_UNCATCHED = 2;
    public static final String TYPE_NAME = "java-exception";
    private transient ThreadReference thread;
    private Requestor requestor;
    private ReferenceType tryClass;
    private JPDAVariable exception;
    private int catchType = 2;
    private String condition = "";
    private HashSet refTypesWithBreakpoint;
    private transient CoreBreakpoint.Action[] actions;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$VariableBreakpoint;
    static /* synthetic */ Class class$java$lang$String;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.condition == null) {
            this.condition = "";
        }
    }

    public boolean set() {
        Debugger debugger = this.getDebugger();
        if (!(debugger instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debugger;
        if (jPDADebugger.virtualMachine == null || jPDADebugger.isDisconnected()) {
            return false;
        }
        if (this.getClassName() == null || this.getClassName().trim().length() < 1) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = new Requestor(jPDADebugger.requestManager, jPDADebugger.operator, this);
        }
        try {
            ReferenceType referenceType;
            this.requestor.removeRequests();
            if (this.refTypesWithBreakpoint != null) {
                this.refTypesWithBreakpoint.clear();
            }
            ClassPrepareRequest classPrepareRequest = jPDADebugger.requestManager.createClassPrepareRequest();
            classPrepareRequest.addClassFilter(this.getClassName() + '*');
            classPrepareRequest.setSuspendPolicy(2);
            this.requestor.add(classPrepareRequest);
            classPrepareRequest.enable();
            List<ReferenceType> list = jPDADebugger.virtualMachine.classesByName(this.getClassName());
            if (list.size() == 0) {
                return false;
            }
            boolean bl = false;
            ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                referenceType = list.get(n);
                this.set(referenceType);
                try {
                    arrayList.addAll(Utils.anonymousInnerClasses((String)referenceType.name(), referenceType.nestedTypes()));
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
                ++n;
            }
            n = 0;
            while (n < arrayList.size()) {
                referenceType = (ReferenceType)arrayList.get(n);
                this.set(referenceType);
                try {
                    arrayList.addAll(referenceType.nestedTypes());
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
                ++n;
            }
            return true;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
    }

    public Node.Property[] getProperties() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$VariableBreakpoint == null ? (class$org$netbeans$modules$debugger$jpda$VariableBreakpoint = ExceptionBreakpoint.class$("org.netbeans.modules.debugger.jpda.VariableBreakpoint")) : class$org$netbeans$modules$debugger$jpda$VariableBreakpoint));
        return new Node.Property[]{Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = ExceptionBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)"className", (String)JPDADebugger.getLocString("PROP_Exception_class_name"), (String)JPDADebugger.getLocString("HINT_Exception_class_name"), (String)"getClassName", (String)"setClassName"), new PropertySupport.ReadWrite(PROP_CATCH_TYPE, Integer.TYPE, JPDADebugger.getLocString("PROP_Exception_type_name"), JPDADebugger.getLocString("HINT_Exception_type_name")){

            public Object getValue() throws IllegalArgumentException {
                return new Integer(ExceptionBreakpoint.this.getCatchType());
            }

            public void setValue(Object object) throws IllegalArgumentException {
                try {
                    ExceptionBreakpoint.this.setCatchType((Integer)object);
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException();
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new ChoicePropertyEditor(new int[]{1, 2, 3}, new String[]{JPDADebugger.getLocString("CTL_Exception_type_catched"), JPDADebugger.getLocString("CTL_Exception_type_uncatched"), JPDADebugger.getLocString("CTL_Exception_type_both")});
            }
        }, Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = ExceptionBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_CONDITION, (String)JPDADebugger.getLocString("PROP_condition"), (String)JPDADebugger.getLocString("HINT_condition"), (String)"getCondition", (String)"setCondition")};
    }

    public Line[] getLines() {
        return null;
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] actionArray = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new PrintAction(PrintAction.BREAKPOINT_EXCEPTION_TEXT)};
            if (actionArray.length != 0) {
                CoreBreakpoint.Action[] actionArray2 = this.actions;
                this.actions = new CoreBreakpoint.Action[actionArray.length + actionArray2.length];
                System.arraycopy(actionArray, 0, this.actions, 0, actionArray.length);
                System.arraycopy(actionArray2, 0, this.actions, actionArray.length, actionArray2.length);
            }
        }
        return this.actions;
    }

    public JavaThread getThread() {
        if (this.thread == null) {
            return null;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
        return jPDADebugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((JPDAThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        return this.exception;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JPDADebugger.getLocString("CTL_Exception_event_name_type_name");
    }

    public String getCategoryDisplayName() {
        return JPDADebugger.getLocString("CTL_Java_breakpoint_events_cathegory_name");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType() == TYPE_NAME;
    }

    public String getDisplayName() {
        if ((this.getCatchType() & 1) != 0) {
            if ((this.getCatchType() & 2) != 0) {
                return new MessageFormat(JPDADebugger.getLocString("CTL_Exception_event_name")).format(new Object[]{this.getClassName()});
            }
            return new MessageFormat(JPDADebugger.getLocString("CTL_Exception_event_name_catched")).format(new Object[]{this.getClassName()});
        }
        return new MessageFormat(JPDADebugger.getLocString("CTL_Exception_event_name_uncatched")).format(new Object[]{this.getClassName()});
    }

    public String getIconBase() {
        return "/org/netbeans/modules/debugger/resources/breakpointOnException";
    }

    public JComponent getCustomizer() {
        this.setClassName(JUtils.getSelectedIdentifier());
        return new ExceptionBreakpointPanel(this);
    }

    public void setCondition(String string) {
        if (string != null) {
            string = string.trim();
        }
        String string2 = this.condition;
        this.condition = string;
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String getCondition() {
        return this.condition;
    }

    protected void perform() {
        if (!this.condition.trim().equals("")) {
            JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
            JPDAWatch jPDAWatch = new JPDAWatch(jPDADebugger, true);
            jPDAWatch.setVariableName(this.condition);
            jPDAWatch.refreshValue((JPDAThread)this.getThread());
            String string = jPDAWatch.getType();
            String string2 = jPDAWatch.getAsText();
            if (string != null && string.equals("boolean") && string2 != null && string2.equals("false")) {
                this.stop(false);
                return;
            }
            if (string == null || !string.equals("boolean")) {
                jPDADebugger.getIOManager().println(JPDADebugger.getLocString("CTL_Incorrect_condition") + ": " + JPDADebugger.getLocString("CTL_breakpoint_at") + " " + this.getDisplayName() + ".", 1);
            }
        }
        super.perform();
    }

    public void exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            boolean bl;
            boolean bl2;
            this.tryClass = ((ClassPrepareEvent)event).referenceType();
            String string = this.tryClass.name();
            if (string.equals(this.getClassName())) {
                bl2 = true;
            } else {
                String string2 = this.getClassName() + '$';
                boolean bl3 = bl2 = string.startsWith(string2) && !Character.isJavaIdentifierStart(string.charAt(string2.length()));
            }
            if (bl2 && (bl = this.set(this.tryClass)) && !this.getBreakpoint().isValid()) {
                this.setValid(true);
            }
            ((JPDADebugger)this.getDebugger()).operator.resume();
            return;
        }
        this.thread = ((ExceptionEvent)event).thread();
        this.exception = new ValueVariable((JPDADebugger)this.getDebugger(), "Exception", ((ExceptionEvent)event).exception().type().name(), ((ExceptionEvent)event).exception());
        this.perform();
    }

    public void stop(boolean bl) {
        ((JPDADebugger)this.getDebugger()).stop(bl, (AbstractThread)this.getThread());
    }

    public int getCatchType() {
        return this.catchType;
    }

    public void setCatchType(int n) {
        if (n == this.catchType) {
            return;
        }
        if ((n & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.catchType;
        this.catchType = n;
        this.firePropertyChange(PROP_CATCH_TYPE, new Integer(n2), new Integer(n));
    }

    public boolean set(ReferenceType referenceType) {
        JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
        if (jPDADebugger.virtualMachine == null || jPDADebugger.isDisconnected()) {
            return false;
        }
        ExceptionBreakpoint exceptionBreakpoint = this;
        synchronized (exceptionBreakpoint) {
            if (this.refTypesWithBreakpoint == null) {
                this.refTypesWithBreakpoint = new HashSet(17);
            } else {
                try {
                    if (this.refTypesWithBreakpoint.contains(referenceType)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
            }
            this.refTypesWithBreakpoint.add(referenceType);
        }
        try {
            ExceptionRequest exceptionRequest = jPDADebugger.requestManager.createExceptionRequest(referenceType, (1 & this.catchType) != 0, (2 & this.catchType) != 0);
            exceptionRequest.setSuspendPolicy(2);
            this.requestor.add(exceptionRequest);
            exceptionRequest.enable();
            return true;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (VMMismatchException vMMismatchException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "JPDAExceptionBreakpoint " + this.getClassName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

