/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ui.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorSupport;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.netbeans.modules.j2ee.impl.ServerInstanceData;
import org.netbeans.modules.j2ee.impl.ServerRegistryImpl;
import org.netbeans.modules.j2ee.impl.ServerUtilities;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.ui.ServerInstanceSelector;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class ServerInstancePropEditor
extends PropertyEditorSupport {
    private static final String DEFAULT_APP_SERVER = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_UseDefaultApp");
    private static final String DEFAULT_WEB_SERVER = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_UseDefaultWeb");
    private static final int MAX_SERVERS = 10;
    private PropertyChangeSupport propSupp = new PropertyChangeSupport(this);
    private DisplayData allInstances;
    private boolean canUseWebServer = true;
    private boolean canUseAppServer = true;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheetSettings;

    public ServerInstancePropEditor() {
    }

    public ServerInstancePropEditor(boolean bl, boolean bl2) {
        this();
        this.canUseWebServer = bl;
        this.canUseAppServer = bl2;
    }

    private void getAllInstances() {
        ServerInstance serverInstance;
        this.allInstances = new DisplayData();
        Server[] serverArray = ServerUtilities.getServers(this.canUseWebServer, this.canUseAppServer);
        if (serverArray == null || serverArray.length == 0) {
            return;
        }
        if (this.canUseAppServer) {
            serverInstance = ServerRegistryImpl.getRegistry().getDefaultAppInstance();
            if (serverInstance != null) {
                this.allInstances.add(DEFAULT_APP_SERVER, null);
            }
        } else {
            serverInstance = ServerRegistryImpl.getRegistry().getDefaultWebInstance();
            if (serverInstance != null) {
                this.allInstances.add(DEFAULT_WEB_SERVER, null);
            }
        }
        int n = 0;
        while (n < serverArray.length) {
            ServerInstance[] serverInstanceArray = serverArray[n].getServerInstances();
            if (serverInstanceArray != null && serverInstanceArray.length > 0) {
                int n2 = 0;
                while (n2 < serverInstanceArray.length) {
                    this.allInstances.add(serverInstanceArray[n2].getDisplayName(), serverInstanceArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.propSupp.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.propSupp.removePropertyChangeListener(propertyChangeListener);
    }

    public String getAsText() {
        if (!this.canUseWebServer && !this.canUseAppServer) {
            return null;
        }
        if (this.allInstances == null) {
            this.getAllInstances();
        }
        if (this.allInstances.size() == 0 || this.allInstances.size() > 10) {
            return null;
        }
        return this.getDisplayText();
    }

    private String getDisplayText() {
        ServerInstanceData serverInstanceData = (ServerInstanceData)this.getValue();
        String string = null;
        if (serverInstanceData == null || serverInstanceData.getInstanceID() == null) {
            string = this.canUseAppServer ? DEFAULT_APP_SERVER : DEFAULT_WEB_SERVER;
        } else {
            ServerInstance serverInstance = ServerUtilities.findServerInstance(serverInstanceData, this.canUseWebServer, this.canUseAppServer);
            if (serverInstance == null) {
                string = this.canUseAppServer ? DEFAULT_APP_SERVER : DEFAULT_WEB_SERVER;
            } else {
                string = serverInstance.getDisplayName();
                if (string == null || string.length() < 1) {
                    string = serverInstance.getID();
                }
            }
        }
        return string;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        FontMetrics fontMetrics;
        String string;
        if (this.allInstances == null || this.allInstances.size() == 0) {
            string = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_NoServerInstances");
            graphics.setColor(Color.red);
        } else {
            string = this.getDisplayText();
            fontMetrics = (PropertySheetSettings)SharedClassObject.findObject((Class)(class$org$openide$explorer$propertysheet$PropertySheetSettings == null ? (class$org$openide$explorer$propertysheet$PropertySheetSettings = ServerInstancePropEditor.class$("org.openide.explorer.propertysheet.PropertySheetSettings")) : class$org$openide$explorer$propertysheet$PropertySheetSettings), (boolean)true);
            graphics.setColor(fontMetrics.getValueColor());
        }
        fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, 4, (rectangle.height - fontMetrics.getHeight()) / 2 + 1 + fontMetrics.getMaxAscent());
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (this.allInstances == null || this.allInstances.size() == 0) {
            return;
        }
        ServerInstance serverInstance = this.allInstances.findServerInstance(string);
        if (serverInstance != null) {
            ServerInstanceData serverInstanceData = new ServerInstanceData(serverInstance.getServer().getID(), serverInstance.getID());
            this.setValue(serverInstanceData);
        } else {
            this.setValue(null);
        }
    }

    public boolean supportsCustomEditor() {
        return this.canUseWebServer || this.canUseAppServer;
    }

    public Component getCustomEditor() {
        if (this.allInstances == null) {
            this.getAllInstances();
        }
        if (this.allInstances.size() == 0 || this.allInstances.size() > 10) {
            String string = this.canUseWebServer ? (this.canUseAppServer ? NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_NoServers") : NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_NoWebServers")) : NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_NoAppServers");
            JOptionPane jOptionPane = new JOptionPane(string, 1);
            jOptionPane.setOptions(new Object[0]);
            return jOptionPane;
        }
        ServerInstanceSelector serverInstanceSelector = new ServerInstanceSelector(this.canUseWebServer, this.canUseAppServer);
        serverInstanceSelector.setServerInstance((ServerInstanceData)this.getValue());
        String string = this.canUseWebServer ? (this.canUseAppServer ? NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_SelectServer") : NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_SelectWebServer")) : NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_SelectAppServer");
        serverInstanceSelector.setText(string);
        serverInstanceSelector.setPropertyChangeSupport(this.propSupp);
        return serverInstanceSelector;
    }

    public String[] getTags() {
        if (!this.canUseWebServer && !this.canUseAppServer) {
            return null;
        }
        if (this.allInstances == null) {
            this.getAllInstances();
        }
        if (this.allInstances.size() == 0 || this.allInstances.size() > 10) {
            return null;
        }
        String[] stringArray = this.allInstances.getDisplayNames();
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DisplayData {
        private Vector displayNames = new Vector();
        private Vector instances = new Vector();

        DisplayData() {
        }

        void add(String string, ServerInstance serverInstance) {
            if (string == null || string.trim().length() == 0) {
                return;
            }
            this.displayNames.add(string);
            if (serverInstance == null) {
                this.instances.add(new Object());
            } else {
                this.instances.add(serverInstance);
            }
        }

        int size() {
            return this.displayNames.size();
        }

        String[] getDisplayNames() {
            Object[] objectArray = new String[this.displayNames.size()];
            this.displayNames.copyInto(objectArray);
            return objectArray;
        }

        ServerInstance findServerInstance(String string) {
            int n = this.displayNames.indexOf(string);
            Object e = this.instances.get(n);
            if (e instanceof ServerInstance) {
                return (ServerInstance)e;
            }
            return null;
        }
    }
}

