/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.impl;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.ServiceType;
import org.openide.TopManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerTask;
import org.openide.cookies.ArgumentsCookie;
import org.openide.cookies.CompilerCookie;
import org.openide.cookies.DebuggerCookie;
import org.openide.cookies.ExecCookie;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerType;
import org.openide.execution.Executor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExecSupport
implements ExecCookie,
ArgumentsCookie,
DebuggerCookie {
    private static final String EA_EXECUTOR = "NetBeansAttrExecutor";
    private static final String EA_ARGUMENTS = "NetBeansAttrArguments";
    private static final String EA_DEBUGGER_TYPE = "NetBeansAttrDebuggerType";
    public static final String PROP_FILE_PARAMS = "params";
    public static final String PROP_EXECUTION = "execution";
    public static final String PROP_DEBUGGER_TYPE = "debuggerType";
    static ResourceBundle bundle;
    protected MultiDataObject.Entry entry;
    private DataObject dobj;
    private boolean isReadOnly = false;
    static /* synthetic */ Class class$org$openide$execution$Executor;
    static /* synthetic */ Class class$org$openide$debugger$DebuggerType;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$loaders$ExecSupport;

    public ExecSupport(MultiDataObject.Entry entry) {
        this(entry.getFile());
        this.entry = entry;
    }

    public ExecSupport(DataObject dataObject) {
        this(dataObject.getPrimaryFile());
        this.dobj = dataObject;
    }

    protected ExecSupport(FileObject fileObject) {
        this.isReadOnly = fileObject.isReadOnly();
    }

    protected FileObject getFile() {
        return this.entry != null ? this.entry.getFile() : this.dobj.getPrimaryFile();
    }

    protected DataObject getDataObject() {
        return this.entry != null ? this.entry.getDataObject() : this.dobj;
    }

    public void start() {
        Executor executor = ExecSupport.getExecutor(this.getFile());
        if (executor == null) {
            executor = this.defaultExecutor();
        }
        try {
            executor.execute(this.getDataObject());
        }
        catch (IOException iOException) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (ExecSupport.this.startFailed(iOException)) {
                        ExecSupport.this.start();
                    }
                }
            });
        }
    }

    public void debug(final boolean bl) throws DebuggerException {
        DebuggerType debuggerType = ExecSupport.getDebuggerType(this.getFile());
        if (debuggerType == null) {
            debuggerType = this.defaultDebuggerType();
        }
        try {
            debuggerType.startDebugger(this.getDataObject(), bl);
            return;
        }
        catch (DebuggerException debuggerException) {
            try {
                Mutex.EVENT.readAccess(new Mutex.ExceptionAction(){

                    public Object run() throws DebuggerException {
                        if (ExecSupport.this.debugFailed(debuggerException)) {
                            ExecSupport.this.debug(bl);
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mutexException) {
                throw (DebuggerException)((Object)mutexException.getException());
            }
            return;
        }
    }

    protected boolean startFailed(IOException iOException) {
        Executor executor = (Executor)ExecSupport.choose((ServiceType)ExecSupport.getExecutor(this.getFile()), class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor, iOException);
        if (executor == null) {
            return false;
        }
        try {
            ExecSupport.setExecutor(this.getFile(), executor);
            return true;
        }
        catch (IOException iOException2) {
            return false;
        }
    }

    protected boolean debugFailed(DebuggerException debuggerException) {
        DebuggerType debuggerType = (DebuggerType)ExecSupport.choose((ServiceType)ExecSupport.getDebuggerType(this.getFile()), class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType, (Exception)((Object)debuggerException));
        if (debuggerType == null) {
            return false;
        }
        try {
            ExecSupport.setDebuggerType(this.getFile(), debuggerType);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected boolean checkCompiled() {
        CompilerCookie compilerCookie = (CompilerCookie)this.getDataObject().getCookie(class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = ExecSupport.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie);
        if (compilerCookie != null) {
            CompilerJob compilerJob = new CompilerJob(Compiler.DEPTH_ZERO);
            compilerJob.setDisplayName(this.getDataObject().getName());
            compilerCookie.addToJob(compilerJob, Compiler.DEPTH_ZERO);
            if (!compilerJob.isUpToDate()) {
                CompilerTask compilerTask = compilerJob.start();
                return compilerTask.isSuccessful();
            }
        }
        return true;
    }

    protected DebuggerType defaultDebuggerType() {
        return DebuggerType.getDefault();
    }

    protected Executor defaultExecutor() {
        return Executor.getDefault();
    }

    public static void setExecutor(MultiDataObject.Entry entry, Executor executor) throws IOException {
        ExecSupport.setExecutor(entry.getFile(), executor);
    }

    public static void setExecutor(FileObject fileObject, Executor executor) throws IOException {
        fileObject.setAttribute(EA_EXECUTOR, (Object)(executor == null ? null : new ServiceType.Handle((ServiceType)executor)));
    }

    public static Executor getExecutor(MultiDataObject.Entry entry) {
        return ExecSupport.getExecutor(entry.getFile());
    }

    public static Executor getExecutor(FileObject fileObject) {
        Object object = fileObject.getAttribute(EA_EXECUTOR);
        if (object != null && object instanceof ServiceType.Handle) {
            try {
                ServiceType serviceType = ((ServiceType.Handle)object).getServiceType();
                if (serviceType instanceof Executor) {
                    return (Executor)serviceType;
                }
            }
            catch (Exception exception) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
                return null;
            }
        }
        return null;
    }

    public void setArguments(String[] stringArray) throws IOException {
        this.getFile().setAttribute(EA_ARGUMENTS, (Object)stringArray);
    }

    public static void setArguments(MultiDataObject.Entry entry, String[] stringArray) throws IOException {
        ExecSupport.setArguments(entry.getFile(), stringArray);
    }

    public static void setArguments(FileObject fileObject, String[] stringArray) throws IOException {
        fileObject.setAttribute(EA_ARGUMENTS, (Object)stringArray);
    }

    public String[] getArguments() {
        return ExecSupport.getArguments(this.getFile());
    }

    public static String[] getArguments(MultiDataObject.Entry entry) {
        return ExecSupport.getArguments(entry.getFile());
    }

    public static String[] getArguments(FileObject fileObject) {
        Object object = fileObject.getAttribute(EA_ARGUMENTS);
        if (object != null && object instanceof String[]) {
            return (String[])object;
        }
        return new String[0];
    }

    public static void setDebuggerType(MultiDataObject.Entry entry, DebuggerType debuggerType) throws IOException {
        ExecSupport.setDebuggerType(entry.getFile(), debuggerType);
    }

    public static void setDebuggerType(FileObject fileObject, DebuggerType debuggerType) throws IOException {
        fileObject.setAttribute(EA_DEBUGGER_TYPE, (Object)(debuggerType == null ? null : new ServiceType.Handle((ServiceType)debuggerType)));
    }

    public static DebuggerType getDebuggerType(MultiDataObject.Entry entry) {
        return ExecSupport.getDebuggerType(entry.getFile());
    }

    public static DebuggerType getDebuggerType(FileObject fileObject) {
        ServiceType serviceType;
        Object object = fileObject.getAttribute(EA_DEBUGGER_TYPE);
        if (object != null && object instanceof ServiceType.Handle && (serviceType = ((ServiceType.Handle)object).getServiceType()) instanceof DebuggerType) {
            return (DebuggerType)serviceType;
        }
        return null;
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createParamsProperty());
        set.put((Node.Property)this.createExecutorProperty());
        set.put((Node.Property)this.createDebuggerProperty());
    }

    private PropertySupport createParamsProperty() {
        return new PropertySupport.ReadWrite(PROP_FILE_PARAMS, class$java$lang$String == null ? (class$java$lang$String = ExecSupport.class$("java.lang.String")) : class$java$lang$String, ExecSupport.getString("PROP_fileParams"), ExecSupport.getString("HINT_fileParams")){

            public Object getValue() {
                String[] stringArray = ExecSupport.this.getArguments();
                return Utilities.escapeParameters((String[])stringArray);
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String) {
                    try {
                        ExecSupport.this.setArguments(Utilities.parseParameters((String)((String)object)));
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    ExecSupport.this.setArguments(null);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean canWrite() {
                return !ExecSupport.this.getFile().isReadOnly();
            }
        };
    }

    private PropertySupport createExecutorProperty() {
        return new PropertySupport.ReadWrite(PROP_EXECUTION, class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor, ExecSupport.getString("PROP_execution"), ExecSupport.getString("HINT_execution")){

            public Object getValue() {
                Executor executor = ExecSupport.getExecutor(ExecSupport.this.getFile());
                if (executor == null) {
                    return ExecSupport.this.defaultExecutor();
                }
                return executor;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    ExecSupport.setExecutor(ExecSupport.this.getFile(), (Executor)object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !ExecSupport.this.getFile().isReadOnly();
            }
        };
    }

    private PropertySupport createDebuggerProperty() {
        return new PropertySupport.ReadWrite(PROP_DEBUGGER_TYPE, class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType, ExecSupport.getString("PROP_debuggerType"), ExecSupport.getString("HINT_debuggerType")){

            public Object getValue() {
                DebuggerType debuggerType = ExecSupport.getDebuggerType(ExecSupport.this.getFile());
                if (debuggerType == null) {
                    return ExecSupport.this.defaultDebuggerType();
                }
                return debuggerType;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    ExecSupport.setDebuggerType(ExecSupport.this.getFile(), (DebuggerType)object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !ExecSupport.this.getFile().isReadOnly();
            }
        };
    }

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$openide$loaders$ExecSupport == null ? (class$org$openide$loaders$ExecSupport = ExecSupport.class$("org.openide.loaders.ExecSupport")) : class$org$openide$loaders$ExecSupport));
        }
        return bundle.getString(string);
    }

    private static ServiceType choose(ServiceType serviceType, Class clazz, Exception exception) {
        TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
        if (propertyEditor == null) {
            return null;
        }
        propertyEditor.setValue(serviceType);
        Component component = propertyEditor.getCustomEditor();
        if (component == null) {
            return null;
        }
        String string = NbBundle.getBundle((Class)(class$org$openide$loaders$ExecSupport == null ? (class$org$openide$loaders$ExecSupport = ExecSupport.class$("org.openide.loaders.ExecSupport")) : class$org$openide$loaders$ExecSupport)).getString("CTL_ServiceConfigure");
        NotifyDescriptor.Exception exception2 = new NotifyDescriptor.Exception((Throwable)exception);
        exception2.setTitle(NbBundle.getBundle((Class)(class$org$openide$loaders$ExecSupport == null ? (class$org$openide$loaders$ExecSupport = ExecSupport.class$("org.openide.loaders.ExecSupport")) : class$org$openide$loaders$ExecSupport)).getString("CTL_Service_Configuration_Title"));
        exception2.setMessage((Object)exception.getLocalizedMessage());
        exception2.setOptions(new Object[]{string, NotifyDescriptor.CANCEL_OPTION});
        Object object = TopManager.getDefault().notify((NotifyDescriptor)exception2);
        if (!string.equals(object)) {
            return null;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)component, ExecSupport.getString("MSG_ConfigureService"));
        dialogDescriptor.setOptions(new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION});
        Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
            return (ServiceType)propertyEditor.getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

