/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.jpda.RemoteDebuggerInfo;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.j2ee.impl.DefaultExecPerformer;
import org.netbeans.modules.j2ee.impl.ProgressObject;
import org.netbeans.modules.j2ee.server.DebugInfo;
import org.netbeans.modules.j2ee.server.ServerEvent;
import org.netbeans.modules.j2ee.server.ServerException;
import org.netbeans.modules.j2ee.server.ServerExecution;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.ServerListener;
import org.netbeans.modules.j2ee.server.ServerOutput;
import org.netbeans.modules.j2ee.server.ServerStatus;
import org.openide.TopManager;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.execution.ExecutorTask;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class DefaultServerInstanceManager
implements TaskListener,
ServerListener {
    private static boolean debug = false;
    protected static Map serverInstanceManagerMap = null;
    protected ServerInstance serverInstance = null;
    protected ServerExecution serverExecution = null;
    protected CopyMaker[] copyMakers = null;
    protected ExecutorTask executorTask = null;
    protected InputStream[] inputStreams = null;
    protected BufferedReader[] inputStreamReaders = null;
    protected DefaultExecPerformer defaultExecPerformer = null;

    protected static ExecutorTask serverInstanceStartExecution(ServerInstance serverInstance, boolean bl, DefaultExecPerformer defaultExecPerformer) {
        DefaultServerInstanceManager.prepareServerInstanceManagerMap(serverInstance);
        DefaultServerInstanceManager defaultServerInstanceManager = (DefaultServerInstanceManager)serverInstanceManagerMap.get(serverInstance);
        defaultServerInstanceManager.setDefaultExecPerformer(defaultExecPerformer);
        return defaultServerInstanceManager.startExecution(bl);
    }

    protected static ExecutorTask serverInstanceDeployment(ServerInstance serverInstance, DefaultExecPerformer defaultExecPerformer) {
        DefaultServerInstanceManager.prepareServerInstanceManagerMap(serverInstance);
        DefaultServerInstanceManager defaultServerInstanceManager = (DefaultServerInstanceManager)serverInstanceManagerMap.get(serverInstance);
        defaultServerInstanceManager.setDefaultExecPerformer(defaultExecPerformer);
        return defaultServerInstanceManager.startDeployment();
    }

    protected static void serverInstanceStartDebugging(ServerInstance serverInstance, boolean bl, DefaultExecPerformer defaultExecPerformer) {
        DefaultServerInstanceManager.prepareServerInstanceManagerMap(serverInstance);
        DefaultServerInstanceManager defaultServerInstanceManager = (DefaultServerInstanceManager)serverInstanceManagerMap.get(serverInstance);
        defaultServerInstanceManager.setDefaultExecPerformer(defaultExecPerformer);
        defaultServerInstanceManager.startDebugger(bl);
    }

    protected static void prepareServerInstanceManagerMap(ServerInstance serverInstance) {
        if (serverInstanceManagerMap == null) {
            serverInstanceManagerMap = new HashMap(5);
        }
        if (serverInstanceManagerMap.get(serverInstance) == null) {
            serverInstanceManagerMap.put(serverInstance, new DefaultServerInstanceManager(serverInstance));
        }
    }

    protected DefaultServerInstanceManager(ServerInstance serverInstance) {
        this.serverInstance = serverInstance;
        this.serverExecution = serverInstance.getTestRunSupport();
    }

    protected void setDefaultExecPerformer(DefaultExecPerformer defaultExecPerformer) {
        this.defaultExecPerformer = defaultExecPerformer;
    }

    protected ExecutorTask startExecution(boolean bl) {
        try {
            this.serverExecution.setDebug(false);
            this.defaultExecPerformer.modulesRegistration(bl);
            ProgressObject progressObject = new ProgressObject();
            this.serverExecution.synchronize(progressObject);
            progressObject.finished();
            this.createExecutorTask();
            this.clearCopyMaker();
            this.createCopyMaker(null);
        }
        catch (ServerException serverException) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)serverException);
        }
        this.defaultExecPerformer.startBrowser();
        return this.executorTask;
    }

    protected ExecutorTask startDeployment() {
        try {
            this.serverExecution.setDebug(false);
            ProgressObject progressObject = new ProgressObject();
            this.defaultExecPerformer.modulesDeployment(progressObject);
            progressObject.finished();
            this.createExecutorTask();
            this.clearCopyMaker();
            this.createCopyMaker(null);
        }
        catch (ServerException serverException) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)serverException);
        }
        return this.executorTask;
    }

    protected void startDebugger(boolean bl) {
        try {
            this.serverExecution.setDebug(true);
            this.defaultExecPerformer.modulesRegistration(true);
            ProgressObject progressObject = new ProgressObject();
            this.serverExecution.synchronize(progressObject);
            progressObject.finished();
            DebugInfo debugInfo = this.serverExecution.getDebugInfo();
            DebuggerInfo debuggerInfo = this.getDebuggerInfo(debugInfo);
            Debugger debugger = TopManager.getDefault().getDebugger();
            int n = 1;
            while (n < 11) {
                try {
                    debugger.startDebugger(debuggerInfo);
                    break;
                }
                catch (DebuggerException debuggerException) {
                    try {
                        Thread.sleep(100 * n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (n == 10) {
                        throw debuggerException;
                    }
                    ++n;
                }
            }
            this.clearCopyMaker();
            this.createCopyMaker((JavaDebugger)((CoreDebugger)debugger).getCurrentDebugger());
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
        }
        this.defaultExecPerformer.startBrowser();
    }

    protected DebuggerInfo getDebuggerInfo(DebugInfo debugInfo) {
        if (debugInfo instanceof DebugInfo.SocketDebugInfo) {
            return new RemoteDebuggerInfo(((DebugInfo.SocketDebugInfo)debugInfo).getHost(), ((DebugInfo.SocketDebugInfo)debugInfo).getPort());
        }
        if (debugInfo instanceof DebugInfo.SharedMemoryDebugInfo) {
            return new RemoteDebuggerInfo(((DebugInfo.SharedMemoryDebugInfo)debugInfo).getAdress());
        }
        return null;
    }

    protected synchronized void createExecutorTask() {
        try {
            if (this.executorTask == null) {
                this.executorTask = TopManager.getDefault().getExecutionEngine().execute(this.serverInstance.getDisplayName(), (Runnable)new EmptyThread(), null);
                this.executorTask.addTaskListener((TaskListener)this);
                this.serverInstance.addServerChangeListener(this);
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
        }
    }

    public synchronized void taskFinished(Task task) {
        if (this.executorTask != null) {
            task.removeTaskListener((TaskListener)this);
            this.serverInstance.removeServerChangeListener(this);
            try {
                this.serverExecution.stopExecution();
            }
            catch (ServerException serverException) {
                // empty catch block
            }
            this.executorTask.stop();
            this.clearCopyMaker();
            this.executorTask = null;
        }
    }

    public synchronized void serverStatusChanged(ServerEvent serverEvent) {
        if (serverEvent.getServerInstance().equals(this.serverInstance) && serverEvent.getServerStatus().equals(ServerStatus.STATUS_STOPPED) && this.executorTask != null) {
            this.executorTask.removeTaskListener((TaskListener)this);
            this.serverInstance.removeServerChangeListener(this);
            this.executorTask.stop();
            this.clearCopyMaker();
            this.executorTask = null;
        }
    }

    protected void createCopyMaker(JavaDebugger javaDebugger) {
        try {
            ServerOutput[] serverOutputArray = this.serverExecution.getServerOutput();
            if (this.copyMakers == null) {
                this.copyMakers = new CopyMaker[serverOutputArray.length];
                this.inputStreams = new InputStream[serverOutputArray.length];
                this.inputStreamReaders = new BufferedReader[serverOutputArray.length];
            }
            int n = 0;
            while (n < this.copyMakers.length) {
                if (this.copyMakers[n] == null && serverOutputArray[n] != null) {
                    InputStream inputStream = serverOutputArray[n].getStream();
                    if (this.inputStreams[n] == null || this.inputStreams[n] != inputStream) {
                        this.inputStreamReaders[n] = new BufferedReader(new InputStreamReader(inputStream));
                    }
                    this.inputStreams[n] = inputStream;
                    this.copyMakers[n] = javaDebugger == null ? new ExecCopyMaker(this.inputStreamReaders[n], (Writer)this.executorTask.getInputOutput().getOut(), false) : new DebugCopyMaker(this.inputStreamReaders[n], (Debugger)javaDebugger, false);
                    this.copyMakers[n].start();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
        }
    }

    protected void clearCopyMaker() {
        if (this.copyMakers != null) {
            int n = 0;
            while (n < this.copyMakers.length) {
                if (this.copyMakers[n] != null) {
                    this.copyMakers[n].finishThread();
                    this.copyMakers[n].interrupt();
                    this.copyMakers[n] = null;
                }
                ++n;
            }
            this.copyMakers = null;
        }
    }

    protected class EmptyThread
    extends Thread {
        protected EmptyThread() {
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    protected class DebugCopyMaker
    extends CopyMaker {
        Debugger debugger = null;

        public DebugCopyMaker(BufferedReader bufferedReader, Debugger debugger, boolean bl) {
            super(bufferedReader, bl);
            this.debugger = debugger;
        }

        void writeString(String string) throws Exception {
            ((JavaDebugger)this.debugger).getIOManager().println(string, 2);
            if (this.stop) {
                throw new Exception();
            }
        }
    }

    protected class ExecCopyMaker
    extends CopyMaker {
        Writer or = null;

        public ExecCopyMaker(BufferedReader bufferedReader, Writer writer, boolean bl) {
            super(bufferedReader, bl);
            this.or = writer;
        }

        void writeString(String string) throws Exception {
            this.or.write(string);
            if (this.stop) {
                throw new Exception();
            }
            this.or.write(System.getProperty("line.separator"));
            if (this.autoflush) {
                this.or.flush();
            }
        }
    }

    protected abstract class CopyMaker
    extends Thread {
        BufferedReader ir = null;
        boolean stop = false;
        boolean autoflush;

        public CopyMaker(BufferedReader bufferedReader, boolean bl) {
            super("CopyMaker");
            this.ir = bufferedReader;
            this.autoflush = bl;
        }

        public void finishThread() {
            this.stop = true;
        }

        public void run() {
            block3: {
                try {
                    String string;
                    while ((string = this.ir.readLine()) != null) {
                        this.writeString(string);
                    }
                }
                catch (Exception exception) {
                    if (!debug) break block3;
                    exception.printStackTrace();
                }
            }
        }

        abstract void writeString(String var1) throws Exception;
    }
}

