/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.BExtent;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.Line;
import org.netbeans.lib.terminalemulator.LineVisitor;
import org.netbeans.lib.terminalemulator.State;
import org.netbeans.lib.terminalemulator.Term;

class Sel
implements ClipboardOwner {
    private static final int SEL_NONE = 0;
    private static final int SEL_CHAR = 1;
    private static final int SEL_WORD = 2;
    private static final int SEL_LINE = 3;
    public static final int INT_NONE = 0;
    public static final int INT_ABOVE = 1;
    public static final int INT_ON = 2;
    public static final int INT_STRADDLES = 3;
    public static final int INT_BELOW = 4;
    private int sel_tracking;
    private int old_sel_tracking;
    private Coord sel_origin;
    public Coord sel_extent;
    private Extent initial_word;
    private Term term;
    private State state;
    private Color color = Color.white;
    private Color swing_color = new Color(204, 204, 255);

    void setColor(Color color) {
        this.color = color;
    }

    Color getColor() {
        return this.color;
    }

    Sel(Term term, State state) {
        this.term = term;
        this.state = state;
    }

    void adjust(int n, int n2) {
        if (this.sel_origin == null) {
            return;
        }
        this.sel_origin.row += n2;
        if (this.sel_origin.row < n) {
            this.sel_origin.row = n;
        }
        this.sel_extent.row += n2;
        if (this.sel_extent.row < n) {
            this.sel_origin = null;
            this.sel_extent = null;
        }
        this.term.fireSelectionExtentChanged();
    }

    void relocate(int n, int n2) {
        if (this.sel_origin == null) {
            return;
        }
        int n3 = n2 - n;
        this.sel_origin.row += n3;
        this.sel_extent.row += n3;
    }

    Extent getExtent() {
        if (this.sel_origin == null) {
            return null;
        }
        Extent extent = new Extent(this.sel_origin, this.sel_extent);
        extent.order();
        return extent;
    }

    void setExtent(Extent extent) {
        this.cancel(false);
        extent.order();
        this.sel_origin = (Coord)extent.begin.clone();
        this.sel_extent = (Coord)extent.end.clone();
        this.done(false);
    }

    public void select_word(Extent extent) {
        this.sel_origin = new Coord(extent.begin);
        this.sel_extent = new Coord(extent.end);
        this.sel_tracking = 2;
        this.old_sel_tracking = 0;
        this.initial_word = extent;
    }

    public void select_line(Coord coord) {
        this.sel_origin = Coord.make(coord.row, 0);
        this.sel_extent = Coord.make(coord.row, this.term.buf.totalCols());
        this.sel_tracking = 3;
        this.old_sel_tracking = 0;
    }

    private boolean extend_work(Coord coord, int n) {
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            this.sel_extent = coord;
        } else if (n == 2) {
            BExtent bExtent = this.term.buf.find_word(this.term.word_delineator, coord.toBCoord(this.term.firsta));
            Extent extent = bExtent.toExtent(this.term.firsta);
            if (coord.compareTo(this.initial_word.begin) < 0) {
                this.sel_origin = new Coord(extent.begin);
                this.sel_extent = this.initial_word.end;
            } else if (coord.compareTo(this.initial_word.end) > 0) {
                this.sel_origin = this.initial_word.begin;
                this.sel_extent = new Coord(extent.end);
            } else {
                this.sel_origin = this.initial_word.begin;
                this.sel_extent = this.initial_word.end;
            }
        } else if (n == 3) {
            if (coord.compareTo(this.sel_origin) > 0) {
                this.sel_origin = Coord.make(this.sel_origin.row, 0);
                this.sel_extent = Coord.make(coord.row, this.term.buf.totalCols());
            } else {
                this.sel_origin = Coord.make(this.sel_origin.row, this.term.buf.totalCols());
                this.sel_extent = Coord.make(coord.row, 0);
            }
        }
        return true;
    }

    public void track(Coord coord) {
        if (this.sel_tracking == 0) {
            this.sel_origin = coord;
            this.sel_extent = coord;
            this.sel_tracking = 1;
            this.old_sel_tracking = 0;
        }
        this.extend_work(coord, this.sel_tracking);
    }

    public boolean extend(Coord coord) {
        if (this.sel_origin == null) {
            return false;
        }
        return this.extend_work(coord, this.old_sel_tracking);
    }

    public boolean cancel(boolean bl) {
        if (this.sel_origin == null) {
            return false;
        }
        this.old_sel_tracking = 0;
        this.sel_tracking = 0;
        this.sel_origin = null;
        this.sel_extent = null;
        this.initial_word = null;
        if (bl) {
            this.term.fireSelectionExtentChanged();
        }
        return true;
    }

    public void done(boolean bl) {
        this.old_sel_tracking = this.sel_tracking;
        this.sel_tracking = 0;
        if (bl || this.term.isAutoCopy()) {
            this.term.copy();
        }
        this.term.fireSelectionExtentChanged();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        if (this.cancel(true)) {
            this.term.repaint(false);
        }
    }

    public String getSelection() {
        Extent extent = this.getExtent();
        if (extent == null) {
            return null;
        }
        final StringBuffer stringBuffer = new StringBuffer();
        this.term.visitLines(extent.begin, extent.end, true, new LineVisitor(){

            public boolean visit(Line line, int n, int n2, int n3) {
                stringBuffer.append(line.text(n2, n3));
                return true;
            }
        });
        return stringBuffer.toString();
    }

    int intersection(int n) {
        if (this.sel_origin == null) {
            return 0;
        }
        if (this.sel_extent.row < n) {
            return 1;
        }
        if (this.sel_extent.row == n) {
            return 2;
        }
        if (this.sel_origin.row > n) {
            return 4;
        }
        return 3;
    }

    private void paint(Graphics graphics, int n, int n2, int n3) {
        if (n < this.state.firstx) {
            return;
        }
        if (n > this.state.firstx + this.state.rows) {
            return;
        }
        BCoord bCoord = new BCoord(n, n2);
        BCoord bCoord2 = new BCoord(n, n3);
        bCoord = this.term.toViewCoord(bCoord);
        bCoord2 = this.term.toViewCoord(bCoord2);
        Point point = this.term.toPixel(bCoord);
        Point point2 = this.term.toPixel(bCoord2);
        point2.y += this.term.metrics.height;
        point2.x += this.term.metrics.width;
        Dimension dimension = new Dimension(point2.x - point.x, point2.y - point.y);
        Rectangle rectangle = new Rectangle(point, dimension);
        if (this.term.selection_xor) {
            graphics.setXORMode(this.color);
        } else {
            graphics.setColor(this.swing_color);
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void paint(final Graphics graphics) {
        Extent extent = this.getExtent();
        if (extent == null) {
            return;
        }
        extent.order();
        this.term.visitLines(extent.begin, extent.end, true, new LineVisitor(){

            public boolean visit(Line line, int n, int n2, int n3) {
                Sel.this.paint(graphics, n, n2, n3);
                return true;
            }
        });
    }
}

