/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.modules.image.ImageDataObject;
import org.netbeans.modules.image.ImageOpenSupport;
import org.netbeans.modules.image.NBImageIcon;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class ImageViewer
extends CloneableTopComponent {
    static final long serialVersionUID = 6960127954234034486L;
    private ImageDataObject storedObject;
    private NBImageIcon storedImage;
    private JPanel panel;
    private double scale = 1.0;
    private boolean showGrid = false;
    private final double changeFactor = Math.sqrt(2.0);
    private final Color gridColor = Color.black;
    private PropertyChangeListener nameChangeL;
    static /* synthetic */ Class class$org$netbeans$modules$image$ImageViewer;
    static /* synthetic */ Class class$org$netbeans$modules$image$ZoomOutAction;
    static /* synthetic */ Class class$org$netbeans$modules$image$ZoomInAction;
    static /* synthetic */ Class class$org$netbeans$modules$image$CustomZoomAction;
    static /* synthetic */ Class class$org$netbeans$modules$image$ImageOpenSupport;

    public ImageViewer() {
    }

    public ImageViewer(ImageDataObject imageDataObject) {
        super((DataObject)imageDataObject);
        this.initialize(imageDataObject);
    }

    protected void reloadIcon(NBImageIcon nBImageIcon) {
        this.storedImage = nBImageIcon;
        this.resizePanel();
        this.panel.repaint();
    }

    private void initialize(ImageDataObject imageDataObject) {
        this.storedObject = imageDataObject;
        this.storedImage = new NBImageIcon(this.storedObject);
        this.panel = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.drawImage(ImageViewer.this.storedImage.getImage(), 0, 0, (int)((double)ImageViewer.this.storedImage.getIconWidth() * ImageViewer.this.getScale()), (int)((double)ImageViewer.this.storedImage.getIconHeight() * ImageViewer.this.getScale()), 0, 0, ImageViewer.this.storedImage.getIconWidth(), ImageViewer.this.storedImage.getIconHeight(), this);
                if (ImageViewer.this.showGrid) {
                    int n = (int)((double)ImageViewer.this.storedImage.getIconWidth() * ImageViewer.this.getScale());
                    int n2 = (int)((double)ImageViewer.this.storedImage.getIconHeight() * ImageViewer.this.getScale());
                    double d = ImageViewer.this.getScale();
                    if (d < 2.0) {
                        return;
                    }
                    graphics.setColor(ImageViewer.this.gridColor);
                    double d2 = d;
                    int n3 = (int)d2;
                    while (n3 < n) {
                        graphics.drawLine(n3, 0, n3, n2 - 1);
                        n3 = (int)(d2 += d);
                    }
                    d2 = d;
                    int n4 = (int)d2;
                    while (n4 < n2) {
                        graphics.drawLine(0, n4, n - 1, n4);
                        n4 = (int)(d2 += d);
                    }
                }
            }
        };
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_ImageViewer"));
        this.storedImage.setImageObserver(this.panel);
        this.panel.setPreferredSize(new Dimension(this.storedImage.getIconWidth(), this.storedImage.getIconHeight()));
        JScrollPane jScrollPane = new JScrollPane(this.panel);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add(jScrollPane, "Center");
        ((Container)((Object)this)).add(this.createToolBar(), "North");
        this.nameChangeL = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("cookie".equals(propertyChangeEvent.getPropertyName()) || "name".equals(propertyChangeEvent.getPropertyName())) {
                    ImageViewer.this.updateName();
                }
            }
        };
        imageDataObject.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.nameChangeL, (Object)((Object)imageDataObject)));
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACSN_Toolbar"));
        jToolBar.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACSD_Toolbar"));
        JButton jButton = new JButton((Action)SystemAction.get((Class)(class$org$netbeans$modules$image$ZoomOutAction == null ? (class$org$netbeans$modules$image$ZoomOutAction = ImageViewer.class$("org.netbeans.modules.image.ZoomOutAction")) : class$org$netbeans$modules$image$ZoomOutAction)));
        jButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_Out_BTN_Mnem").charAt(0));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACSD_Out_BTN"));
        jButton.setLabel("");
        jToolBar.add(jButton);
        jToolBar.addSeparator(new Dimension(2, 2));
        JButton jButton2 = new JButton((Action)SystemAction.get((Class)(class$org$netbeans$modules$image$ZoomInAction == null ? (class$org$netbeans$modules$image$ZoomInAction = ImageViewer.class$("org.netbeans.modules.image.ZoomInAction")) : class$org$netbeans$modules$image$ZoomInAction)));
        jButton2.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_In_BTN_Mnem").charAt(0));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACSD_In_BTN"));
        jButton2.setLabel("");
        jToolBar.add(jButton2);
        jToolBar.addSeparator(new Dimension(11, 2));
        jToolBar.add(this.getZoomButton(1, 1));
        jToolBar.addSeparator(new Dimension(11, 2));
        jToolBar.add(this.getZoomButton(1, 3));
        jToolBar.addSeparator(new Dimension(2, 2));
        jToolBar.add(this.getZoomButton(1, 5));
        jToolBar.addSeparator(new Dimension(2, 2));
        jToolBar.add(this.getZoomButton(1, 7));
        jToolBar.addSeparator(new Dimension(11, 2));
        jToolBar.add(this.getZoomButton(3, 1));
        jToolBar.addSeparator(new Dimension(2, 2));
        jToolBar.add(this.getZoomButton(5, 1));
        jToolBar.addSeparator(new Dimension(2, 2));
        jToolBar.add(this.getZoomButton(7, 1));
        jToolBar.addSeparator(new Dimension(11, 2));
        jToolBar.add((Action)SystemAction.get((Class)(class$org$netbeans$modules$image$CustomZoomAction == null ? (class$org$netbeans$modules$image$CustomZoomAction = ImageViewer.class$("org.netbeans.modules.image.CustomZoomAction")) : class$org$netbeans$modules$image$CustomZoomAction)));
        jToolBar.addSeparator(new Dimension(11, 2));
        jToolBar.add(this.getGridButton());
        return jToolBar;
    }

    private void updateName() {
        String string = this.storedObject.getNodeDelegate().getDisplayName();
        this.setName(string);
        FileObject fileObject = this.storedObject.getPrimaryFile();
        StringBuffer stringBuffer = new StringBuffer(fileObject.getPackageName('.'));
        String string2 = fileObject.getExt();
        if (string2.length() > 0) {
            stringBuffer.append(" [");
            stringBuffer.append(string2);
            stringBuffer.append(']');
        }
        ((JComponent)((Object)this)).setToolTipText(stringBuffer.toString());
    }

    public void open(Workspace workspace) {
        Mode mode;
        Workspace workspace2 = workspace == null ? TopManager.getDefault().getWindowManager().getCurrentWorkspace() : workspace;
        Mode mode2 = workspace2.findMode((TopComponent)this);
        if (mode2 == null && (mode = workspace2.findMode("editor")) != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open(workspace);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.storedObject);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.storedObject = (ImageDataObject)((Object)objectInput.readObject());
        ((ImageOpenSupport)this.storedObject.getCookie(class$org$netbeans$modules$image$ImageOpenSupport == null ? (class$org$netbeans$modules$image$ImageOpenSupport = ImageViewer.class$("org.netbeans.modules.image.ImageOpenSupport")) : class$org$netbeans$modules$image$ImageOpenSupport)).prepareViewer();
        this.initialize(this.storedObject);
    }

    protected CloneableTopComponent createClonedObject() {
        return new ImageViewer(this.storedObject);
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] systemActionArray = super.getSystemActions();
        return SystemAction.linkActions((SystemAction[])new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$image$ZoomInAction == null ? (class$org$netbeans$modules$image$ZoomInAction = ImageViewer.class$("org.netbeans.modules.image.ZoomInAction")) : class$org$netbeans$modules$image$ZoomInAction)), SystemAction.get((Class)(class$org$netbeans$modules$image$ZoomOutAction == null ? (class$org$netbeans$modules$image$ZoomOutAction = ImageViewer.class$("org.netbeans.modules.image.ZoomOutAction")) : class$org$netbeans$modules$image$ZoomOutAction)), SystemAction.get((Class)(class$org$netbeans$modules$image$CustomZoomAction == null ? (class$org$netbeans$modules$image$CustomZoomAction = ImageViewer.class$("org.netbeans.modules.image.CustomZoomAction")) : class$org$netbeans$modules$image$CustomZoomAction)), null}, (SystemAction[])systemActionArray);
    }

    public Image getIcon() {
        return Utilities.loadImage((String)"/org/netbeans/modules/image/imageObject.gif");
    }

    public void zoomIn() {
        this.scaleIn();
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    public void zoomOut() {
        double d = this.scale;
        this.scaleOut();
        if (!this.isNewSizeOK()) {
            this.scale = d;
            return;
        }
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    private void resizePanel() {
        this.panel.setPreferredSize(new Dimension((int)((double)this.storedImage.getIconWidth() * this.getScale()), (int)((double)this.storedImage.getIconWidth() * this.getScale())));
        this.panel.revalidate();
    }

    private boolean isNewSizeOK() {
        return (double)this.storedImage.getIconWidth() * this.getScale() > 1.0 && (double)this.storedImage.getIconWidth() * this.getScale() > 1.0;
    }

    public void customZoom(int n, int n2) {
        double d = this.scale;
        this.scale = (double)n / (double)n2;
        if (!this.isNewSizeOK()) {
            this.scale = d;
            return;
        }
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    private double getScale() {
        if (this.scale > 1.0) {
            this.scale = Math.floor(this.scale);
        }
        return this.scale;
    }

    private void scaleOut() {
        this.scale /= this.changeFactor;
    }

    private void scaleIn() {
        double d = this.getScale();
        this.scale = this.changeFactor * this.scale;
        double d2 = this.getScale();
        if (d2 == d) {
            this.scale = d2 + 1.0;
        }
    }

    private JButton getZoomButton(final int n, final int n2) {
        JButton jButton = new JButton("" + n + ":" + n2);
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_Zoom_BTN"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.customZoom(n, n2);
            }
        });
        return jButton;
    }

    private JButton getGridButton() {
        JButton jButton = new JButton(" # ");
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_Grid_BTN"));
        jButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_Grid_BTN_Mnem").charAt(0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.showGrid = !ImageViewer.this.showGrid;
                ImageViewer.this.panel.repaint(0, 0, ImageViewer.this.panel.getWidth(), ImageViewer.this.panel.getHeight());
            }
        });
        return jButton;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

