/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import org.netbeans.modules.image.ImageDataObject;
import org.netbeans.modules.image.ImageViewer;
import org.netbeans.modules.image.NBImageIcon;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public class ImageOpenSupport
extends OpenSupport
implements OpenCookie,
CloseCookie {
    private long lastSaveTime;
    private FileChangeListener fileChangeL;
    private RequestProcessor.Task reloadTask;
    static /* synthetic */ Class class$org$netbeans$modules$image$ImageOpenSupport;

    public ImageOpenSupport(MultiDataObject.Entry entry) {
        super(entry, (OpenSupport.Env)new Environment((DataObject)entry.getDataObject()));
    }

    public CloneableTopComponent createCloneableTopComponent() {
        this.prepareViewer();
        return new ImageViewer((ImageDataObject)this.entry.getDataObject());
    }

    void prepareViewer() {
        if (this.fileChangeL == null) {
            this.fileChangeL = new FileChangeAdapter(){

                public void fileChanged(FileEvent fileEvent) {
                    if (((CloneableOpenSupport)ImageOpenSupport.this).allEditors.isEmpty()) {
                        return;
                    }
                    if (fileEvent.getFile().isVirtual()) {
                        ImageOpenSupport.this.entry.getFile().removeFileChangeListener((FileChangeListener)this);
                        ((Environment)((CloneableOpenSupport)ImageOpenSupport.this).env).fileRemoved();
                        ImageOpenSupport.this.entry.getFile().addFileChangeListener((FileChangeListener)this);
                        return;
                    }
                    if (fileEvent.getTime() > ImageOpenSupport.this.lastSaveTime) {
                        ImageOpenSupport.this.lastSaveTime = System.currentTimeMillis();
                        if (ImageOpenSupport.this.reloadTask == null || ImageOpenSupport.this.reloadTask.isFinished()) {
                            ImageOpenSupport.this.reloadTask = RequestProcessor.postRequest((Runnable)new Runnable(this, fileEvent){
                                private final /* synthetic */ FileEvent val$evt;
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$evt = fileEvent;
                                }

                                public void run() {
                                    ImageOpenSupport.access$800(1.access$700(this.this$1), this.val$evt);
                                }
                            });
                        }
                    }
                }

                static /* synthetic */ ImageOpenSupport access$700(1 var0) {
                    return var0.ImageOpenSupport.this;
                }
            };
        }
        this.entry.getFile().addFileChangeListener(this.fileChangeL);
        this.lastSaveTime = System.currentTimeMillis();
    }

    private void reload(FileEvent fileEvent) {
        MessageFormat messageFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageOpenSupport == null ? (class$org$netbeans$modules$image$ImageOpenSupport = ImageOpenSupport.class$("org.netbeans.modules.image.ImageOpenSupport")) : class$org$netbeans$modules$image$ImageOpenSupport)).getString("MSG_ExternalChange"));
        String string = messageFormat.format(new Object[]{this.entry.getFile().getPackageNameExt('/', '.')});
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
        Object object = TopManager.getDefault().notify((NotifyDescriptor)confirmation);
        if (NotifyDescriptor.YES_OPTION.equals(object)) {
            ImageDataObject imageDataObject = (ImageDataObject)this.entry.getDataObject();
            CloneableTopComponent.Ref ref = ((CloneableOpenSupport)this).allEditors;
            final NBImageIcon nBImageIcon = new NBImageIcon(imageDataObject);
            Enumeration enumeration = ref.getComponents();
            while (enumeration.hasMoreElements()) {
                final Object e = enumeration.nextElement();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((ImageViewer)((Object)e)).reloadIcon(nBImageIcon);
                    }
                });
            }
        }
    }

    static /* synthetic */ void access$800(ImageOpenSupport imageOpenSupport, FileEvent fileEvent) {
        imageOpenSupport.reload(fileEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Environment
    extends OpenSupport.Env {
        static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

        public Environment(DataObject dataObject) {
            super(dataObject);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = Environment.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
        }

        private void fileRemoved() {
            try {
                this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

