/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.javac.v8.util;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Set<Key> {
    private int hashSize;
    private int hashMask;
    private int limit;
    private int size;
    private Entry<Key>[] table;

    public Set(int n, float f) {
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        this.hashSize = n2;
        this.hashMask = n2 - 1;
        this.limit = (int)((float)n2 * f);
        this.size = 0;
        this.table = new Entry[n2];
    }

    public Set(int n) {
        this(n, 0.75f);
    }

    public Set() {
        this(32);
    }

    public static <A> Set<A> make() {
        return new Set();
    }

    private void dble() {
        this.hashSize <<= 1;
        this.hashMask = this.hashSize - 1;
        this.limit <<= 1;
        Entry<Key>[] entryArray = this.table;
        this.table = new Entry[this.hashSize];
        int n = 0;
        while (n < entryArray.length) {
            this.copy(entryArray[n]);
            ++n;
        }
    }

    private void copy(Entry<Key> entry) {
        if (entry != null) {
            this.copy(entry.next);
            entry.next = this.table[entry.hash & this.hashMask];
            this.table[entry.hash & this.hashMask] = entry;
        }
    }

    public boolean contains(Key Key2) {
        int n = Key2.hashCode();
        Entry<Key> entry = this.table[n & this.hashMask];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(Key2)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean put(Key Key2) {
        int n = Key2.hashCode();
        Entry<Key> entry = this.table[n & this.hashMask];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(Key2)) {
                return true;
            }
            entry = entry.next;
        }
        ++this.size;
        if (this.size > this.limit) {
            this.dble();
        }
        int n2 = n & this.hashMask;
        Entry<Key> entry2 = new Entry<Key>(Key2, n, this.table[n2]);
        this.table[n2] = entry2;
        return false;
    }

    public void reset() {
        int n = 0;
        while (n < this.table.length) {
            this.table[n] = null;
            ++n;
        }
        this.size = 0;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<Key> {
        Key key;
        int hash;
        Entry<Key> next;

        Entry(Key Key2, int n, Entry<Key> entry) {
            this.key = Key2;
            this.hash = n;
            this.next = entry;
        }
    }
}

