/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.javac.v8.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.netbeans.lib.javac.v8.util.LayoutCharacters;
import org.netbeans.lib.javac.v8.util.Name;
import org.netbeans.lib.javac.v8.util.Names;
import org.netbeans.lib.javac.v8.util.Pair;
import org.netbeans.lib.javac.v8.util.Position;
import org.netbeans.lib.javac.v8.util.Set;

public class Log
implements LayoutCharacters {
    public int MaxErrors = 100;
    public int MaxWarnings = 100;
    public boolean promptOnError;
    public boolean emitWarnings;
    private Name sourcename = Names.__input;
    public int nerrors = 0;
    public int nwarnings = 0;
    private Set<Pair<Name, Integer>> recorded = Set.make();
    private byte[] buf = null;
    private int bp;
    private int lastLine;
    private static final String compilerRB = "org.netbeans.lib.javac.v8.resources.compiler";
    private static ResourceBundle messageRB;

    public Log(boolean bl, boolean bl2) {
        this.promptOnError = bl;
        this.emitWarnings = bl2;
    }

    public Log() {
        this(false, true);
    }

    public Name useSource(Name name) {
        Name name2 = this.sourcename;
        this.sourcename = name;
        if (name2 != this.sourcename) {
            this.buf = null;
        }
        return name2;
    }

    public Name currentSource() {
        return this.sourcename;
    }

    public void print(String string) {
        System.err.print(string);
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(Log.getLocalizedString("resume.abort"));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new InternalError("user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int n, int n2) {
        try {
            if (this.buf == null) {
                FileInputStream fileInputStream = new FileInputStream(this.sourcename.toString());
                this.buf = new byte[fileInputStream.available()];
                fileInputStream.read(this.buf);
                fileInputStream.close();
                this.bp = 0;
                this.lastLine = 1;
            } else if (this.lastLine > n) {
                this.bp = 0;
                this.lastLine = 1;
            }
            while (this.bp < this.buf.length && this.lastLine < n) {
                switch (this.buf[this.bp]) {
                    case 13: {
                        ++this.bp;
                        if (this.bp < this.buf.length && this.buf[this.bp] == 10) {
                            ++this.bp;
                        }
                        ++this.lastLine;
                        break;
                    }
                    case 10: {
                        ++this.bp;
                        ++this.lastLine;
                        break;
                    }
                    default: {
                        ++this.bp;
                    }
                }
            }
            int n3 = this.bp;
            while (n3 < this.buf.length && this.buf[n3] != 13 && this.buf[n3] != 10) {
                ++n3;
            }
            this.println(new String(this.buf, this.bp, n3 - this.bp));
            byte[] byArray = new byte[n2];
            int n4 = 0;
            while (n4 < n2 - 1) {
                byArray[n4] = 32;
                ++n4;
            }
            byArray[n2 - 1] = 94;
            this.println(new String(byArray, 0, n2));
        }
        catch (IOException iOException) {
            this.println(Log.getLocalizedString("source.unavailable"));
        }
    }

    protected void printError(int n, String string) {
        if (n == 0) {
            this.print(Log.getText("compiler.err.error", null, null, null, null, null, null, null));
            this.println(string);
        } else {
            int n2 = Position.line(n);
            int n3 = Position.column(n);
            this.println(this.sourcename + ":" + n2 + ": " + string);
            this.printErrLine(n2, n3);
        }
    }

    public void error(int n, String string) {
        this.error(n, string, null, null, null, null, null, null, null);
    }

    public void error(int n, String string, String string2) {
        this.error(n, string, string2, null, null, null, null, null, null);
    }

    public void error(int n, String string, String string2, String string3) {
        this.error(n, string, string2, string3, null, null, null, null, null);
    }

    public void error(int n, String string, String string2, String string3, String string4) {
        this.error(n, string, string2, string3, string4, null, null, null, null);
    }

    public void error(int n, String string, String string2, String string3, String string4, String string5) {
        this.error(n, string, string2, string3, string4, string5, null, null, null);
    }

    public void error(int n, String string, String string2, String string3, String string4, String string5, String string6) {
        this.error(n, string, string2, string3, string4, string5, string6, null, null);
    }

    public void error(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.error(n, string, string2, string3, string4, string5, string6, string7, null);
    }

    public void error(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Pair<Name, Integer> pair;
        if (this.nerrors < this.MaxErrors && !this.recorded.contains(pair = new Pair<Name, Integer>(this.sourcename, new Integer(n)))) {
            this.recorded.put(pair);
            String string9 = Log.getText("compiler.err." + string, string2, string3, string4, string5, string6, string7, string8);
            this.printError(n, string9);
            this.prompt();
            ++this.nerrors;
        }
    }

    public void warning(int n, String string) {
        this.warning(n, string, null, null, null, null);
    }

    public void warning(int n, String string, String string2) {
        this.warning(n, string, string2, null, null, null);
    }

    public void warning(int n, String string, String string2, String string3) {
        this.warning(n, string, string2, string3, null, null);
    }

    public void warning(int n, String string, String string2, String string3, String string4) {
        this.warning(n, string, string2, string3, string4, null);
    }

    public void warning(int n, String string, String string2, String string3, String string4, String string5) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            String string6 = Log.getText("compiler.warn." + string, string2, string3, string4, string5, null, null, null);
            this.printError(n, Log.getText("compiler.warn.warning", null, null, null, null, null, null, null) + string6);
        }
        ++this.nwarnings;
    }

    public void note(String string) {
        this.note(string, null);
    }

    public void note(String string, String string2) {
        if (this.emitWarnings) {
            this.print(Log.getText("compiler.note.note", null, null, null, null, null, null, null));
            String string3 = Log.getText("compiler.note." + string, string2, null, null, null, null, null, null);
            this.println(string3);
        }
    }

    public static String getLocalizedString(String string) {
        return Log.getText("compiler.misc." + string, null, null, null, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2) {
        return Log.getText("compiler.misc." + string, string2, null, null, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2, String string3) {
        return Log.getText("compiler.misc." + string, string2, string3, null, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2, String string3, String string4) {
        return Log.getText("compiler.misc." + string, string2, string3, string4, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2, String string3, String string4, String string5) {
        return Log.getText("compiler.misc." + string, string2, string3, string4, string5, null, null, null);
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle(compilerRB);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for compiler is missing");
        }
    }

    public void clearReportedErrors() {
        this.recorded = Set.make();
    }

    public static String getText(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (messageRB == null) {
            Log.initResource();
        }
        try {
            Object[] objectArray = new String[]{string2, string3, string4, string5, string6, string7, string8};
            return MessageFormat.format(messageRB.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                string2 = "null";
            }
            if (string3 == null) {
                string3 = "null";
            }
            if (string4 == null) {
                string4 = "null";
            }
            if (string5 == null) {
                string5 = "null";
            }
            if (string6 == null) {
                string6 = "null";
            }
            if (string7 == null) {
                string7 = "null";
            }
            if (string8 == null) {
                string8 = "null";
            }
            Object[] objectArray = new String[]{string, string2, string3, string4, string5, string6, string7, string8};
            String string9 = "compiler message file broken: key={0} arguments={1}, {2}, {3}, {4}, {5}, {6}, {7}";
            return MessageFormat.format(string9, objectArray);
        }
    }
}

