/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.javac.v8.util;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class List<A> {
    public A head;
    public List<A> tail;

    public List(A a, List<A> list) {
        this.tail = list;
        this.head = a;
    }

    public List() {
        this(null, null);
    }

    public static <A> List<A> make(A a) {
        return new List<A>(a, new List<A>());
    }

    public static <A> List<A> make(A a, A a2) {
        return new List<A>(a, new List<A>(a2, new List<A>()));
    }

    public static <A> List<A> make(A a, A a2, A a3) {
        return new List<A>(a, new List<A>(a2, new List<A>(a3, new List<A>())));
    }

    public static <A> List<A> make(A[] AArray) {
        List<A> list = new List<A>();
        int n = AArray.length - 1;
        while (n >= 0) {
            list = new List<A>(AArray[n], list);
            --n;
        }
        return list;
    }

    public static <A> List<A> make(int n, A a) {
        List<A> list = new List<A>();
        int n2 = 0;
        while (n2 < n) {
            list = new List<A>(a, list);
            ++n2;
        }
        return list;
    }

    public boolean isEmpty() {
        return this.tail == null;
    }

    public boolean nonEmpty() {
        return this.tail != null;
    }

    public int length() {
        List<A> list = this;
        int n = 0;
        while (list.tail != null) {
            list = list.tail;
            ++n;
        }
        return n;
    }

    public List<A> prepend(A a) {
        return new List<A>(a, this);
    }

    public List<A> prepend(List<A> list) {
        if (this.isEmpty()) {
            return list;
        }
        if (list.isEmpty()) {
            return this;
        }
        return this.prepend(list.tail).prepend(list.head);
    }

    public List<A> reverse() {
        List<A> list = new List<A>();
        List<A> list2 = this;
        while (list2.nonEmpty()) {
            list = new List<A>(list2.head, list);
            list2 = list2.tail;
        }
        return list;
    }

    public List<A> append(A a) {
        return List.make(a).prepend(this);
    }

    public A[] toArray(A[] AArray) {
        int n = 0;
        List<A> list = this;
        while (list.nonEmpty() && n < AArray.length) {
            AArray[n] = list.head;
            list = list.tail;
            ++n;
        }
        return AArray;
    }

    public String toString(String string) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.head.toString());
        List<A> list = this.tail;
        while (list.nonEmpty()) {
            stringBuffer.append(string);
            stringBuffer.append(list.head.toString());
            list = list.tail;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(",");
    }

    public int hashCode() {
        List<A> list = this;
        int n = 0;
        while (list.tail != null) {
            n = n * 41 + (this.head != null ? this.head.hashCode() : 0);
            list = list.tail;
        }
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof List && List.equals(this, (List)object);
    }

    public static boolean equals(List list, List list2) {
        while (list.tail != null && list2.tail != null) {
            if (list.head == null ? list2.head != null : !list.head.equals(list2.head)) {
                return false;
            }
            list = list.tail;
            list2 = list2.tail;
        }
        return list.tail == null && list2.tail == null;
    }

    public boolean contains(Object object) {
        List<A> list = this;
        while (list.tail != null) {
            if (object == null ? list.head == null : object.equals(list.head)) {
                return true;
            }
            list = list.tail;
        }
        return false;
    }
}

