/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.javac.v8.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.netbeans.lib.javac.v8.util.Name;

public class ByteBuffer {
    public byte[] elems;
    public int length;

    public ByteBuffer() {
        this(64);
    }

    public ByteBuffer(int n) {
        this.elems = new byte[n];
        this.length = 0;
    }

    private void copy(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.elems, 0, byArray, 0, this.elems.length);
        this.elems = byArray;
    }

    public void appendByte(int n) {
        if (this.length >= this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        this.elems[this.length++] = (byte)n;
    }

    public void appendBytes(byte[] byArray, int n, int n2) {
        while (this.length + n2 > this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        System.arraycopy(byArray, n, this.elems, this.length, n2);
        this.length += n2;
    }

    public void appendBytes(byte[] byArray) {
        this.appendBytes(byArray, 0, byArray.length);
    }

    public void appendChar(int n) {
        while (this.length + 1 >= this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        this.elems[this.length] = (byte)(n >> 8 & 0xFF);
        this.elems[this.length + 1] = (byte)(n & 0xFF);
        this.length += 2;
    }

    public void appendInt(int n) {
        while (this.length + 3 >= this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        this.elems[this.length] = (byte)(n >> 24 & 0xFF);
        this.elems[this.length + 1] = (byte)(n >> 16 & 0xFF);
        this.elems[this.length + 2] = (byte)(n >> 8 & 0xFF);
        this.elems[this.length + 3] = (byte)(n & 0xFF);
        this.length += 4;
    }

    public void appendLong(long l) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new InternalError("write");
        }
    }

    public void appendFloat(float f) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeFloat(f);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 4);
        }
        catch (IOException iOException) {
            throw new InternalError("write");
        }
    }

    public void appendDouble(double d) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeDouble(d);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new InternalError("write");
        }
    }

    public void appendName(Name name) {
        this.appendBytes(Name.names, name.index, name.len);
    }

    public void reset() {
        this.length = 0;
    }

    public Name toName() {
        return Name.fromUtf(this.elems, 0, this.length);
    }
}

