/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.javac.v8.tree;

import java.io.PrintStream;
import org.netbeans.lib.javac.v8.code.Flags;
import org.netbeans.lib.javac.v8.code.Type;
import org.netbeans.lib.javac.v8.tree.Tree;
import org.netbeans.lib.javac.v8.tree.TreeInfo;
import org.netbeans.lib.javac.v8.util.Convert;
import org.netbeans.lib.javac.v8.util.Hashtable;
import org.netbeans.lib.javac.v8.util.List;
import org.netbeans.lib.javac.v8.util.Name;
import org.netbeans.lib.javac.v8.util.Names;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pretty
extends Tree.Visitor
implements Flags {
    PrintStream out;
    public int width = 3;
    int lmargin = 0;
    Name enclClassName = Names.empty;
    Hashtable<Tree, String> docComments = null;
    int prec;

    public Pretty(PrintStream printStream) {
        this.out = printStream;
    }

    public Pretty() {
        this(System.out);
    }

    void align() {
        int n = 0;
        while (n < this.lmargin) {
            this.out.print(" ");
            ++n;
        }
    }

    void indent() {
        this.lmargin += this.width;
    }

    void undent() {
        this.lmargin -= this.width;
    }

    void open(int n, int n2) {
        if (n2 < n) {
            this.out.print("(");
        }
    }

    void close(int n, int n2) {
        if (n2 < n) {
            this.out.print(")");
        }
    }

    public void print(String string) {
        this.out.print(Convert.escapeUnicode(string));
    }

    public void println() {
        this.out.println();
    }

    public void printExpr(Tree tree, int n) {
        if (tree == null) {
            this.print("/*missing*/");
        } else {
            int n2 = this.prec;
            this.prec = n;
            tree.visit(this);
            this.prec = n2;
        }
    }

    public void printExpr(Tree tree) {
        this.printExpr(tree, 0);
    }

    public void printStat(Tree tree) {
        this.printExpr(tree, -1);
    }

    public <T extends Tree> void printExprs(List<T> list) {
        if (list.nonEmpty()) {
            this.printExpr((Tree)list.head);
            List list2 = list.tail;
            while (list2.nonEmpty()) {
                this.print(", ");
                this.printExpr((Tree)list2.head);
                list2 = list2.tail;
            }
        }
    }

    public <T extends Tree> void printStats(List<T> list) {
        List<Object> list2 = list;
        while (list2.nonEmpty()) {
            this.align();
            this.printStat((Tree)list2.head);
            this.println();
            list2 = list2.tail;
        }
    }

    public void printFlags(int n) {
        if ((n & 0x10000) != 0) {
            this.print("/*synthetic*/ ");
        }
        this.print(TreeInfo.flagNames(n));
        if ((n & 0xFFF) != 0) {
            this.print(" ");
        }
    }

    public void printDocComment(Tree tree) {
        String string = this.docComments.get(tree);
        if (string != null) {
            this.print("/**");
            this.println();
            int n = 0;
            int n2 = Pretty.lineEndPos(string, n);
            while (n < string.length()) {
                this.align();
                this.print(" *");
                if (n < string.length() && string.charAt(n) > ' ') {
                    this.print(" ");
                }
                this.print(string.substring(n, n2));
                this.println();
                n = n2 + 1;
                n2 = Pretty.lineEndPos(string, n);
            }
            this.align();
            this.print(" */");
            this.println();
            this.align();
        }
    }

    static int lineEndPos(String string, int n) {
        int n2 = string.indexOf(10, n);
        if (n2 < 0) {
            n2 = string.length();
        }
        return n2;
    }

    public void printTypeParameters(List<Tree.TypeParameter> list) {
        if (list.nonEmpty()) {
            this.print("<");
            this.printExprs(list);
            this.print(">");
        }
    }

    public void printBlock(List<Tree> list) {
        this.print("{");
        this.println();
        this.indent();
        this.printStats(list);
        this.undent();
        this.align();
        this.print("}");
    }

    public void printUnit(Tree.TopLevel topLevel, Tree.ClassDef classDef) {
        this.docComments = topLevel.docComments;
        this.printDocComment(topLevel);
        if (topLevel.pid != null) {
            this.print("package ");
            this.printExpr(topLevel.pid);
            this.print(";");
            this.println();
        }
        List<Tree> list = topLevel.defs;
        while (list.nonEmpty() && (classDef == null || ((Tree)list.head).tag == 2)) {
            this.printStat((Tree)list.head);
            this.println();
            list = list.tail;
        }
        if (classDef != null) {
            this.printStat(classDef);
            this.println();
        }
    }

    @Override
    public void _case(Tree.TopLevel topLevel) {
        this.printUnit(topLevel, null);
    }

    @Override
    public void _case(Tree.Import import_) {
        this.print("import ");
        this.printExpr(import_.qualid);
        this.print(";");
        this.println();
    }

    @Override
    public void _case(Tree.ClassDef classDef) {
        this.println();
        this.align();
        this.printDocComment(classDef);
        this.printFlags(classDef.flags & 0xFFFFFDFF);
        Name name = this.enclClassName;
        this.enclClassName = classDef.name;
        if ((classDef.flags & 0x200) != 0) {
            this.print(new StringBuffer().append("interface ").append(classDef.name).toString());
            this.printTypeParameters(classDef.typarams);
            if (classDef.implementing.nonEmpty()) {
                this.print(" extends ");
                this.printExprs(classDef.implementing);
            }
        } else {
            this.print(new StringBuffer().append("class ").append(classDef.name).toString());
            this.printTypeParameters(classDef.typarams);
            if (classDef.extending != null) {
                this.print(" extends ");
                this.printExpr(classDef.extending);
            }
            if (classDef.implementing.nonEmpty()) {
                this.print(" implements ");
                this.printExprs(classDef.implementing);
            }
        }
        this.print(" ");
        this.printBlock(classDef.defs);
        this.enclClassName = name;
    }

    @Override
    public void _case(Tree.MethodDef methodDef) {
        if (methodDef.name != Names.init || this.enclClassName != null) {
            this.println();
            this.align();
            this.printDocComment(methodDef);
            this.printFlags(methodDef.flags);
            if (methodDef.name == Names.init) {
                this.print(this.enclClassName.toString());
            } else {
                this.printExpr(methodDef.restype);
                this.print(new StringBuffer().append(" ").append(methodDef.name).toString());
            }
            this.printTypeParameters(methodDef.typarams);
            this.print("(");
            this.printExprs(methodDef.params);
            this.print(")");
            if (methodDef.thrown.nonEmpty()) {
                this.print(" throws ");
                this.printExprs(methodDef.thrown);
            }
            if (methodDef.body != null) {
                this.print(" ");
                this.printStat(methodDef.body);
            } else {
                this.print(";");
            }
        }
    }

    @Override
    public void _case(Tree.VarDef varDef) {
        if (this.docComments.get(varDef) != null) {
            this.println();
            this.align();
        }
        this.printDocComment(varDef);
        this.printFlags(varDef.flags);
        this.printExpr(varDef.vartype);
        this.print(new StringBuffer().append(" ").append(varDef.name).toString());
        if (varDef.init != null) {
            this.print(" = ");
            this.printExpr(varDef.init);
        }
        if (this.prec == -1) {
            this.print(";");
        }
    }

    @Override
    public void _case(Tree.Block block) {
        this.printFlags(block.flags);
        this.printBlock(block.stats);
    }

    @Override
    public void _case(Tree.DoLoop doLoop) {
        this.print("do ");
        this.printStat(doLoop.body);
        this.align();
        this.print(" while (");
        this.printExpr(doLoop.cond);
        this.print(");");
    }

    @Override
    public void _case(Tree.WhileLoop whileLoop) {
        this.print("while (");
        this.printExpr(whileLoop.cond);
        this.print(") ");
        this.printStat(whileLoop.body);
    }

    @Override
    public void _case(Tree.ForLoop forLoop) {
        this.print("for (");
        if (forLoop.init.nonEmpty()) {
            if (((Tree)forLoop.init.head).tag == 5) {
                this.printExpr((Tree)forLoop.init.head);
                List list = forLoop.init.tail;
                while (list.nonEmpty()) {
                    Tree.VarDef varDef = (Tree.VarDef)list.head;
                    this.print(new StringBuffer().append(", ").append(varDef.name).append(" = ").toString());
                    this.printExpr(varDef.init);
                    list = list.tail;
                }
            } else {
                this.printExprs(forLoop.init);
            }
        }
        this.print("; ");
        if (forLoop.cond != null) {
            this.printExpr(forLoop.cond);
        }
        this.print("; ");
        this.printExprs(forLoop.step);
        this.print(") ");
        this.printStat(forLoop.body);
    }

    @Override
    public void _case(Tree.Labelled labelled) {
        this.print(new StringBuffer().append(labelled.label).append(": ").toString());
        this.printStat(labelled.body);
    }

    @Override
    public void _case(Tree.Switch switch_) {
        this.print("switch (");
        this.printExpr(switch_.selector);
        this.print(") {\n");
        this.printStats(switch_.cases);
        this.align();
        this.print("}");
    }

    @Override
    public void _case(Tree.Case case_) {
        if (case_.pat == null) {
            this.print("default");
        } else {
            this.print("case ");
            this.printExpr(case_.pat);
        }
        this.print(": \n");
        this.indent();
        this.printStats(case_.stats);
        this.undent();
        this.align();
    }

    @Override
    public void _case(Tree.Synchronized synchronized_) {
        this.print("synchronized (");
        this.printExpr(synchronized_.lock);
        this.print(") ");
        this.printStat(synchronized_.body);
    }

    @Override
    public void _case(Tree.Try try_) {
        this.print("try ");
        this.printBlock(Tree.emptyList.prepend(try_.body));
        this.print(" ");
        List<Tree.Catch> list = try_.catchers;
        while (list.nonEmpty()) {
            this.printStat((Tree)list.head);
            list = list.tail;
        }
        if (try_.finalizer != null) {
            this.print(" finally ");
            this.printBlock(Tree.emptyList.prepend(try_.finalizer));
        }
    }

    @Override
    public void _case(Tree.Catch catch_) {
        this.print(" catch (");
        this.printExpr(catch_.param);
        this.print(") ");
        this.printBlock(Tree.emptyList.prepend(catch_.body));
    }

    @Override
    public void _case(Tree.Conditional conditional) {
        if (conditional.tag == 17) {
            this.print("if (");
            this.printExpr(conditional.cond);
            this.print(") ");
            this.printStat(conditional.thenpart);
            if (conditional.elsepart != null) {
                this.print(" else ");
                this.printStat(conditional.elsepart);
            }
        } else {
            this.open(this.prec, 3);
            this.printExpr(conditional.cond, 3);
            this.print(" ? ");
            this.printExpr(conditional.thenpart, 3);
            this.print(" : ");
            this.printExpr(conditional.elsepart, 3);
            this.close(this.prec, 3);
        }
    }

    @Override
    public void _case(Tree.Exec exec) {
        this.printExpr(exec.expr);
        if (this.prec == -1) {
            this.print(";");
        }
    }

    @Override
    public void _case(Tree.Break break_) {
        this.print("break");
        if (break_.label != null) {
            this.print(new StringBuffer().append(" ").append(break_.label).toString());
        }
        this.print(";");
    }

    @Override
    public void _case(Tree.Continue continue_) {
        this.print("continue");
        if (continue_.label != null) {
            this.print(new StringBuffer().append(" ").append(continue_.label).toString());
        }
        this.print(";");
    }

    @Override
    public void _case(Tree.Return return_) {
        this.print("return");
        if (return_.expr != null) {
            this.print(" ");
            this.printExpr(return_.expr);
        }
        this.print(";");
    }

    @Override
    public void _case(Tree.Throw throw_) {
        this.print("throw ");
        this.printExpr(throw_.expr);
        this.print(";");
    }

    @Override
    public void _case(Tree.Apply apply) {
        this.printExpr(apply.meth);
        this.print("(");
        this.printExprs(apply.args);
        this.print(")");
    }

    @Override
    public void _case(Tree.NewClass newClass) {
        if (newClass.encl != null) {
            this.printExpr(newClass.encl);
            this.print(".");
        }
        this.print("new ");
        this.printExpr(newClass.clazz);
        this.print("(");
        this.printExprs(newClass.args);
        this.print(")");
        if (newClass.def != null) {
            Name name = this.enclClassName;
            this.enclClassName = null;
            this.printBlock(newClass.def.defs);
            this.enclClassName = name;
        }
    }

    @Override
    public void _case(Tree.NewArray newArray) {
        if (newArray.elemtype != null) {
            this.print("new ");
            int n = 0;
            Tree tree = newArray.elemtype;
            while (tree.tag == 34) {
                ++n;
                tree = ((Tree.TypeArray)tree).elemtype;
            }
            this.printExpr(tree);
            List<Tree> list = newArray.dims;
            while (list.nonEmpty()) {
                this.print("[");
                this.printExpr((Tree)list.head);
                this.print("]");
                list = list.tail;
            }
            int n2 = 0;
            while (n2 < n) {
                this.print("[]");
                ++n2;
            }
            if (newArray.elems != null) {
                this.print("[]");
            }
        }
        if (newArray.elems != null) {
            this.print("{");
            this.printExprs(newArray.elems);
            this.print("}");
        }
    }

    @Override
    public void _case(Tree.Assign assign) {
        this.open(this.prec, 1);
        this.printExpr(assign.lhs, 2);
        this.print(" = ");
        this.printExpr(assign.rhs, 1);
        this.close(this.prec, 1);
    }

    @Override
    public void _case(Tree.Assignop assignop) {
        this.open(this.prec, 2);
        this.printExpr(assignop.lhs, 3);
        this.print(new StringBuffer().append(" ").append(TreeInfo.operatorName(assignop.tag - 17)).append("= ").toString());
        this.printExpr(assignop.rhs, 2);
        this.close(this.prec, 2);
    }

    @Override
    public void _case(Tree.Operation operation) {
        int n = TreeInfo.opPrec(operation.tag);
        String string = TreeInfo.operatorName(operation.tag).toString();
        this.open(this.prec, n);
        if (operation.tag <= 43) {
            this.print(string);
            this.printExpr((Tree)operation.args.head, n);
        } else if (operation.tag <= 45) {
            this.printExpr((Tree)operation.args.head, n);
            this.print(string);
        } else {
            this.printExpr((Tree)operation.args.head, n);
            this.print(new StringBuffer().append(" ").append(string).append(" ").toString());
            this.printExpr((Tree)operation.args.tail.head, n + 1);
        }
        this.close(this.prec, n);
    }

    @Override
    public void _case(Tree.TypeCast typeCast) {
        this.open(this.prec, 14);
        this.print("(");
        this.printExpr(typeCast.clazz);
        this.print(")");
        this.printExpr(typeCast.expr, 14);
        this.close(this.prec, 14);
    }

    @Override
    public void _case(Tree.TypeTest typeTest) {
        this.open(this.prec, 10);
        this.printExpr(typeTest.expr, 10);
        this.print(" instanceof ");
        this.printExpr(typeTest.clazz, 11);
        this.close(this.prec, 10);
    }

    @Override
    public void _case(Tree.Indexed indexed) {
        this.printExpr(indexed.indexed, 15);
        this.print("[");
        this.printExpr(indexed.index);
        this.print("]");
    }

    @Override
    public void _case(Tree.Select select) {
        this.printExpr(select.selected, 15);
        this.print(new StringBuffer().append(".").append(select.name).toString());
    }

    @Override
    public void _case(Tree.Ident ident) {
        this.print(ident.name.toString());
    }

    @Override
    public void _case(Tree.Literal literal) {
        switch (literal.typetag) {
            case 4: {
                this.print(literal.value.toString());
                break;
            }
            case 5: {
                this.print(new StringBuffer().append(literal.value.toString()).append("L").toString());
                break;
            }
            case 6: {
                this.print(new StringBuffer().append(literal.value.toString()).append("F").toString());
                break;
            }
            case 7: {
                this.print(literal.value.toString());
                break;
            }
            case 2: {
                this.print(new StringBuffer().append("'").append(Convert.quote(String.valueOf((char)((Number)literal.value).intValue()))).append("'").toString());
                break;
            }
            case 10: {
                this.print(new StringBuffer().append("\"").append(Convert.quote((String)literal.value)).append("\"").toString());
                break;
            }
            default: {
                this.print(literal.value.toString());
            }
        }
    }

    @Override
    public void _case(Tree.TypeIdent typeIdent) {
        this.print(Type.typeOfTag[typeIdent.typetag].tsym.name.toString());
    }

    @Override
    public void _case(Tree.TypeArray typeArray) {
        this.printExpr(typeArray.elemtype);
        this.print("[]");
    }

    @Override
    public void _case(Tree.TypeApply typeApply) {
        this.printExpr(typeApply.clazz);
        this.print("<");
        this.printExprs(typeApply.arguments);
        this.print(">");
    }

    @Override
    public void _case(Tree.TypeParameter typeParameter) {
        this.print(typeParameter.name.toString());
        if (typeParameter.extBound != null) {
            this.print(" extends ");
            this.printExpr(typeParameter.extBound);
        } else if (typeParameter.implBound != null) {
            this.print(" implements ");
            this.printExpr(typeParameter.implBound);
        }
    }

    @Override
    public void _case(Tree.Erroneous erroneous) {
        this.print("(ERROR)");
    }

    @Override
    public void _case(Tree tree) {
        this.print(new StringBuffer().append("(UNKNOWN: ").append(tree).append(")").toString());
        this.println();
    }
}

