/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.javac.v8.tools;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.lib.javac.v8.code.ClassFile;
import org.netbeans.lib.javac.v8.code.Symbol;
import org.netbeans.lib.javac.v8.util.Name;

class DumpClassFile
extends ClassFile {
    private static byte[] buf;
    private static int bp;
    private static Object[] pool;

    DumpClassFile() {
    }

    private static int nextChar() {
        return (char)(((buf[bp++] & 0xFF) << 8) + (buf[bp++] & 0xFF));
    }

    private static int nextInt() {
        return ((buf[bp++] & 0xFF) << 24) + ((buf[bp++] & 0xFF) << 16) + ((buf[bp++] & 0xFF) << 8) + (buf[bp++] & 0xFF);
    }

    private static long getLong(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(buf, n, 8));
        try {
            return dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
    }

    private static float getFloat(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(buf, n, 4));
        try {
            return dataInputStream.readFloat();
        }
        catch (IOException iOException) {
            throw new InternalError("get");
        }
    }

    private static double getDouble(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(buf, n, 8));
        try {
            return dataInputStream.readDouble();
        }
        catch (IOException iOException) {
            throw new InternalError("get");
        }
    }

    private static void dumpPool() {
        System.out.println("pool:");
        int n = DumpClassFile.nextChar();
        pool = new Object[n];
        int n2 = 1;
        while (n2 < n) {
            System.out.print(n2 + ": ");
            byte by = buf[bp++];
            switch (by) {
                case 1: {
                    int n3 = DumpClassFile.nextChar();
                    DumpClassFile.pool[n2] = Name.fromUtf(buf, bp, n3);
                    System.out.println("UTF8#" + n3 + "#" + pool[n2]);
                    bp += n3;
                    break;
                }
                case 2: {
                    throw new RuntimeException("can't read unicode strings in class files");
                }
                case 7: {
                    System.out.println("CLASS#" + DumpClassFile.nextChar());
                    break;
                }
                case 8: {
                    System.out.println("STRING#" + DumpClassFile.nextChar());
                    break;
                }
                case 9: {
                    System.out.println("FIELDREF#" + DumpClassFile.nextChar() + "#" + DumpClassFile.nextChar());
                    break;
                }
                case 10: {
                    System.out.println("METHODREF#" + DumpClassFile.nextChar() + "#" + DumpClassFile.nextChar());
                    break;
                }
                case 11: {
                    System.out.println("INTERFACEMETHODREF#" + DumpClassFile.nextChar() + "#" + DumpClassFile.nextChar());
                    break;
                }
                case 12: {
                    System.out.println("NAMEANDTYPE#" + DumpClassFile.nextChar() + "#" + DumpClassFile.nextChar());
                    break;
                }
                case 3: {
                    System.out.println("INTEGER#" + DumpClassFile.nextInt());
                    break;
                }
                case 4: {
                    System.out.println("FLOAT#" + DumpClassFile.getFloat(bp));
                    bp += 4;
                    break;
                }
                case 5: {
                    System.out.println("LONG#" + DumpClassFile.getLong(bp));
                    bp += 8;
                    ++n2;
                    break;
                }
                case 6: {
                    System.out.println("DOUBLE#" + DumpClassFile.getDouble(bp));
                    bp += 8;
                    ++n2;
                    break;
                }
                default: {
                    throw new RuntimeException("bad constant pool tag: " + by + " at " + (bp - 1));
                }
            }
            ++n2;
        }
    }

    static void dump(char c) {
        System.out.println(c);
    }

    static String poolOf(int n) {
        if (pool[n] != null) {
            return pool[n] + "(" + n + ")";
        }
        return String.valueOf(n);
    }

    private static char hex(int n) {
        return n >= 10 ? (char)(n - 10 + 65) : (char)(n + 48);
    }

    private static void dumpHex(byte by) {
        System.out.print(DumpClassFile.hex(by >>> 4 & 0xF));
        System.out.print(DumpClassFile.hex(by & 0xF));
    }

    private static void dumpAttrs() {
        int n = DumpClassFile.nextChar();
        int n2 = 0;
        while (n2 < n) {
            int n3 = DumpClassFile.nextChar();
            int n4 = DumpClassFile.nextInt();
            System.out.print("  name = " + DumpClassFile.poolOf(n3) + ", len = " + n4);
            if (n4 == 2) {
                System.out.print(", data = " + DumpClassFile.poolOf(DumpClassFile.nextChar()));
            } else {
                bp += n4;
            }
            System.out.println();
            ++n2;
        }
    }

    private static void readCode(Symbol symbol) {
        int n;
        System.out.println("Code: ");
        System.out.println(" maxstack = " + DumpClassFile.nextChar());
        System.out.println(" maxlocals = " + DumpClassFile.nextChar());
        int n2 = DumpClassFile.nextInt();
        System.out.println(" codesize = " + n2);
        System.out.print("    ");
        int n3 = 0;
        while (n3 < n2) {
            n = buf[bp++];
            DumpClassFile.dumpHex((byte)n);
            System.out.print(' ');
            if (n3 % 16 == 0) {
                System.out.println();
                System.out.print("    ");
            }
            ++n3;
        }
        System.out.println();
        n = DumpClassFile.nextChar();
        System.out.println(" catches = " + n);
        int n4 = 0;
        while (n4 < n) {
            System.out.println("    " + DumpClassFile.nextChar() + " " + DumpClassFile.nextChar() + " " + DumpClassFile.nextChar() + " " + DumpClassFile.nextChar());
            ++n4;
        }
        DumpClassFile.dumpAttrs();
    }

    private static void dumpField() {
        System.out.println("field:");
        System.out.print(" modifiers = ");
        int n = DumpClassFile.nextChar();
        DumpClassFile.dumpHex((byte)(n >> 8));
        DumpClassFile.dumpHex((byte)n);
        System.out.println();
        System.out.println(" name = " + DumpClassFile.poolOf(DumpClassFile.nextChar()));
        System.out.println(" type = " + DumpClassFile.poolOf(DumpClassFile.nextChar()));
        DumpClassFile.dumpAttrs();
    }

    private static void dumpMethod() {
        System.out.println("method:");
        System.out.print("modifiers = ");
        int n = DumpClassFile.nextChar();
        DumpClassFile.dumpHex((byte)(n >> 8));
        DumpClassFile.dumpHex((byte)n);
        System.out.println();
        System.out.println(" name = " + DumpClassFile.poolOf(DumpClassFile.nextChar()));
        System.out.println(" type = " + DumpClassFile.poolOf(DumpClassFile.nextChar()));
        DumpClassFile.dumpAttrs();
    }

    private static void dumpClassBody() {
        System.out.println("class:");
        System.out.print("modifiers = ");
        int n = DumpClassFile.nextChar();
        DumpClassFile.dumpHex((byte)(n >> 8));
        DumpClassFile.dumpHex((byte)n);
        System.out.println();
        System.out.println(" name = " + DumpClassFile.poolOf(DumpClassFile.nextChar()));
        System.out.println(" superclass = " + DumpClassFile.nextChar());
        int n2 = DumpClassFile.nextChar();
        System.out.print(" ninterfaces = " + n2 + "\n   ");
        int n3 = 0;
        while (n3 < n2) {
            System.out.print(" " + DumpClassFile.nextChar());
            ++n3;
        }
        System.out.println();
        int n4 = DumpClassFile.nextChar();
        System.out.println(" nfields = " + n4);
        int n5 = 0;
        while (n5 < n4) {
            DumpClassFile.dumpField();
            ++n5;
        }
        int n6 = DumpClassFile.nextChar();
        System.out.println(" nmethods = " + n6);
        int n7 = 0;
        while (n7 < n6) {
            DumpClassFile.dumpMethod();
            ++n7;
        }
        System.out.println("class atributes: ");
        DumpClassFile.dumpAttrs();
    }

    private static void dumpClassFile() {
        System.out.println("magic = " + DumpClassFile.nextInt());
        System.out.println("minor version = " + DumpClassFile.nextChar());
        System.out.println("major version = " + DumpClassFile.nextChar());
        DumpClassFile.dumpPool();
        DumpClassFile.dumpClassBody();
    }

    public static void dumpClass(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        buf = new byte[((InputStream)fileInputStream).available()];
        if (((InputStream)fileInputStream).read(buf) != buf.length) {
            throw new IOException("unexpected end of file: " + string);
        }
        ((InputStream)fileInputStream).close();
        bp = 0;
        DumpClassFile.dumpClassFile();
        if (bp != buf.length) {
            System.out.println(buf.length - bp + " trailing bytes");
        }
    }

    public static void main(String[] stringArray) throws IOException {
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n] + "****************");
            DumpClassFile.dumpClass(stringArray[n]);
            ++n;
        }
    }
}

