/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.ConnectingDialog;
import org.netbeans.modules.autoupdate.ConnectingErrorDialog;
import org.netbeans.modules.autoupdate.DownloadProgressPanel;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.FirstPanel;
import org.netbeans.modules.autoupdate.LoginPanel;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Notification;
import org.netbeans.modules.autoupdate.PreparedModules;
import org.netbeans.modules.autoupdate.ProgressDialog;
import org.netbeans.modules.autoupdate.ResultsPanel;
import org.netbeans.modules.autoupdate.SelectModulesPanel;
import org.netbeans.modules.autoupdate.SignVerifier;
import org.netbeans.modules.autoupdate.UpdatePanel;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.XMLUpdates;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class Wizard
implements WizardDescriptor.Iterator {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$autoupdate$Wizard == null ? (class$org$netbeans$modules$autoupdate$Wizard = Wizard.class$("org.netbeans.modules.autoupdate.Wizard")) : class$org$netbeans$modules$autoupdate$Wizard));
    private Updates updates;
    private static HashMap allUpdates = new HashMap();
    private static RequestProcessor processor;
    private WizardPanel[][] panels = new WizardPanel[][]{{new StartPanel(), new PropPanel(), null, new ConfigPanel(), new DownloadPanel(), new LastPanel()}, {null, null, new SelectPanel(), null, null, null}};
    private int current = 0;
    private int modulesOK = 0;
    private boolean canceled = false;
    private int wizardType = 0;
    private WizardDescriptor wizardDescriptor;
    private List auTypesWithCust = new ArrayList();
    private static boolean restart;
    static Dialog dialog;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$Wizard;

    Wizard() {
        this(null);
    }

    Wizard(HashMap hashMap) {
        this(hashMap, 0);
    }

    Wizard(HashMap hashMap, int n) {
        this.wizardType = n;
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("value") && ((object = propertyChangeEvent.getNewValue()) == WizardDescriptor.FINISH_OPTION || object == NotifyDescriptor.CANCEL_OPTION || object == NotifyDescriptor.CLOSED_OPTION)) {
                    if (object != WizardDescriptor.FINISH_OPTION) {
                        Wizard.this.canceled = true;
                        Downloader.deleteDownload();
                    }
                    Wizard.this.getCurrent().end(true);
                    ((Component)dialog).setVisible(false);
                    Autoupdater.setRunning(false);
                    dialog.dispose();
                }
            }
        };
        if (hashMap != null) {
            int n2 = 3;
            allUpdates = hashMap;
            this.current = n2;
            this.panels[0][n2].start(true);
        }
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this, new Object());
        this.wizardDescriptor.setModal(false);
        this.wizardDescriptor.setTitle(bundle.getString("CTL_Wizard"));
        this.wizardDescriptor.setTitleFormat(new MessageFormat(" {0}"));
        this.wizardDescriptor.setAdditionalOptions(new Object[0]);
        this.wizardDescriptor.addPropertyChangeListener(propertyChangeListener);
        this.wizardDescriptor.setOptions(new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, WizardDescriptor.FINISH_OPTION, NotifyDescriptor.CANCEL_OPTION});
    }

    static void go(HashMap hashMap) {
        Wizard.go(hashMap, 0);
    }

    static void go(HashMap hashMap, int n) {
        if (Autoupdater.isRunning()) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)bundle.getString("MSG_WizardRunning"), 2));
        } else {
            Wizard wizard = new Wizard(hashMap, n);
            Autoupdater.setRunning(true);
            wizard.startDialog();
        }
    }

    static void go() {
        if (Autoupdater.isRunning()) {
            dialog.requestFocus();
            if (dialog instanceof JDialog) {
                ((JDialog)dialog).getRootPane().requestDefaultFocus();
            }
        } else {
            Wizard wizard = new Wizard();
            Autoupdater.setRunning(true);
            wizard.startDialog();
        }
    }

    private void startDialog() {
        dialog = TopManager.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        this.canceled = false;
        dialog.show();
    }

    static void setRestart(boolean bl) {
        restart = bl;
    }

    public String name() {
        return this.getCurrent().getName();
    }

    public WizardDescriptor.Panel current() {
        return this.getCurrent();
    }

    private WizardPanel getCurrent() {
        return this.panels[this.wizardType][this.current] == null ? this.panels[0][this.current] : this.panels[this.wizardType][this.current];
    }

    public boolean hasNext() {
        if (this.current == 1 && this.getCurrent().nextPanelOffset() == -1) {
            return false;
        }
        return this.current < this.panels[this.wizardType].length - 1;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public void nextPanel() {
        this.getCurrent().end(true);
        this.current = this.current < 0 && this.wizardType == 0 ? (this.current += 2) : (this.current == 0 && this.wizardType == 1 ? 2 : (this.current == 0 && this.wizardType == 0 && this.auTypesWithCust.size() == 0 ? 3 : (this.current == 1 && this.wizardType == 0 && this.auTypesWithCust.size() == 0 ? (this.current += 2) : (this.current == 1 && this.wizardType == 0 && this.auTypesWithCust.size() > 0 ? 1 : (this.current == 3 && this.getCurrent().nextPanelOffset() == 2 ? 5 : ++this.current)))));
        this.getCurrent().start(true);
    }

    public void previousPanel() {
        this.getCurrent().end(false);
        switch (this.current) {
            case 2: {
                if (this.wizardType == 1) {
                    this.current = 0;
                    break;
                }
                --this.current;
                break;
            }
            case 3: {
                if (this.wizardType == 0) {
                    this.current = 0;
                    break;
                }
                --this.current;
                break;
            }
            case 5: {
                this.current = 3;
                break;
            }
            default: {
                --this.current;
            }
        }
        this.getCurrent().start(false);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
    }

    static HashMap getAllUpdates() {
        return allUpdates;
    }

    static void setAllUpdates(HashMap hashMap) {
        allUpdates = hashMap;
    }

    static Collection getAllModules() {
        HashSet hashSet = new HashSet();
        Iterator iterator = Wizard.getAllUpdates().values().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(((Updates)iterator.next()).getModules());
        }
        return hashSet;
    }

    static RequestProcessor getRequestProcessor() {
        if (processor == null) {
            processor = new RequestProcessor();
        }
        return processor;
    }

    static int checkConnect(Updates updates) {
        if (ConnectingDialog.isCanceled()) {
            return 1;
        }
        if (ConnectingDialog.isSkipped()) {
            return 2;
        }
        if (updates.isError()) {
            ConnectingErrorDialog.showDialog(updates.getError(), updates.getErrorMessage());
            return 1;
        }
        if (updates.getModules() != null && updates.getModules().size() > 0) {
            Notification.performNotification(updates);
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        restart = true;
    }

    class SelectPanel
    extends WizardPanel {
        private SelectModulesPanel selectModulesPanel = new SelectModulesPanel(this, this){
            private final /* synthetic */ SelectPanel this$1;
            {
                this.this$1 = selectPanel;
            }

            public Dimension getPreferredSize() {
                return this.this$1.WIZARD_SIZE;
            }
        };

        SelectPanel() {
        }

        String getName() {
            return bundle.getString("CTL_SelectModulesPanel");
        }

        public Component getComponent() {
            return this.selectModulesPanel;
        }

        void start(boolean bl) {
            this.valid = false;
            if (bl) {
                this.selectModulesPanel.reset();
            } else {
                this.setValid(true);
            }
        }

        void end(boolean bl) {
            if (bl && !Wizard.this.canceled) {
                Wizard.this.updates = new XMLUpdates(this.selectModulesPanel.getFiles());
                ((XMLUpdates)Wizard.this.updates).checkDownloadedModules();
                allUpdates.put(this, Wizard.this.updates);
            }
        }
    }

    class LastPanel
    extends WizardPanel {
        ResultsPanel resultsPanel = new ResultsPanel(this, this){
            private final /* synthetic */ LastPanel this$1;
            {
                this.this$1 = lastPanel;
            }

            public Dimension getPreferredSize() {
                return this.this$1.WIZARD_SIZE;
            }
        };

        LastPanel() {
        }

        String getName() {
            return bundle.getString(Wizard.this.wizardType == 0 ? "CTL_ResultsPanel" : "CTL_ResultsPanel_1");
        }

        public Component getComponent() {
            return this.resultsPanel;
        }

        void start(boolean bl) {
            Wizard.this.modulesOK = this.resultsPanel.generateResults();
        }

        void end(boolean bl) {
            if (Wizard.this.wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION && Wizard.this.modulesOK > 0) {
                Autoupdater.Support.LogWriter logWriter = new Autoupdater.Support.LogWriter();
                logWriter.println("-------------------------------------------------------------------------------");
                DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
                logWriter.println("AutoUpdate Session: " + dateFormat.format(new Date()));
                logWriter.println("NBM files to install: ");
                Collection collection = Wizard.getAllModules();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
                    if (!moduleUpdate.isDownloadOK()) continue;
                    if (!moduleUpdate.isInstallApproved()) {
                        Downloader.getNBM(moduleUpdate).delete();
                        Downloader.getNBM(moduleUpdate).deleteOnExit();
                        continue;
                    }
                    if (moduleUpdate.isToInstallDir() && !Downloader.tryMove(moduleUpdate)) {
                        moduleUpdate.setToInstallDir(false);
                    }
                    PreparedModules.getPrepared().addModule(moduleUpdate);
                    logWriter.println("> " + Downloader.getNBM(moduleUpdate).getName());
                    logWriter.println(">  Name: " + moduleUpdate.getRemoteModule().getDisplayName());
                    logWriter.println(">  Version: " + moduleUpdate.getRemoteModule().getSpecificationVersion());
                }
                logWriter.close();
                if (restart) {
                    PreparedModules.getPrepared().delete();
                    Autoupdater.restart();
                } else {
                    PreparedModules.getPrepared().write();
                }
            }
            Autoupdater.setRunning(false);
        }
    }

    class DownloadPanel
    extends WizardPanel {
        private Downloader downloader;
        private SignVerifier signVerifier;
        private ProgressDialog progressPanel = new DownloadProgressPanel(this, this){
            private final /* synthetic */ DownloadPanel this$1;
            {
                this.this$1 = downloadPanel;
            }

            public Dimension getPreferredSize() {
                return this.this$1.WIZARD_SIZE;
            }
        };
        private boolean isDownloadFinished;

        DownloadPanel() {
        }

        public void setValid(boolean bl) {
            if (!this.isDownloadFinished && bl) {
                this.isDownloadFinished = true;
                this.signVerifier = new SignVerifier(this.progressPanel, this);
                this.progressPanel.setLabelText(4, bundle.getString("DownloadProgressPanel.jLabel1.securityText"));
                this.signVerifier.doVerify();
            } else {
                super.setValid(bl);
                this.progressPanel.setLabelText(4, bundle.getString("DownloadProgressPanel.jLabel1.doneText"));
                ((DownloadProgressPanel)this.progressPanel).setEnableStop(false);
            }
        }

        String getName() {
            return bundle.getString(Wizard.this.wizardType == 0 ? "CTL_DownloadPanel" : "CTL_CopyPanel");
        }

        public Component getComponent() {
            return (Component)((Object)this.progressPanel);
        }

        void start(boolean bl) {
            this.valid = false;
            this.isDownloadFinished = false;
            this.downloader = new Downloader(this.progressPanel, this, Wizard.this.wizardType == 0);
            this.progressPanel.setLabelText(4, bundle.getString("DownloadProgressPanel.jLabel1.downloadText"));
            this.downloader.doDownload();
        }

        void end(boolean bl) {
            if (!this.valid) {
                if (!this.isDownloadFinished) {
                    this.downloader.cancelDownload();
                } else {
                    this.signVerifier.cancelVerify(Wizard.this.canceled);
                }
            }
        }
    }

    class ConfigPanel
    extends WizardPanel {
        private UpdatePanel updatePanel = new UpdatePanel(this, this){
            private final /* synthetic */ ConfigPanel this$1;
            {
                this.this$1 = configPanel;
            }

            public Dimension getPreferredSize() {
                return this.this$1.WIZARD_SIZE;
            }
        };

        ConfigPanel() {
        }

        public void setValid(boolean bl) {
            super.setValid(bl);
            if (dialog != null) {
                dialog.repaint();
            }
        }

        String getName() {
            return bundle.getString("CTL_ConfigPanel");
        }

        public Component getComponent() {
            return this.updatePanel;
        }

        public boolean isValid() {
            return this.valid;
        }

        void start(boolean bl) {
            this.valid = false;
            if (bl) {
                PreparedModules.readPrepared();
                Wizard.setRestart(true);
                if (Wizard.this.wizardType == 0) {
                    Iterator iterator = allUpdates.keySet().iterator();
                    while (iterator.hasNext()) {
                        AutoupdateType autoupdateType = (AutoupdateType)((Object)iterator.next());
                        Updates updates = (Updates)allUpdates.get((Object)autoupdateType);
                        autoupdateType.setLastTimeStamp(updates.getTimeStamp());
                    }
                }
            }
            this.updatePanel.setUpdates(Wizard.this.wizardType);
        }

        void end(boolean bl) {
            if (bl) {
                this.updatePanel.markSelectedModules();
                if (!Wizard.this.canceled && !this.updatePanel.checkLicencies()) {
                    Wizard.this.current--;
                }
            }
            this.updatePanel.removeListeners();
        }

        int nextPanelOffset() {
            if (this.updatePanel.modulesToDownload() == 0) {
                return 2;
            }
            return 1;
        }

        void setUpdates(HashMap hashMap) {
            allUpdates.clear();
            allUpdates = hashMap;
        }
    }

    class PropPanel
    extends WizardPanel {
        LoginPanel lPanel = new LoginPanel(this, this){
            private final /* synthetic */ PropPanel this$1;
            {
                this.this$1 = propPanel;
            }

            public Dimension getPreferredSize() {
                return this.this$1.WIZARD_SIZE;
            }
        };
        AutoupdateType currentAT;

        PropPanel() {
        }

        String getName() {
            return bundle.getString("CTL_StartPanel");
        }

        public void setValid(boolean bl) {
        }

        public Component getComponent() {
            return this.lPanel;
        }

        void start(boolean bl) {
            this.currentAT = (AutoupdateType)((Object)Wizard.this.auTypesWithCust.get(0));
            try {
                JPanel jPanel = (JPanel)Introspector.getBeanInfo(((Object)((Object)this.currentAT)).getClass()).getBeanDescriptor().getCustomizerClass().newInstance();
                this.lPanel.setCustomizer(jPanel, this.currentAT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void end(boolean bl) {
            if (Wizard.this.wizardType == 0) {
                Downloader.deleteDownload();
                if (!Wizard.this.canceled && bl) {
                    Wizard.this.updates = this.currentAT.connectForUpdates();
                    Wizard.this.updates.checkUpdates(this, this.currentAT.getName());
                    int n = Wizard.checkConnect(Wizard.this.updates);
                    if (n == 0) {
                        allUpdates.put(this.currentAT, Wizard.this.updates);
                    } else if (n == 1) {
                        if (Wizard.this.updates.isError()) {
                            Wizard.this.current = -1;
                            return;
                        }
                        Wizard.this.current = -2;
                    }
                }
                Wizard.this.auTypesWithCust.remove(0);
            }
        }
    }

    class StartPanel
    extends WizardPanel {
        FirstPanel firstPanel = new FirstPanel(this, this){
            private final /* synthetic */ StartPanel this$1;
            {
                this.this$1 = startPanel;
            }

            public Dimension getPreferredSize() {
                return this.this$1.WIZARD_SIZE;
            }
        };

        StartPanel() {
        }

        String getName() {
            return bundle.getString("CTL_StartPanel");
        }

        public void setValid(boolean bl) {
            Wizard.this.wizardType = this.firstPanel.getWizardType();
        }

        public Component getComponent() {
            return this.firstPanel;
        }

        void end(boolean bl) {
            allUpdates.clear();
            Wizard.this.auTypesWithCust.clear();
            Downloader.deleteDownload();
            if (Wizard.this.wizardType == 0 && !Wizard.this.canceled) {
                int n = 0;
                Enumeration enumeration = AutoupdateType.autoupdateTypes();
                while (enumeration.hasMoreElements()) {
                    AutoupdateType autoupdateType = (AutoupdateType)((Object)enumeration.nextElement());
                    boolean bl2 = false;
                    if (!autoupdateType.isEnabled()) continue;
                    ++n;
                    try {
                        if (Introspector.getBeanInfo(((Object)((Object)autoupdateType)).getClass()).getBeanDescriptor().getCustomizerClass() != null) {
                            Wizard.this.auTypesWithCust.add(autoupdateType);
                            bl2 = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bl2) continue;
                    Wizard.this.updates = autoupdateType.connectForUpdates();
                    Wizard.this.updates.checkUpdates(this, autoupdateType.getName());
                    int n2 = Wizard.checkConnect(Wizard.this.updates);
                    if (n2 == 0) {
                        allUpdates.put(autoupdateType, Wizard.this.updates);
                        continue;
                    }
                    if (n2 != 1) continue;
                    Wizard.this.current = -2;
                    return;
                }
                if (n == 0) {
                    ConnectingErrorDialog.showDialog(3, null);
                    Wizard.this.current = -2;
                    return;
                }
            }
        }
    }

    abstract class WizardPanel
    implements WizardDescriptor.Panel,
    Validator {
        protected Dimension WIZARD_SIZE = new Dimension(550, 400);
        protected boolean valid = true;
        private EventListenerList listenerList = new EventListenerList();
        static /* synthetic */ Class class$javax$swing$event$ChangeListener;

        WizardPanel() {
        }

        void start(boolean bl) {
        }

        void end(boolean bl) {
        }

        int nextPanelOffset() {
            return 1;
        }

        abstract String getName();

        public void setValid(boolean bl) {
            this.valid = bl;
            this.fireChangeListenerStateChanged(this);
        }

        public boolean isValid() {
            return this.valid;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public abstract Component getComponent();

        public void readSettings(Object object) {
        }

        public void storeSettings(Object object) {
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = WizardPanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = WizardPanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        protected void fireChangeListenerStateChanged(Object object) {
            ChangeEvent changeEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? WizardPanel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                    if (changeEvent == null) {
                        changeEvent = new ChangeEvent(object);
                    }
                    ((ChangeListener)objectArray[n + 1]).stateChanged(changeEvent);
                }
                n -= 2;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static interface Validator {
        public void setValid(boolean var1);
    }
}

