/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

public class SelectModulesPanel
extends JPanel {
    private static final String EMPTY_STRING = "";
    private static final javax.swing.filechooser.FileFilter NBM_FILE_FILTER = new NbmFileFilter();
    private DefaultListModel modulesModel;
    File defaultDir = null;
    private Wizard.Validator validator;
    static final long serialVersionUID = 8279789280479374665L;
    private JTextArea jTextArea;
    private JLabel listLabel;
    private JList jList;
    private JButton addButton;
    private JScrollPane jScrollPane1;
    private JLabel nextLabel;
    private JButton removeButton;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle");

    public SelectModulesPanel(Wizard.Validator validator) {
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
        this.setName(bundle.getString("LAB_Select"));
        this.initComponents();
        this.validator = validator;
        this.getAccessibleContext().setAccessibleName(bundle.getString("LAB_Select"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("LAB_21") + bundle.getString("LAB_22"));
        this.jTextArea.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_21"));
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_Add"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_Remove"));
        this.jList.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_InstallList"));
        this.listLabel.setDisplayedMnemonic(bundle.getString("LAB_ModulesList").charAt(0));
        this.reset();
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, super.getPreferredSize().height);
    }

    private void initComponents() {
        this.jTextArea = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.jList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.nextLabel = new JLabel();
        this.listLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jTextArea.setWrapStyleWord(true);
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setFont(new Font("Dialog", 0, 11));
        this.jTextArea.setText(bundle.getString("LAB_21"));
        this.jTextArea.setBackground(this.nextLabel.getBackground());
        this.jTextArea.setDisabledTextColor(Color.black);
        this.jTextArea.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jTextArea, gridBagConstraints);
        this.jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SelectModulesPanel.this.jListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addButton.setMnemonic(bundle.getString("BTN_Add_Mnemonic").charAt(0));
        this.addButton.setText(bundle.getString("BTN_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectModulesPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setMnemonic(bundle.getString("BTN_Remove_Mnemonic").charAt(0));
        this.removeButton.setText(bundle.getString("BTN_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectModulesPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.removeButton, gridBagConstraints);
        this.nextLabel.setText(bundle.getString("LAB_22"));
        this.nextLabel.setForeground(Color.black);
        this.nextLabel.setLabelFor(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.nextLabel, gridBagConstraints);
        this.listLabel.setText(bundle.getString("LAB_ModulesList"));
        this.listLabel.setLabelFor(this.jList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.listLabel, gridBagConstraints);
    }

    private void jListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.buttonsCheck();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.jList.getSelectedValues();
        int n = 0;
        while (n < objectArray.length) {
            this.modulesModel.removeElement(objectArray[n]);
            ++n;
        }
        this.jList.setSelectionModel(new DefaultListSelectionModel());
        if (this.modulesModel.getSize() == 0) {
            this.validator.setValid(false);
        }
        this.buttonsCheck();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.addChoosableFileFilter(NBM_FILE_FILTER);
        jFileChooser.setFileFilter(NBM_FILE_FILTER);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setDialogTitle(bundle.getString("CTL_FileChooser_Title"));
        if (this.defaultDir != null) {
            jFileChooser.setCurrentDirectory(this.defaultDir);
        }
        if (jFileChooser.showDialog(TopManager.getDefault().getWindowManager().getMainWindow(), bundle.getString("CTL_FileChooser_Approve_Button")) == 0) {
            File[] fileArray;
            File[] fileArray2 = jFileChooser.getSelectedFiles();
            File file = null;
            ArrayList<File> arrayList = new ArrayList<File>();
            int n = 0;
            while (n < fileArray2.length) {
                file = fileArray2[n];
                if (file.isDirectory()) {
                    fileArray = file.listFiles(new FileFilter(){

                        public boolean accept(File file) {
                            return !file.isDirectory() && file.getName().toUpperCase().endsWith(".NBM");
                        }
                    });
                    if (fileArray != null) {
                        arrayList.addAll(Arrays.asList(fileArray));
                        if (arrayList.size() == 0) {
                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)bundle.getString("MSG_NoNbmInDir"), 2));
                        }
                    } else {
                        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)bundle.getString("MSG_CannotReadDir"), 2));
                    }
                } else {
                    arrayList.add(file);
                }
                ++n;
            }
            fileArray = arrayList.iterator();
            int n2 = 0;
            while (fileArray.hasNext()) {
                File file2;
                if (n2 == 0) {
                    this.validator.setValid(true);
                }
                if (!this.selectedFile(file2 = (File)fileArray.next())) {
                    this.modulesModel.addElement(file2);
                }
                ++n2;
            }
        }
        this.defaultDir = jFileChooser.getCurrentDirectory();
        this.buttonsCheck();
    }

    private boolean selectedFile(File file) {
        int n = 0;
        while (n < this.modulesModel.size()) {
            if (((File)this.modulesModel.elementAt(n)).compareTo(file) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    File[] getFiles() {
        File[] fileArray = new File[this.modulesModel.size()];
        int n = 0;
        while (n < this.modulesModel.size()) {
            fileArray[n] = (File)this.modulesModel.elementAt(n);
            ++n;
        }
        return fileArray;
    }

    void reset() {
        if (this.modulesModel == null) {
            this.modulesModel = new DefaultListModel();
            this.jList.setModel(this.modulesModel);
        } else {
            this.modulesModel.removeAllElements();
        }
        this.buttonsCheck();
    }

    private void buttonsCheck() {
        if (this.modulesModel.getSize() > 0 && this.jList.getSelectedIndex() != -1) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    private static class NbmFileFilter
    extends javax.swing.filechooser.FileFilter {
        private NbmFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".nbm") || file.isDirectory();
        }

        public String getDescription() {
            return bundle.getString("CTL_FileFilterDescription");
        }
    }
}

