/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.modules.autoupdate.IdeDescription;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

class DependencyChecker {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$autoupdate$DependencyChecker == null ? (class$org$netbeans$modules$autoupdate$DependencyChecker = DependencyChecker.class$("org.netbeans.modules.autoupdate.DependencyChecker")) : class$org$netbeans$modules$autoupdate$DependencyChecker));
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$DependencyChecker;

    DependencyChecker() {
    }

    Collection modulesToAdd(ModuleUpdate moduleUpdate) {
        ArrayList arrayList = new ArrayList();
        this.checkDependencies(moduleUpdate.getRemoteModule(), arrayList);
        return arrayList;
    }

    Collection modulesToRemove(ModuleUpdate moduleUpdate) {
        ArrayList arrayList = new ArrayList();
        this.checkReverseDependencies(moduleUpdate.getRemoteModule(), arrayList);
        return arrayList;
    }

    boolean checkDependencies(ModuleInfo moduleInfo, Collection collection) {
        int n;
        StringBuffer stringBuffer;
        Set set = moduleInfo.getDependencies();
        Dependency[] dependencyArray = set.toArray(new Dependency[set.size()]);
        boolean[] blArray = new boolean[dependencyArray.length];
        ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
        ModuleInfo[] moduleInfoArray2 = Updates.getInstalledPatches();
        int n2 = 0;
        while (n2 < dependencyArray.length) {
            stringBuffer = null;
            if (dependencyArray[n2].getType() == 1) {
                boolean bl = false;
                n = 0;
                while (n < moduleInfoArray.length) {
                    bl = this.checkModuleDependency(dependencyArray[n2], moduleInfoArray[n]);
                    if (bl) break;
                    ++n;
                }
                if (!bl) {
                    int n3 = 0;
                    while (n3 < moduleInfoArray2.length) {
                        bl = this.checkModuleDependency(dependencyArray[n2], moduleInfoArray2[n3]);
                        if (bl) break;
                        ++n3;
                    }
                }
                if (!bl) {
                    Iterator iterator = Wizard.getAllModules().iterator();
                    while (iterator.hasNext()) {
                        ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
                        bl = this.checkModuleDependency(dependencyArray[n2], moduleUpdate.getRemoteModule());
                        if (!bl) continue;
                        if (collection.contains(moduleUpdate)) break;
                        collection.add(moduleUpdate);
                        break;
                    }
                }
                blArray[n2] = bl;
            } else if (dependencyArray[n2].getType() == 4) {
                if (this.checkIdeDependency(dependencyArray[n2], IdeDescription.getIdeDescription())) {
                    blArray[n2] = true;
                } else {
                    Iterator iterator = Wizard.getAllModules().iterator();
                    n = 0;
                    while (iterator.hasNext()) {
                        ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
                        n = this.checkModuleDependency(dependencyArray[n2], moduleUpdate.getRemoteModule()) ? 1 : 0;
                        if (n == 0) continue;
                        if (collection.contains(moduleUpdate)) break;
                        collection.add(moduleUpdate);
                        break;
                    }
                    blArray[n2] = n;
                }
            } else {
                blArray[n2] = true;
            }
            ++n2;
        }
        stringBuffer = new StringBuffer(200);
        stringBuffer.append(bundle.getString("MSG_NotSatisfied") + "MODULE :" + moduleInfo.getCodeName());
        int n4 = 0;
        n = 0;
        while (n < dependencyArray.length) {
            if (!blArray[n]) {
                stringBuffer.append(dependencyArray[n]);
                ++n4;
            }
            ++n;
        }
        if (n4 == 0) {
            return true;
        }
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)stringBuffer.toString(), 0);
        TopManager.getDefault().notify((NotifyDescriptor)message);
        return false;
    }

    boolean checkReverseDependencies(ModuleInfo moduleInfo, Collection collection) {
        ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
        ModuleInfo[] moduleInfoArray2 = Updates.getInstalledPatches();
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
            ModuleInfo moduleInfo2 = moduleUpdate.getRemoteModule();
            Set set = moduleInfo2.getDependencies();
            Dependency[] dependencyArray = set.toArray(new Dependency[set.size()]);
            boolean bl = true;
            int n = 0;
            while (n < dependencyArray.length) {
                if (dependencyArray[n].getType() == 1 && dependencyArray[n].getName().equals(moduleInfo.getCodeName())) {
                    boolean bl2 = false;
                    int n2 = 0;
                    while (n2 < moduleInfoArray.length) {
                        bl2 = this.checkModuleDependency(dependencyArray[n], moduleInfoArray[n2]);
                        if (bl2) break;
                        ++n2;
                    }
                    int n3 = 0;
                    while (n3 < moduleInfoArray2.length) {
                        bl2 = this.checkModuleDependency(dependencyArray[n], moduleInfoArray2[n3]);
                        if (bl2) break;
                        ++n3;
                    }
                    if (!bl2) {
                        bl = false;
                        break;
                    }
                } else if (dependencyArray[n].getType() == 4 && dependencyArray[n].getName().equals(moduleInfo.getCodeName()) && !this.checkModuleDependency(dependencyArray[n], IdeDescription.getIdeDescription())) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl || collection.contains(moduleUpdate)) continue;
            collection.add(moduleUpdate);
        }
        return collection.size() == 0;
    }

    boolean checkModuleDependency(Dependency dependency, ModuleInfo moduleInfo) {
        boolean bl = false;
        if (dependency.getName().equals(moduleInfo.getCodeName())) {
            if (dependency.getComparison() == 3) {
                return true;
            }
            if (dependency.getComparison() == 1) {
                if (moduleInfo.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) <= 0;
            }
            if (moduleInfo.getImplementationVersion() == null) {
                return false;
            }
            return moduleInfo.getImplementationVersion().equals(dependency.getVersion());
        }
        return false;
    }

    boolean checkIdeDependency(Dependency dependency, ModuleInfo moduleInfo) {
        String string = moduleInfo.getCodeName();
        SpecificationVersion specificationVersion = moduleInfo.getSpecificationVersion();
        String string2 = moduleInfo.getImplementationVersion();
        if (!string.equals(dependency.getName())) {
            return false;
        }
        if (dependency.getComparison() == 1) {
            return new SpecificationVersion(dependency.getVersion()).compareTo((Object)specificationVersion) <= 0;
        }
        if (dependency.getComparison() == 2) {
            return dependency.getVersion().equals(string2);
        }
        throw new IllegalStateException("Cannot have COMPARE_ANY on IDE dependency");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

