/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Date;
import org.netbeans.lib.cvsclient.file.DefaultTransmitTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.DefaultWriteTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.lib.cvsclient.file.TransmitTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.WriteTextFilePreprocessor;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class DefaultFileHandler
implements FileHandler {
    private static final boolean DEBUG = false;
    private static final int CHUNK_SIZE = 32768;
    private Date modifiedDate = null;
    private TransmitTextFilePreprocessor transmitTextFilePreprocessor;
    private WriteTextFilePreprocessor writeTextFilePreprocessor;

    public DefaultFileHandler() {
        this.setTransmitTextFilePreprocessor(new DefaultTransmitTextFilePreprocessor());
        this.setWriteTextFilePreprocessor(new DefaultWriteTextFilePreprocessor());
    }

    public TransmitTextFilePreprocessor getTransmitTextFilePreprocessor() {
        return this.transmitTextFilePreprocessor;
    }

    public void setTransmitTextFilePreprocessor(TransmitTextFilePreprocessor transmitTextFilePreprocessor) {
        this.transmitTextFilePreprocessor = transmitTextFilePreprocessor;
    }

    public WriteTextFilePreprocessor getWriteTextFilePreprocessor() {
        return this.writeTextFilePreprocessor;
    }

    public void setWriteTextFilePreprocessor(WriteTextFilePreprocessor writeTextFilePreprocessor) {
        this.writeTextFilePreprocessor = writeTextFilePreprocessor;
    }

    protected String getLengthString(long l) {
        return String.valueOf(l) + "\n";
    }

    protected Reader getProcessedReader(File file) throws IOException {
        return new FileReader(file);
    }

    protected InputStream getProcessedInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    public Request[] getInitialisationRequests() {
        return null;
    }

    public void transmitTextFile(File file, LoggedDataOutputStream loggedDataOutputStream) throws IOException {
        TransmitTextFilePreprocessor transmitTextFilePreprocessor;
        File file2;
        block11: {
            if (file == null || !file.exists()) {
                throw new IllegalArgumentException("File is either null or does not exist. Cannot transmit.");
            }
            file2 = file;
            transmitTextFilePreprocessor = this.getTransmitTextFilePreprocessor();
            if (transmitTextFilePreprocessor != null) {
                file2 = transmitTextFilePreprocessor.getPreprocessedTextFile(file);
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                long l = file2.length();
                loggedDataOutputStream.writeBytes(this.getLengthString(l));
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                byte[] byArray = new byte[32768];
                while (l > 0L) {
                    int n = l >= 32768L ? 32768 : (int)l;
                    int n2 = bufferedInputStream.read(byArray, 0, n);
                    l -= (long)n2;
                    loggedDataOutputStream.write(byArray, 0, n2);
                }
                loggedDataOutputStream.flush();
                Object var12_10 = null;
                if (bufferedInputStream == null) break block11;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (transmitTextFilePreprocessor != null) {
                    transmitTextFilePreprocessor.cleanup(file2);
                }
                throw throwable;
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (transmitTextFilePreprocessor != null) {
            transmitTextFilePreprocessor.cleanup(file2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transmitBinaryFile(File file, LoggedDataOutputStream loggedDataOutputStream) throws IOException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("File is either null or does not exist. Cannot transmit.");
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            long l = file.length();
            loggedDataOutputStream.writeBytes(this.getLengthString(l));
            byte[] byArray = new byte[32768];
            while (l > 0L) {
                int n = l >= 32768L ? 32768 : (int)l;
                int n2 = bufferedInputStream.read(byArray, 0, n);
                l -= (long)n2;
                loggedDataOutputStream.write(byArray, 0, n2);
            }
            loggedDataOutputStream.flush();
            Object var10_8 = null;
            if (bufferedInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        try {
            bufferedInputStream.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTextFile(String string, String string2, LoggedDataInputStream loggedDataInputStream, int n) throws IOException {
        File file = new File(string);
        file.getParentFile().mkdirs();
        file.createNewFile();
        File file2 = File.createTempFile("cvsCRLF", "tmp");
        try {
            block10: {
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    byte[] byArray = new byte[32768];
                    while (true) {
                        if (n <= 0) {
                            Object var11_11 = null;
                            if (bufferedOutputStream == null) break block10;
                            break;
                        }
                        int n2 = n >= 32768 ? 32768 : n;
                        n2 = loggedDataInputStream.read(byArray, 0, n2);
                        n -= n2;
                        ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (bufferedOutputStream == null) throw throwable;
                    try {
                        ((OutputStream)bufferedOutputStream).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                ((OutputStream)bufferedOutputStream).close();
            }
            BufferedReader bufferedReader = new BufferedReader(this.getProcessedReader(file2));
            this.getWriteTextFilePreprocessor().copyTextFileToLocation(bufferedReader, file);
            if (this.modifiedDate != null) {
                file.setLastModified(this.modifiedDate.getTime());
                this.modifiedDate = null;
            }
            Object var14_16 = null;
            file2.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            file2.delete();
            throw throwable;
        }
    }

    public void writeBinaryFile(String string, String string2, LoggedDataInputStream loggedDataInputStream, int n) throws IOException {
        File file = new File(string);
        file.getParentFile().mkdirs();
        file.createNewFile();
        File file2 = File.createTempFile("cvsPostConversion", "tmp");
        try {
            int n2;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            byte[] byArray = new byte[32768];
            while (n > 0) {
                int n3 = n >= 32768 ? 32768 : n;
                n2 = loggedDataInputStream.read(byArray, 0, n3);
                if (n2 < 0) break;
                n -= n2;
                bufferedOutputStream.write(byArray, 0, n2);
            }
            bufferedOutputStream.close();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getProcessedInputStream(file2));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            n2 = bufferedInputStream.read(byArray, 0, 32768);
            while (n2 > 0) {
                bufferedOutputStream.write(byArray, 0, n2);
                n2 = bufferedInputStream.read(byArray, 0, 32768);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
            if (this.modifiedDate != null) {
                file.setLastModified(this.modifiedDate.getTime());
                this.modifiedDate = null;
            }
            Object var12_12 = null;
            file2.delete();
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            file2.delete();
            throw throwable;
        }
    }

    public void removeLocalFile(String string) throws IOException {
        File file = new File(string);
        if (!file.delete()) {
            System.err.println("Could not delete file " + file.getAbsolutePath());
        }
    }

    public void renameLocalFile(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(file.getParentFile(), string2);
        file.renameTo(file2);
    }

    public void setNextFileDate(Date date) {
        this.modifiedDate = date;
    }
}

