/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import java.io.IOException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class ServerConnection
implements Connection {
    protected String repository;
    protected LoggedDataInputStream inputStream;
    protected LoggedDataOutputStream outputStream;
    protected Process process;

    public LoggedDataInputStream getInputStream() {
        return this.inputStream;
    }

    public LoggedDataOutputStream getOutputStream() {
        return this.outputStream;
    }

    private void openConnection() throws AuthenticationException {
        try {
            this.process = Runtime.getRuntime().exec("cvs server");
            this.outputStream = new LoggedDataOutputStream(this.process.getOutputStream());
            this.inputStream = new LoggedDataInputStream(this.process.getInputStream());
        }
        catch (Throwable throwable) {
            String string = AuthenticationException.getBundleString("AuthenticationException.ServerConnection");
            throw new AuthenticationException("Connection error", throwable, string);
        }
    }

    public void verify() throws AuthenticationException {
        try {
            this.process = Runtime.getRuntime().exec("cvs server");
            this.process.destroy();
        }
        catch (Exception exception) {
            String string = AuthenticationException.getBundleString("AuthenticationException.ServerVerification");
            throw new AuthenticationException("Verification error", exception, string);
        }
    }

    public void open() throws AuthenticationException {
        this.openConnection();
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String string) {
        this.repository = string;
    }

    public void close() throws IOException {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void modifyInputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyInputStream(this.inputStream);
    }

    public void modifyOutputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyOutputStream(this.outputStream);
    }
}

