/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.update;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.PipedFilesBuilder;
import org.netbeans.lib.cvsclient.command.TemporaryFileCreator;
import org.netbeans.lib.cvsclient.command.update.UpdateBuilder;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.UnchangedRequest;

public class UpdateCommand
extends BasicCommand
implements TemporaryFileCreator {
    private static final String RENAME_FORMAT = "{0}/.#{1}.{2}";
    private static final Object[] FORMAT_PARAMETER = new Object[3];
    private final Set emptyDirectories = new HashSet();
    private boolean buildDirectories;
    private boolean cleanCopy;
    private boolean pruneDirectories;
    private boolean pipeToOutput;
    private boolean resetStickyOnes;
    private boolean useHeadIfNotFound;
    private String updateByDate;
    private String updateByRevision;
    private KeywordSubstitutionOptions keywordSubst;
    private String mergeRevision1;
    private String mergeRevision2;

    public UpdateCommand() {
        this.resetCVSCommand();
    }

    public Builder createBuilder(EventManager eventManager) {
        if (this.isPipeToOutput()) {
            return new PipedFilesBuilder(eventManager, this, this);
        }
        return new UpdateBuilder(eventManager, this.getLocalPath());
    }

    protected void sendEntryAndModifiedRequests(Entry entry, File file) {
        if (this.isCleanCopy() && file != null && entry != null) {
            if (!this.isPipeToOutput()) {
                UpdateCommand.FORMAT_PARAMETER[0] = file.getParent();
                UpdateCommand.FORMAT_PARAMETER[1] = file.getName();
                UpdateCommand.FORMAT_PARAMETER[2] = entry.getRevision();
                String string = MessageFormat.format(RENAME_FORMAT, FORMAT_PARAMETER);
                file.renameTo(new File(string));
            }
            file = null;
        }
        super.sendEntryAndModifiedRequests(entry, file);
    }

    public void setBuildDirectories(boolean bl) {
        this.buildDirectories = bl;
    }

    public boolean isBuildDirectories() {
        return this.buildDirectories;
    }

    public void setCleanCopy(boolean bl) {
        this.cleanCopy = bl;
    }

    public boolean isCleanCopy() {
        return this.cleanCopy;
    }

    public void setPruneDirectories(boolean bl) {
        this.pruneDirectories = bl;
    }

    public boolean isPruneDirectories() {
        return this.pruneDirectories;
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        super.execute(clientServices, eventManager);
        this.emptyDirectories.clear();
        try {
            block20: {
                try {
                    if (this.isBuildDirectories()) {
                        this.requests.add(1, new ArgumentRequest("-d"));
                    }
                    if (this.isCleanCopy() && !this.isPipeToOutput()) {
                        this.requests.add(1, new ArgumentRequest("-C"));
                    }
                    if (this.isPipeToOutput()) {
                        this.requests.add(1, new ArgumentRequest("-p"));
                    }
                    if (this.isResetStickyOnes()) {
                        this.requests.add(1, new ArgumentRequest("-A"));
                    }
                    if (this.isUseHeadIfNotFound()) {
                        this.requests.add(1, new ArgumentRequest("-f"));
                    }
                    if (this.getUpdateByDate() != null) {
                        this.requests.add(1, new ArgumentRequest("-D"));
                        this.requests.add(2, new ArgumentRequest(this.getUpdateByDate()));
                    } else if (this.getUpdateByRevision() != null) {
                        this.requests.add(1, new ArgumentRequest("-r"));
                        this.requests.add(2, new ArgumentRequest(this.getUpdateByRevision()));
                    }
                    if (this.getMergeRevision1() != null) {
                        this.requests.add(1, new ArgumentRequest("-j"));
                        this.requests.add(2, new ArgumentRequest(this.getMergeRevision1()));
                        if (this.getMergeRevision2() != null) {
                            this.requests.add(1, new ArgumentRequest("-j"));
                            this.requests.add(2, new ArgumentRequest(this.getMergeRevision2()));
                        }
                    }
                    if (this.getKeywordSubst() != null) {
                        this.requests.add(1, new ArgumentRequest("-k"));
                        this.requests.add(2, new ArgumentRequest(this.getKeywordSubst().toString()));
                    }
                    this.requests.add(new DirectoryRequest(".", clientServices.getRepositoryForDirectory(this.getLocalPath())));
                    this.addArgumentRequests();
                    this.requests.add(CommandRequest.UPDATE);
                    if (this.isPipeToOutput() && (this.getUpdateByRevision() != null || this.getUpdateByDate() != null)) {
                        ListIterator<Request> listIterator = this.requests.listIterator();
                        while (listIterator.hasNext()) {
                            Object e = listIterator.next();
                            if (!(e instanceof EntryRequest)) continue;
                            EntryRequest entryRequest = (EntryRequest)e;
                            Entry entry = entryRequest.getEntry();
                            if (entry.getRevision().startsWith("-")) {
                                entry.setRevision(entry.getRevision().substring(1));
                            }
                            listIterator.set(new EntryRequest(entry));
                            listIterator.add(new UnchangedRequest(entry.getName()));
                        }
                    }
                    clientServices.processRequests(this.requests);
                    if (!this.pruneDirectories) break block20;
                    this.pruneEmptyDirectories(clientServices);
                }
                catch (CommandException commandException) {
                    throw commandException;
                }
                catch (EOFException eOFException) {
                    throw new CommandException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
                }
                catch (Exception exception) {
                    throw new CommandException(exception, exception.getLocalizedMessage());
                }
            }
            Object var8_10 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    public boolean isPipeToOutput() {
        return this.pipeToOutput;
    }

    public void setPipeToOutput(boolean bl) {
        this.pipeToOutput = bl;
    }

    public boolean isResetStickyOnes() {
        return this.resetStickyOnes;
    }

    public void setResetStickyOnes(boolean bl) {
        this.resetStickyOnes = bl;
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean bl) {
        this.useHeadIfNotFound = bl;
    }

    public String getUpdateByDate() {
        return this.updateByDate;
    }

    public void setUpdateByDate(String string) {
        this.updateByDate = Command.getTrimmedString(string);
    }

    public String getUpdateByRevision() {
        return this.updateByRevision;
    }

    public void setUpdateByRevision(String string) {
        this.updateByRevision = Command.getTrimmedString(string);
    }

    public KeywordSubstitutionOptions getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(KeywordSubstitutionOptions keywordSubstitutionOptions) {
        this.keywordSubst = keywordSubstitutionOptions;
    }

    public File createTempFile(String string) throws IOException {
        File file = File.createTempFile("cvs", ".dff");
        return file;
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("update ");
        stringBuffer.append(this.getCVSArguments());
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                stringBuffer.append(fileArray[n].getName());
                stringBuffer.append(' ');
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isPipeToOutput()) {
            stringBuffer.append("-p ");
        }
        if (this.isCleanCopy()) {
            stringBuffer.append("-C ");
        }
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.isBuildDirectories()) {
            stringBuffer.append("-d ");
        }
        if (this.isPruneDirectories()) {
            stringBuffer.append("-P ");
        }
        if (this.isResetStickyOnes()) {
            stringBuffer.append("-A ");
        }
        if (this.isUseHeadIfNotFound()) {
            stringBuffer.append("-f ");
        }
        if (this.getKeywordSubst() != null) {
            stringBuffer.append("-k");
            stringBuffer.append(this.getKeywordSubst().toString());
            stringBuffer.append(' ');
        }
        if (this.getUpdateByRevision() != null) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getUpdateByRevision());
            stringBuffer.append(' ');
        }
        if (this.getUpdateByDate() != null) {
            stringBuffer.append("-D ");
            stringBuffer.append(this.getUpdateByDate());
            stringBuffer.append(' ');
        }
        if (this.getMergeRevision1() != null) {
            stringBuffer.append("-j ");
            stringBuffer.append(this.getMergeRevision1());
            stringBuffer.append(' ');
            if (this.getMergeRevision2() != null) {
                stringBuffer.append("-j ");
                stringBuffer.append(this.getMergeRevision2());
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'C') {
            this.setCleanCopy(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'd') {
            this.setBuildDirectories(true);
        } else if (c == 'P') {
            this.setPruneDirectories(true);
        } else if (c == 'A') {
            this.setResetStickyOnes(true);
        } else if (c == 'f') {
            this.setUseHeadIfNotFound(true);
        } else if (c == 'D') {
            this.setUpdateByDate(string.trim());
        } else if (c == 'r') {
            this.setUpdateByRevision(string.trim());
        } else if (c == 'k') {
            KeywordSubstitutionOptions keywordSubstitutionOptions = KeywordSubstitutionOptions.findKeywordSubstOption(string);
            this.setKeywordSubst(keywordSubstitutionOptions);
        } else if (c == 'p') {
            this.setPipeToOutput(true);
        } else if (c == 'j') {
            if (this.getMergeRevision1() == null) {
                this.setMergeRevision1(string);
            } else {
                this.setMergeRevision2(string);
            }
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setCleanCopy(false);
        this.setBuildDirectories(false);
        this.setPruneDirectories(false);
        this.setResetStickyOnes(false);
        this.setUseHeadIfNotFound(false);
        this.setUpdateByDate(null);
        this.setUpdateByRevision(null);
        this.setKeywordSubst(null);
        this.setPipeToOutput(false);
        this.setMergeRevision1(null);
        this.setMergeRevision2(null);
    }

    public void messageSent(MessageEvent messageEvent) {
        super.messageSent(messageEvent);
        if (this.pruneDirectories && messageEvent.getMessage().startsWith("cvs server: Updating ")) {
            String string = messageEvent.getMessage().substring(21);
            if (string.equals(".")) {
                return;
            }
            File file = new File(this.getLocalPath(), string);
            this.emptyDirectories.add(file);
        }
    }

    private boolean pruneEmptyDirectory(File file, ClientServices clientServices) throws IOException {
        boolean bl = true;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            File file2;
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isFile()) {
                    bl = false;
                } else if (!fileArray[n].getName().equals("CVS")) {
                    bl = this.pruneEmptyDirectory(fileArray[n], clientServices);
                }
                if (!bl) break;
                ++n;
            }
            if (bl && (file2 = new File(file, "CVS/Entries")).exists()) {
                File file3 = new File(file, "CVS");
                File[] fileArray2 = file3.listFiles();
                int n2 = 0;
                while (n2 < fileArray2.length) {
                    fileArray2[n2].delete();
                    ++n2;
                }
                file3.delete();
                file.delete();
                clientServices.removeEntry(file);
            }
        }
        return bl;
    }

    private void pruneEmptyDirectories(ClientServices clientServices) throws IOException {
        Iterator iterator = this.emptyDirectories.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists()) continue;
            this.pruneEmptyDirectory(file, clientServices);
        }
        this.emptyDirectories.clear();
    }

    public String getOptString() {
        return "RCnldPAfD:r:pj:k:";
    }

    public String getMergeRevision1() {
        return this.mergeRevision1;
    }

    public void setMergeRevision1(String string) {
        this.mergeRevision1 = Command.getTrimmedString(string);
    }

    public String getMergeRevision2() {
        return this.mergeRevision2;
    }

    public void setMergeRevision2(String string) {
        this.mergeRevision2 = Command.getTrimmedString(string);
    }
}

