/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.status;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.status.StatusBuilder;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;

public class StatusCommand
extends BasicCommand {
    private EventManager eventManager;
    private boolean includeTags;

    public Builder createBuilder(EventManager eventManager) {
        return new StatusBuilder(eventManager, this);
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        this.eventManager = eventManager;
        super.execute(clientServices, eventManager);
        try {
            try {
                if (this.includeTags) {
                    this.requests.add(1, new ArgumentRequest("-v"));
                }
                this.requests.add(new DirectoryRequest(".", clientServices.getRepositoryForDirectory(this.getLocalPath())));
                this.addArgumentRequests();
                this.requests.add(CommandRequest.STATUS);
                clientServices.processRequests(this.requests);
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (Exception exception) {
                throw new CommandException(exception, exception.getLocalizedMessage());
            }
            Object var6_3 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    public boolean isIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeTags(boolean bl) {
        this.includeTags = bl;
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("status ");
        stringBuffer.append(this.getCVSArguments());
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                stringBuffer.append(fileArray[n].getName());
                stringBuffer.append(' ');
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'v') {
            this.setIncludeTags(true);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rlv";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setIncludeTags(false);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isIncludeTags()) {
            stringBuffer.append("-v ");
        }
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        return stringBuffer.toString();
    }
}

