/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.ModifiedRequest;
import org.netbeans.lib.cvsclient.request.QuestionableRequest;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.StickyRequest;
import org.netbeans.lib.cvsclient.request.UnchangedRequest;

public abstract class BasicCommand
extends BuildableCommand {
    protected List requests = new LinkedList();
    protected ClientServices clientServices;
    private boolean recursive = true;
    protected File[] files;

    public boolean getRecursive() {
        return this.recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public void setFiles(File[] fileArray) {
        if (fileArray == null) {
            this.files = fileArray;
            return;
        }
        this.files = new File[fileArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = fileArray.length;
        int n4 = 0;
        while (n4 < n3) {
            File file = fileArray[n4];
            if (file.isDirectory()) {
                this.files[n3 - (1 + n2)] = file;
                ++n2;
            } else {
                this.files[n] = file;
                ++n;
            }
            ++n4;
        }
    }

    public File[] getFiles() {
        return this.files;
    }

    public File getXthFile(int n) {
        if (n < 0 || n >= this.files.length) {
            return null;
        }
        File file = this.files[n];
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    public File getFileEndingWith(String string) {
        int n = 0;
        n = 0;
        while (n < this.files.length) {
            String string2 = this.files[n].getAbsolutePath();
            if ((string2 = string2.replace('\\', '/')).endsWith(string)) {
                return this.files[n];
            }
            ++n;
        }
        return null;
    }

    protected void addRequests(File file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("Cannot add requests for a null path.");
        }
        if (!file.exists() || file.isFile()) {
            this.addRequestsForFile(file);
        } else {
            this.addRequestsForDirectory(file);
        }
    }

    protected boolean doesCheckFileTime() {
        return true;
    }

    protected void sendEntryAndModifiedRequests(Entry entry, File file) {
        if (entry == null) {
            return;
        }
        if (file != null && !file.exists() && entry.isNewUserFile()) {
            return;
        }
        Date date = entry.getLastModified();
        boolean bl = entry.hadConflicts();
        if (!bl) {
            entry.setConflict(null);
        }
        this.requests.add(new EntryRequest(entry));
        if (file == null || !file.exists() || entry.isUserFileToBeRemoved()) {
            return;
        }
        if (this.doesCheckFileTime() && !bl && date != null && date.getTime() / 1000L == file.lastModified() / 1000L) {
            this.requests.add(new UnchangedRequest(file.getName()));
            return;
        }
        this.requests.add(new ModifiedRequest(file, entry.isBinary()));
    }

    protected void addRequestsForDirectory(File file) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (!file.exists()) {
            return;
        }
        String string = this.getRelativeToLocalPathInUnixStyle(file);
        try {
            object4 = this.clientServices.getRepositoryForDirectory(file.getAbsolutePath());
            this.requests.add(new DirectoryRequest(string, (String)object4));
            object3 = this.clientServices.getStickyTagForDirectory(file);
            if (object3 != null) {
                this.requests.add(new StickyRequest((String)object3));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.err.println("An error occurred reading the repository for the directory " + string + ": " + iOException);
            iOException.printStackTrace();
        }
        object4 = new LinkedList();
        object3 = file.listFiles();
        if (object3 != null) {
            int n = 0;
            while (n < ((File[])object3).length) {
                if (!object3[n].isDirectory()) {
                    object4.add(object3[n]);
                }
                ++n;
            }
        }
        LinkedList<File> linkedList = null;
        if (this.isRecursive()) {
            linkedList = new LinkedList<File>();
        }
        Iterator iterator = this.clientServices.getEntries(file);
        while (iterator.hasNext()) {
            object2 = (Entry)iterator.next();
            if (((Entry)object2).isDirectory()) {
                if (!this.isRecursive()) continue;
                linkedList.add(new File(file, ((Entry)object2).getName()));
                continue;
            }
            object = new File(file, ((Entry)object2).getName());
            this.sendEntryAndModifiedRequests((Entry)object2, (File)object);
            object4.remove(object);
        }
        if (object4.size() > 0) {
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = ((File)object2.next()).getName();
                if (this.clientServices.shouldBeIgnored(file, (String)object)) continue;
                this.requests.add(new QuestionableRequest((String)object));
            }
        }
        if (this.isRecursive()) {
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                object = (File)object2.next();
                this.addRequestsForDirectory((File)object);
            }
        }
    }

    protected void addRequestsForFile(File file) throws IOException {
        Object object;
        File file2 = file.getParentFile();
        String string = this.getRelativeToLocalPathInUnixStyle(file2);
        try {
            object = this.clientServices.getRepositoryForDirectory(file2.getAbsolutePath());
            this.requests.add(new DirectoryRequest(string, (String)object));
            String string2 = this.clientServices.getStickyTagForDirectory(file2);
            if (string2 != null) {
                this.requests.add(new StickyRequest(string2));
            }
        }
        catch (IOException iOException) {
            System.err.println("An error occurred reading the respository for the directory " + string + ": " + iOException);
            iOException.printStackTrace();
        }
        try {
            object = this.clientServices.getEntry(file);
            if (object != null) {
                this.sendEntryAndModifiedRequests((Entry)object, file);
            }
        }
        catch (IOException iOException) {
            System.err.println("An error occurred getting the Entry for file " + file + ": " + iOException);
            iOException.printStackTrace();
        }
    }

    protected void addArgumentRequests() {
        if (this.files == null) {
            return;
        }
        int n = 0;
        while (n < this.files.length) {
            File file = this.files[n];
            String string = this.getRelativeToLocalPathInUnixStyle(file);
            this.requests.add(new ArgumentRequest(string));
            ++n;
        }
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        this.requests.clear();
        super.execute(clientServices, eventManager);
        this.clientServices = clientServices;
        if (clientServices.isFirstCommand()) {
            this.requests.add(new RootRequest(clientServices.getRepository()));
        }
        try {
            if (this.files != null && this.files.length > 0) {
                int n = 0;
                while (n < this.files.length) {
                    this.addRequests(this.files[n]);
                    ++n;
                }
            } else if (this.assumeLocalPathWhenUnspecified()) {
                this.addRequests(new File(this.getLocalPath()));
            }
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
    }

    protected boolean assumeLocalPathWhenUnspecified() {
        return true;
    }
}

